/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.dex.file;

import com.android.dx.dex.file.DexFile;
import com.android.dx.dex.file.Item;
import com.android.dx.dex.file.MemberIdItem;
import com.android.dx.dex.file.MethodIdsSection;
import com.android.dx.dex.file.UniformItemSection;
import com.android.dx.util.DexException;
import java.util.Formatter;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class MemberIdsSection
extends UniformItemSection {
    private static final int MAX_MEMBERS = 65536;

    public MemberIdsSection(String string, DexFile dexFile) {
        super(string, dexFile, 4);
    }

    protected void orderItems() {
        int n = 0;
        if (this.items().size() > 65536) {
            throw new DexException(this.tooManyMembersMessage());
        }
        for (Item item : this.items()) {
            ((MemberIdItem)item).setIndex(n);
            ++n;
        }
    }

    /*
     * WARNING - void declaration
     */
    private String tooManyMembersMessage() {
        TreeMap<String, AtomicInteger> treeMap = new TreeMap<String, AtomicInteger>();
        for (Item object2 : this.items()) {
            void var5_6;
            String string = ((MemberIdItem)object2).getDefiningClass().getPackageName();
            AtomicInteger atomicInteger = (AtomicInteger)treeMap.get(string);
            if (atomicInteger == null) {
                AtomicInteger atomicInteger2 = new AtomicInteger();
                treeMap.put(string, atomicInteger2);
            }
            var5_6.incrementAndGet();
        }
        Formatter formatter = new Formatter();
        String string = this instanceof MethodIdsSection ? "methods" : "fields";
        formatter.format("Too many %s: %d; max is %d. By package:", string, this.items().size(), 65536);
        for (Map.Entry entry : treeMap.entrySet()) {
            formatter.format("%n%6d %s", ((AtomicInteger)entry.getValue()).get(), entry.getKey());
        }
        return formatter.toString();
    }
}

