/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.io;

import com.android.dx.io.DexBuffer;
import com.android.dx.util.Unsigned;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MethodId
implements Comparable<MethodId> {
    private final DexBuffer buffer;
    private final int declaringClassIndex;
    private final int protoIndex;
    private final int nameIndex;

    public MethodId(DexBuffer dexBuffer, int n, int n2, int n3) {
        this.buffer = dexBuffer;
        this.declaringClassIndex = n;
        this.protoIndex = n2;
        this.nameIndex = n3;
    }

    public int getDeclaringClassIndex() {
        return this.declaringClassIndex;
    }

    public int getProtoIndex() {
        return this.protoIndex;
    }

    public int getNameIndex() {
        return this.nameIndex;
    }

    @Override
    public int compareTo(MethodId methodId) {
        if (this.declaringClassIndex != methodId.declaringClassIndex) {
            return Unsigned.compare(this.declaringClassIndex, methodId.declaringClassIndex);
        }
        if (this.nameIndex != methodId.nameIndex) {
            return Unsigned.compare(this.nameIndex, methodId.nameIndex);
        }
        return Unsigned.compare(this.protoIndex, methodId.protoIndex);
    }

    public void writeTo(DexBuffer.Section section) {
        section.writeUnsignedShort(this.declaringClassIndex);
        section.writeUnsignedShort(this.protoIndex);
        section.writeInt(this.nameIndex);
    }

    public String toString() {
        if (this.buffer == null) {
            return this.declaringClassIndex + " " + this.protoIndex + " " + this.nameIndex;
        }
        return this.buffer.typeNames().get(this.declaringClassIndex) + "." + this.buffer.strings().get(this.nameIndex) + this.buffer.readTypeList(this.buffer.protoIds().get(this.protoIndex).getParametersOffset());
    }
}

