/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.io.instructions;

import com.android.dx.io.IndexType;
import com.android.dx.io.OpcodeInfo;
import com.android.dx.io.Opcodes;
import com.android.dx.io.instructions.CodeInput;
import com.android.dx.io.instructions.CodeOutput;
import com.android.dx.io.instructions.InstructionCodec;
import com.android.dx.io.instructions.ShortArrayCodeInput;
import com.android.dx.util.DexException;
import com.android.dx.util.Hex;
import java.io.EOFException;

public abstract class DecodedInstruction {
    private final InstructionCodec format;
    private final int opcode;
    private final int index;
    private final IndexType indexType;
    private final int target;
    private final long literal;

    public static DecodedInstruction decode(CodeInput codeInput) throws EOFException {
        int n = codeInput.read();
        int n2 = Opcodes.extractOpcodeFromUnit(n);
        InstructionCodec instructionCodec = OpcodeInfo.getFormat(n2);
        return instructionCodec.decode(n, codeInput);
    }

    public static DecodedInstruction[] decodeAll(short[] sArray) {
        int n = sArray.length;
        DecodedInstruction[] decodedInstructionArray = new DecodedInstruction[n];
        ShortArrayCodeInput shortArrayCodeInput = new ShortArrayCodeInput(sArray);
        try {
            while (shortArrayCodeInput.hasMore()) {
                decodedInstructionArray[shortArrayCodeInput.cursor()] = DecodedInstruction.decode(shortArrayCodeInput);
            }
        }
        catch (EOFException eOFException) {
            throw new DexException(eOFException);
        }
        return decodedInstructionArray;
    }

    public DecodedInstruction(InstructionCodec instructionCodec, int n, int n2, IndexType indexType, int n3, long l) {
        if (instructionCodec == null) {
            throw new NullPointerException("format == null");
        }
        if (!Opcodes.isValidShape(n)) {
            throw new IllegalArgumentException("invalid opcode");
        }
        this.format = instructionCodec;
        this.opcode = n;
        this.index = n2;
        this.indexType = indexType;
        this.target = n3;
        this.literal = l;
    }

    public final InstructionCodec getFormat() {
        return this.format;
    }

    public final int getOpcode() {
        return this.opcode;
    }

    public final short getOpcodeUnit() {
        return (short)this.opcode;
    }

    public final int getIndex() {
        return this.index;
    }

    public final short getIndexUnit() {
        return (short)this.index;
    }

    public final IndexType getIndexType() {
        return this.indexType;
    }

    public final int getTarget() {
        return this.target;
    }

    public final int getTarget(int n) {
        return this.target - n;
    }

    public final short getTargetUnit(int n) {
        int n2 = this.getTarget(n);
        if (n2 != (short)n2) {
            throw new DexException("Target out of range: " + Hex.s4(n2));
        }
        return (short)n2;
    }

    public final int getTargetByte(int n) {
        int n2 = this.getTarget(n);
        if (n2 != (byte)n2) {
            throw new DexException("Target out of range: " + Hex.s4(n2));
        }
        return n2 & 0xFF;
    }

    public final long getLiteral() {
        return this.literal;
    }

    public final int getLiteralInt() {
        if (this.literal != (long)((int)this.literal)) {
            throw new DexException("Literal out of range: " + Hex.u8(this.literal));
        }
        return (int)this.literal;
    }

    public final short getLiteralUnit() {
        if (this.literal != (long)((short)this.literal)) {
            throw new DexException("Literal out of range: " + Hex.u8(this.literal));
        }
        return (short)this.literal;
    }

    public final int getLiteralByte() {
        if (this.literal != (long)((byte)this.literal)) {
            throw new DexException("Literal out of range: " + Hex.u8(this.literal));
        }
        return (int)this.literal & 0xFF;
    }

    public final int getLiteralNibble() {
        if (this.literal < -8L || this.literal > 7L) {
            throw new DexException("Literal out of range: " + Hex.u8(this.literal));
        }
        return (int)this.literal & 0xF;
    }

    public abstract int getRegisterCount();

    public int getA() {
        return 0;
    }

    public int getB() {
        return 0;
    }

    public int getC() {
        return 0;
    }

    public int getD() {
        return 0;
    }

    public int getE() {
        return 0;
    }

    public final short getRegisterCountUnit() {
        int n = this.getRegisterCount();
        if ((n & 0xFFFF0000) != 0) {
            throw new DexException("Register count out of range: " + Hex.u8(n));
        }
        return (short)n;
    }

    public final short getAUnit() {
        int n = this.getA();
        if ((n & 0xFFFF0000) != 0) {
            throw new DexException("Register A out of range: " + Hex.u8(n));
        }
        return (short)n;
    }

    public final short getAByte() {
        int n = this.getA();
        if ((n & 0xFFFFFF00) != 0) {
            throw new DexException("Register A out of range: " + Hex.u8(n));
        }
        return (short)n;
    }

    public final short getANibble() {
        int n = this.getA();
        if ((n & 0xFFFFFFF0) != 0) {
            throw new DexException("Register A out of range: " + Hex.u8(n));
        }
        return (short)n;
    }

    public final short getBUnit() {
        int n = this.getB();
        if ((n & 0xFFFF0000) != 0) {
            throw new DexException("Register B out of range: " + Hex.u8(n));
        }
        return (short)n;
    }

    public final short getBByte() {
        int n = this.getB();
        if ((n & 0xFFFFFF00) != 0) {
            throw new DexException("Register B out of range: " + Hex.u8(n));
        }
        return (short)n;
    }

    public final short getBNibble() {
        int n = this.getB();
        if ((n & 0xFFFFFFF0) != 0) {
            throw new DexException("Register B out of range: " + Hex.u8(n));
        }
        return (short)n;
    }

    public final short getCUnit() {
        int n = this.getC();
        if ((n & 0xFFFF0000) != 0) {
            throw new DexException("Register C out of range: " + Hex.u8(n));
        }
        return (short)n;
    }

    public final short getCByte() {
        int n = this.getC();
        if ((n & 0xFFFFFF00) != 0) {
            throw new DexException("Register C out of range: " + Hex.u8(n));
        }
        return (short)n;
    }

    public final short getCNibble() {
        int n = this.getC();
        if ((n & 0xFFFFFFF0) != 0) {
            throw new DexException("Register C out of range: " + Hex.u8(n));
        }
        return (short)n;
    }

    public final short getDUnit() {
        int n = this.getD();
        if ((n & 0xFFFF0000) != 0) {
            throw new DexException("Register D out of range: " + Hex.u8(n));
        }
        return (short)n;
    }

    public final short getDByte() {
        int n = this.getD();
        if ((n & 0xFFFFFF00) != 0) {
            throw new DexException("Register D out of range: " + Hex.u8(n));
        }
        return (short)n;
    }

    public final short getDNibble() {
        int n = this.getD();
        if ((n & 0xFFFFFFF0) != 0) {
            throw new DexException("Register D out of range: " + Hex.u8(n));
        }
        return (short)n;
    }

    public final short getENibble() {
        int n = this.getE();
        if ((n & 0xFFFFFFF0) != 0) {
            throw new DexException("Register E out of range: " + Hex.u8(n));
        }
        return (short)n;
    }

    public final void encode(CodeOutput codeOutput) {
        this.format.encode(this, codeOutput);
    }

    public abstract DecodedInstruction withIndex(int var1);
}

