/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.ssa.back;

import com.android.dx.ssa.SetFactory;
import com.android.dx.util.IntSet;
import java.util.ArrayList;

public class InterferenceGraph {
    private final ArrayList<IntSet> interference;

    public InterferenceGraph(int n) {
        this.interference = new ArrayList(n);
        for (int i = 0; i < n; ++i) {
            this.interference.add(SetFactory.makeInterferenceSet(n));
        }
    }

    public void add(int n, int n2) {
        this.ensureCapacity(Math.max(n, n2) + 1);
        this.interference.get(n).add(n2);
        this.interference.get(n2).add(n);
    }

    public void dumpToStdout() {
        int n = this.interference.size();
        for (int i = 0; i < n; ++i) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Reg " + i + ":" + this.interference.get(i).toString());
            System.out.println(stringBuilder.toString());
        }
    }

    public void mergeInterferenceSet(int n, IntSet intSet) {
        if (n < this.interference.size()) {
            intSet.merge(this.interference.get(n));
        }
    }

    private void ensureCapacity(int n) {
        int n2 = this.interference.size();
        this.interference.ensureCapacity(n);
        for (int i = n2; i < n; ++i) {
            this.interference.add(SetFactory.makeInterferenceSet(n));
        }
    }
}

