/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.util;

import java.io.FilterWriter;
import java.io.IOException;
import java.io.Writer;

public final class IndentingWriter
extends FilterWriter {
    private final String prefix;
    private final int width;
    private final int maxIndent;
    private int column;
    private boolean collectingIndent;
    private int indent;

    public IndentingWriter(Writer writer, int n, String string) {
        super(writer);
        if (writer == null) {
            throw new NullPointerException("out == null");
        }
        if (n < 0) {
            throw new IllegalArgumentException("width < 0");
        }
        if (string == null) {
            throw new NullPointerException("prefix == null");
        }
        this.width = n != 0 ? n : Integer.MAX_VALUE;
        this.maxIndent = n >> 1;
        this.prefix = string.length() == 0 ? null : string;
        this.bol();
    }

    public IndentingWriter(Writer writer, int n) {
        this(writer, n, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(int n) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.collectingIndent) {
                if (n == 32) {
                    ++this.indent;
                    if (this.indent >= this.maxIndent) {
                        this.indent = this.maxIndent;
                        this.collectingIndent = false;
                    }
                } else {
                    this.collectingIndent = false;
                }
            }
            if (this.column == this.width && n != 10) {
                this.out.write(10);
                this.column = 0;
            }
            if (this.column == 0) {
                if (this.prefix != null) {
                    this.out.write(this.prefix);
                }
                if (!this.collectingIndent) {
                    for (int i = 0; i < this.indent; ++i) {
                        this.out.write(32);
                    }
                    this.column = this.indent;
                }
            }
            this.out.write(n);
            if (n == 10) {
                this.bol();
            } else {
                ++this.column;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(char[] cArray, int n, int n2) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            while (n2 > 0) {
                this.write(cArray[n]);
                ++n;
                --n2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(String string, int n, int n2) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            while (n2 > 0) {
                this.write(string.charAt(n));
                ++n;
                --n2;
            }
        }
    }

    private void bol() {
        this.column = 0;
        this.collectingIndent = this.maxIndent != 0;
        this.indent = 0;
    }
}

