/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.cf.code;

import com.android.dx.cf.code.ByteCatchList;
import com.android.dx.util.Hex;
import com.android.dx.util.IntList;
import com.android.dx.util.LabeledItem;

public final class ByteBlock
implements LabeledItem {
    private final int label;
    private final int start;
    private final int end;
    private final IntList successors;
    private final ByteCatchList catches;

    public ByteBlock(int n, int n2, int n3, IntList intList, ByteCatchList byteCatchList) {
        if (n < 0) {
            throw new IllegalArgumentException("label < 0");
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("start < 0");
        }
        if (n3 <= n2) {
            throw new IllegalArgumentException("end <= start");
        }
        if (intList == null) {
            throw new NullPointerException("targets == null");
        }
        int n4 = intList.size();
        for (int i = 0; i < n4; ++i) {
            if (intList.get(i) >= 0) continue;
            throw new IllegalArgumentException("successors[" + i + "] == " + intList.get(i));
        }
        if (byteCatchList == null) {
            throw new NullPointerException("catches == null");
        }
        this.label = n;
        this.start = n2;
        this.end = n3;
        this.successors = intList;
        this.catches = byteCatchList;
    }

    public String toString() {
        return '{' + Hex.u2(this.label) + ": " + Hex.u2(this.start) + ".." + Hex.u2(this.end) + '}';
    }

    public int getLabel() {
        return this.label;
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    public IntList getSuccessors() {
        return this.successors;
    }

    public ByteCatchList getCatches() {
        return this.catches;
    }
}

