/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.cf.direct;

import com.android.dx.util.FileUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ClassPathOpener {
    private final String pathname;
    private final Consumer consumer;
    private final boolean sort;

    public ClassPathOpener(String string, boolean bl, Consumer consumer) {
        this.pathname = string;
        this.sort = bl;
        this.consumer = consumer;
    }

    public boolean process() {
        File file = new File(this.pathname);
        return this.processOne(file, true);
    }

    private boolean processOne(File file, boolean bl) {
        try {
            if (file.isDirectory()) {
                return this.processDirectory(file, bl);
            }
            String string = file.getPath();
            if (string.endsWith(".zip") || string.endsWith(".jar") || string.endsWith(".apk")) {
                return this.processArchive(file);
            }
            byte[] byArray = FileUtils.readFile(file);
            return this.consumer.processFileBytes(string, file.lastModified(), byArray);
        }
        catch (Exception exception) {
            this.consumer.onException(exception);
            return false;
        }
    }

    private static int compareClassNames(String string, String string2) {
        string = string.replace('$', '0');
        string2 = string2.replace('$', '0');
        string = string.replace("package-info", "");
        string2 = string2.replace("package-info", "");
        return string.compareTo(string2);
    }

    private boolean processDirectory(File file, boolean bl) {
        if (bl) {
            file = new File(file, ".");
        }
        File[] fileArray = file.listFiles();
        int n = fileArray.length;
        boolean bl2 = false;
        if (this.sort) {
            Arrays.sort(fileArray, new Comparator<File>(){

                @Override
                public int compare(File file, File file2) {
                    return ClassPathOpener.compareClassNames(file.getName(), file2.getName());
                }
            });
        }
        for (int i = 0; i < n; ++i) {
            bl2 |= this.processOne(fileArray[i], false);
        }
        return bl2;
    }

    private boolean processArchive(File file) throws IOException {
        ZipFile zipFile = new ZipFile(file);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(40000);
        byte[] byArray = new byte[20000];
        boolean bl = false;
        ArrayList<? extends ZipEntry> arrayList = Collections.list(zipFile.entries());
        if (this.sort) {
            Collections.sort(arrayList, new Comparator<ZipEntry>(){

                @Override
                public int compare(ZipEntry zipEntry, ZipEntry zipEntry2) {
                    return ClassPathOpener.compareClassNames(zipEntry.getName(), zipEntry2.getName());
                }
            });
        }
        this.consumer.onProcessArchiveStart(file);
        for (ZipEntry zipEntry : arrayList) {
            int n;
            if (zipEntry.isDirectory()) continue;
            String string = zipEntry.getName();
            InputStream inputStream = zipFile.getInputStream(zipEntry);
            byteArrayOutputStream.reset();
            while ((n = inputStream.read(byArray)) >= 0) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
            inputStream.close();
            byte[] byArray2 = byteArrayOutputStream.toByteArray();
            bl |= this.consumer.processFileBytes(string, zipEntry.getTime(), byArray2);
        }
        zipFile.close();
        return bl;
    }

    public static interface Consumer {
        public boolean processFileBytes(String var1, long var2, byte[] var4);

        public void onException(Exception var1);

        public void onProcessArchiveStart(File var1);
    }
}

