/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.dex.file;

import com.android.dx.dex.file.DexFile;
import com.android.dx.dex.file.EncodedField;
import com.android.dx.dex.file.EncodedMember;
import com.android.dx.dex.file.EncodedMethod;
import com.android.dx.dex.file.ItemType;
import com.android.dx.dex.file.OffsettedItem;
import com.android.dx.dex.file.Section;
import com.android.dx.rop.cst.Constant;
import com.android.dx.rop.cst.CstArray;
import com.android.dx.rop.cst.CstLiteralBits;
import com.android.dx.rop.cst.CstType;
import com.android.dx.rop.cst.Zeroes;
import com.android.dx.util.AnnotatedOutput;
import com.android.dx.util.ByteArrayAnnotatedOutput;
import com.android.dx.util.MutabilityControl;
import com.android.dx.util.Writers;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ClassDataItem
extends OffsettedItem {
    private final CstType thisClass;
    private final ArrayList<EncodedField> staticFields;
    private final HashMap<EncodedField, Constant> staticValues;
    private final ArrayList<EncodedField> instanceFields;
    private final ArrayList<EncodedMethod> directMethods;
    private final ArrayList<EncodedMethod> virtualMethods;
    private CstArray staticValuesConstant;
    private byte[] encodedForm;

    public ClassDataItem(CstType cstType) {
        super(1, -1);
        if (cstType == null) {
            throw new NullPointerException("thisClass == null");
        }
        this.thisClass = cstType;
        this.staticFields = new ArrayList(20);
        this.staticValues = new HashMap(40);
        this.instanceFields = new ArrayList(20);
        this.directMethods = new ArrayList(20);
        this.virtualMethods = new ArrayList(20);
        this.staticValuesConstant = null;
    }

    @Override
    public ItemType itemType() {
        return ItemType.TYPE_CLASS_DATA_ITEM;
    }

    @Override
    public String toHuman() {
        return this.toString();
    }

    public boolean isEmpty() {
        return this.staticFields.isEmpty() && this.instanceFields.isEmpty() && this.directMethods.isEmpty() && this.virtualMethods.isEmpty();
    }

    public void addStaticField(EncodedField encodedField, Constant constant) {
        if (encodedField == null) {
            throw new NullPointerException("field == null");
        }
        if (this.staticValuesConstant != null) {
            throw new UnsupportedOperationException("static fields already sorted");
        }
        this.staticFields.add(encodedField);
        this.staticValues.put(encodedField, constant);
    }

    public void addInstanceField(EncodedField encodedField) {
        if (encodedField == null) {
            throw new NullPointerException("field == null");
        }
        this.instanceFields.add(encodedField);
    }

    public void addDirectMethod(EncodedMethod encodedMethod) {
        if (encodedMethod == null) {
            throw new NullPointerException("method == null");
        }
        this.directMethods.add(encodedMethod);
    }

    public void addVirtualMethod(EncodedMethod encodedMethod) {
        if (encodedMethod == null) {
            throw new NullPointerException("method == null");
        }
        this.virtualMethods.add(encodedMethod);
    }

    public ArrayList<EncodedMethod> getMethods() {
        int n = this.directMethods.size() + this.virtualMethods.size();
        ArrayList<EncodedMethod> arrayList = new ArrayList<EncodedMethod>(n);
        arrayList.addAll(this.directMethods);
        arrayList.addAll(this.virtualMethods);
        return arrayList;
    }

    public void debugPrint(Writer writer, boolean bl) {
        int n;
        PrintWriter printWriter = Writers.printWriterFor(writer);
        int n2 = this.staticFields.size();
        for (n = 0; n < n2; ++n) {
            printWriter.println("  sfields[" + n + "]: " + this.staticFields.get(n));
        }
        n2 = this.instanceFields.size();
        for (n = 0; n < n2; ++n) {
            printWriter.println("  ifields[" + n + "]: " + this.instanceFields.get(n));
        }
        n2 = this.directMethods.size();
        for (n = 0; n < n2; ++n) {
            printWriter.println("  dmeths[" + n + "]:");
            this.directMethods.get(n).debugPrint(printWriter, bl);
        }
        n2 = this.virtualMethods.size();
        for (n = 0; n < n2; ++n) {
            printWriter.println("  vmeths[" + n + "]:");
            this.virtualMethods.get(n).debugPrint(printWriter, bl);
        }
    }

    @Override
    public void addContents(DexFile dexFile) {
        if (!this.staticFields.isEmpty()) {
            this.getStaticValuesConstant();
            for (EncodedField encodedMember : this.staticFields) {
                encodedMember.addContents(dexFile);
            }
        }
        if (!this.instanceFields.isEmpty()) {
            Collections.sort(this.instanceFields);
            for (EncodedField encodedField : this.instanceFields) {
                encodedField.addContents(dexFile);
            }
        }
        if (!this.directMethods.isEmpty()) {
            Collections.sort(this.directMethods);
            for (EncodedMethod encodedMethod : this.directMethods) {
                encodedMethod.addContents(dexFile);
            }
        }
        if (!this.virtualMethods.isEmpty()) {
            Collections.sort(this.virtualMethods);
            for (EncodedMethod encodedMethod : this.virtualMethods) {
                encodedMethod.addContents(dexFile);
            }
        }
    }

    public CstArray getStaticValuesConstant() {
        if (this.staticValuesConstant == null && this.staticFields.size() != 0) {
            this.staticValuesConstant = this.makeStaticValuesConstant();
        }
        return this.staticValuesConstant;
    }

    private CstArray makeStaticValuesConstant() {
        Comparable<CstArray.List> comparable;
        Constant constant;
        int n;
        Collections.sort(this.staticFields);
        for (n = this.staticFields.size(); n > 0 && !((constant = this.staticValues.get(comparable = this.staticFields.get(n - 1))) instanceof CstLiteralBits ? ((CstLiteralBits)constant).getLongBits() != 0L : constant != null); --n) {
        }
        if (n == 0) {
            return null;
        }
        comparable = new CstArray.List(n);
        for (int i = 0; i < n; ++i) {
            EncodedField encodedField = this.staticFields.get(i);
            Constant constant2 = this.staticValues.get(encodedField);
            if (constant2 == null) {
                constant2 = Zeroes.zeroFor(encodedField.getRef().getType());
            }
            ((CstArray.List)comparable).set(i, constant2);
        }
        ((MutabilityControl)((Object)comparable)).setImmutable();
        return new CstArray((CstArray.List)comparable);
    }

    @Override
    protected void place0(Section section, int n) {
        ByteArrayAnnotatedOutput byteArrayAnnotatedOutput = new ByteArrayAnnotatedOutput();
        this.encodeOutput(section.getFile(), byteArrayAnnotatedOutput);
        this.encodedForm = byteArrayAnnotatedOutput.toByteArray();
        this.setWriteSize(this.encodedForm.length);
    }

    private void encodeOutput(DexFile dexFile, AnnotatedOutput annotatedOutput) {
        boolean bl = annotatedOutput.annotates();
        if (bl) {
            annotatedOutput.annotate(0, this.offsetString() + " class data for " + this.thisClass.toHuman());
        }
        ClassDataItem.encodeSize(dexFile, annotatedOutput, "static_fields", this.staticFields.size());
        ClassDataItem.encodeSize(dexFile, annotatedOutput, "instance_fields", this.instanceFields.size());
        ClassDataItem.encodeSize(dexFile, annotatedOutput, "direct_methods", this.directMethods.size());
        ClassDataItem.encodeSize(dexFile, annotatedOutput, "virtual_methods", this.virtualMethods.size());
        ClassDataItem.encodeList(dexFile, annotatedOutput, "static_fields", this.staticFields);
        ClassDataItem.encodeList(dexFile, annotatedOutput, "instance_fields", this.instanceFields);
        ClassDataItem.encodeList(dexFile, annotatedOutput, "direct_methods", this.directMethods);
        ClassDataItem.encodeList(dexFile, annotatedOutput, "virtual_methods", this.virtualMethods);
        if (bl) {
            annotatedOutput.endAnnotation();
        }
    }

    private static void encodeSize(DexFile dexFile, AnnotatedOutput annotatedOutput, String string, int n) {
        if (annotatedOutput.annotates()) {
            annotatedOutput.annotate(String.format("  %-21s %08x", string + "_size:", n));
        }
        annotatedOutput.writeUleb128(n);
    }

    private static void encodeList(DexFile dexFile, AnnotatedOutput annotatedOutput, String string, ArrayList<? extends EncodedMember> arrayList) {
        int n = arrayList.size();
        int n2 = 0;
        if (n == 0) {
            return;
        }
        if (annotatedOutput.annotates()) {
            annotatedOutput.annotate(0, "  " + string + ":");
        }
        for (int i = 0; i < n; ++i) {
            n2 = arrayList.get(i).encode(dexFile, annotatedOutput, n2, i);
        }
    }

    @Override
    public void writeTo0(DexFile dexFile, AnnotatedOutput annotatedOutput) {
        boolean bl = annotatedOutput.annotates();
        if (bl) {
            this.encodeOutput(dexFile, annotatedOutput);
        } else {
            annotatedOutput.write(this.encodedForm);
        }
    }
}

