/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.dex.file;

import com.android.dx.dex.file.ClassDefItem;
import com.android.dx.dex.file.DexFile;
import com.android.dx.dex.file.IndexedItem;
import com.android.dx.dex.file.Item;
import com.android.dx.dex.file.UniformItemSection;
import com.android.dx.rop.cst.Constant;
import com.android.dx.rop.cst.CstType;
import com.android.dx.rop.type.Type;
import com.android.dx.util.AnnotatedOutput;
import com.android.dx.util.Hex;
import java.util.ArrayList;
import java.util.Collection;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ClassDefsSection
extends UniformItemSection {
    private final TreeMap<Type, ClassDefItem> classDefs = new TreeMap();
    private ArrayList<ClassDefItem> orderedDefs = null;

    public ClassDefsSection(DexFile dexFile) {
        super("class_defs", dexFile, 4);
    }

    @Override
    public Collection<? extends Item> items() {
        if (this.orderedDefs != null) {
            return this.orderedDefs;
        }
        return this.classDefs.values();
    }

    @Override
    public IndexedItem get(Constant constant) {
        if (constant == null) {
            throw new NullPointerException("cst == null");
        }
        this.throwIfNotPrepared();
        Type type = ((CstType)constant).getClassType();
        IndexedItem indexedItem = this.classDefs.get(type);
        if (indexedItem == null) {
            throw new IllegalArgumentException("not found");
        }
        return indexedItem;
    }

    public void writeHeaderPart(AnnotatedOutput annotatedOutput) {
        int n;
        this.throwIfNotPrepared();
        int n2 = this.classDefs.size();
        int n3 = n = n2 == 0 ? 0 : this.getFileOffset();
        if (annotatedOutput.annotates()) {
            annotatedOutput.annotate(4, "class_defs_size: " + Hex.u4(n2));
            annotatedOutput.annotate(4, "class_defs_off:  " + Hex.u4(n));
        }
        annotatedOutput.writeInt(n2);
        annotatedOutput.writeInt(n);
    }

    public void add(ClassDefItem classDefItem) {
        Type type;
        try {
            type = classDefItem.getThisClass().getClassType();
        }
        catch (NullPointerException nullPointerException) {
            throw new NullPointerException("clazz == null");
        }
        this.throwIfPrepared();
        if (this.classDefs.get(type) != null) {
            throw new IllegalArgumentException("already added: " + type);
        }
        this.classDefs.put(type, classDefItem);
    }

    @Override
    protected void orderItems() {
        int n = this.classDefs.size();
        int n2 = 0;
        this.orderedDefs = new ArrayList(n);
        for (Type type : this.classDefs.keySet()) {
            n2 = this.orderItems0(type, n2, n - n2);
        }
    }

    private int orderItems0(Type type, int n, int n2) {
        Object object;
        ClassDefItem classDefItem = this.classDefs.get(type);
        if (classDefItem == null || classDefItem.hasIndex()) {
            return n;
        }
        if (n2 < 0) {
            throw new RuntimeException("class circularity with " + type);
        }
        --n2;
        CstType cstType = classDefItem.getSuperclass();
        if (cstType != null) {
            object = cstType.getClassType();
            n = this.orderItems0((Type)object, n, n2);
        }
        object = classDefItem.getInterfaces();
        int n3 = object.size();
        for (int i = 0; i < n3; ++i) {
            n = this.orderItems0(object.getType(i), n, n2);
        }
        classDefItem.setIndex(n);
        this.orderedDefs.add(classDefItem);
        return n + 1;
    }
}

