/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.dex.file;

import com.android.dx.dex.file.Item;
import com.android.dx.dex.file.Section;
import com.android.dx.util.AnnotatedOutput;
import java.util.Collection;
import java.util.HashMap;
import java.util.TreeMap;

public final class Statistics {
    private final HashMap<String, Data> dataMap = new HashMap(50);

    public void add(Item item) {
        String string = item.typeName();
        Data data = this.dataMap.get(string);
        if (data == null) {
            this.dataMap.put(string, new Data(item, string));
        } else {
            data.add(item);
        }
    }

    public void addAll(Section section) {
        Collection<? extends Item> collection = section.items();
        for (Item item : collection) {
            this.add(item);
        }
    }

    public final void writeAnnotation(AnnotatedOutput annotatedOutput) {
        if (this.dataMap.size() == 0) {
            return;
        }
        annotatedOutput.annotate(0, "\nstatistics:\n");
        TreeMap<String, Data> treeMap = new TreeMap<String, Data>();
        for (Data data : this.dataMap.values()) {
            treeMap.put(data.name, data);
        }
        for (Data data : treeMap.values()) {
            data.writeAnnotation(annotatedOutput);
        }
    }

    public String toHuman() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Statistics:\n");
        TreeMap<String, Data> treeMap = new TreeMap<String, Data>();
        for (Data data : this.dataMap.values()) {
            treeMap.put(data.name, data);
        }
        for (Data data : treeMap.values()) {
            stringBuilder.append(data.toHuman());
        }
        return stringBuilder.toString();
    }

    private static class Data {
        private final String name;
        private int count;
        private int totalSize;
        private int largestSize;
        private int smallestSize;

        public Data(Item item, String string) {
            int n = item.writeSize();
            this.name = string;
            this.count = 1;
            this.totalSize = n;
            this.largestSize = n;
            this.smallestSize = n;
        }

        public void add(Item item) {
            int n = item.writeSize();
            ++this.count;
            this.totalSize += n;
            if (n > this.largestSize) {
                this.largestSize = n;
            }
            if (n < this.smallestSize) {
                this.smallestSize = n;
            }
        }

        public void writeAnnotation(AnnotatedOutput annotatedOutput) {
            annotatedOutput.annotate(this.toHuman());
        }

        public String toHuman() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("  " + this.name + ": " + this.count + " item" + (this.count == 1 ? "" : "s") + "; " + this.totalSize + " bytes total\n");
            if (this.smallestSize == this.largestSize) {
                stringBuilder.append("    " + this.smallestSize + " bytes/item\n");
            } else {
                int n = this.totalSize / this.count;
                stringBuilder.append("    " + this.smallestSize + ".." + this.largestSize + " bytes/item; average " + n + "\n");
            }
            return stringBuilder.toString();
        }
    }
}

