/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.dex.file;

import com.android.dx.dex.file.DexFile;
import com.android.dx.dex.file.IndexedItem;
import com.android.dx.dex.file.Item;
import com.android.dx.dex.file.StringIdItem;
import com.android.dx.dex.file.UniformItemSection;
import com.android.dx.rop.cst.Constant;
import com.android.dx.rop.cst.CstNat;
import com.android.dx.rop.cst.CstString;
import com.android.dx.util.AnnotatedOutput;
import com.android.dx.util.Hex;
import java.util.Collection;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StringIdsSection
extends UniformItemSection {
    private final TreeMap<CstString, StringIdItem> strings = new TreeMap();

    public StringIdsSection(DexFile dexFile) {
        super("string_ids", dexFile, 4);
    }

    @Override
    public Collection<? extends Item> items() {
        return this.strings.values();
    }

    @Override
    public IndexedItem get(Constant constant) {
        if (constant == null) {
            throw new NullPointerException("cst == null");
        }
        this.throwIfNotPrepared();
        IndexedItem indexedItem = this.strings.get((CstString)constant);
        if (indexedItem == null) {
            throw new IllegalArgumentException("not found");
        }
        return indexedItem;
    }

    public void writeHeaderPart(AnnotatedOutput annotatedOutput) {
        int n;
        this.throwIfNotPrepared();
        int n2 = this.strings.size();
        int n3 = n = n2 == 0 ? 0 : this.getFileOffset();
        if (annotatedOutput.annotates()) {
            annotatedOutput.annotate(4, "string_ids_size: " + Hex.u4(n2));
            annotatedOutput.annotate(4, "string_ids_off:  " + Hex.u4(n));
        }
        annotatedOutput.writeInt(n2);
        annotatedOutput.writeInt(n);
    }

    public StringIdItem intern(String string) {
        return this.intern(new StringIdItem(new CstString(string)));
    }

    public StringIdItem intern(CstString cstString) {
        return this.intern(new StringIdItem(cstString));
    }

    public StringIdItem intern(StringIdItem stringIdItem) {
        if (stringIdItem == null) {
            throw new NullPointerException("string == null");
        }
        this.throwIfPrepared();
        CstString cstString = stringIdItem.getValue();
        StringIdItem stringIdItem2 = this.strings.get(cstString);
        if (stringIdItem2 != null) {
            return stringIdItem2;
        }
        this.strings.put(cstString, stringIdItem);
        return stringIdItem;
    }

    public void intern(CstNat cstNat) {
        this.intern(cstNat.getName());
        this.intern(cstNat.getDescriptor());
    }

    public int indexOf(CstString cstString) {
        if (cstString == null) {
            throw new NullPointerException("string == null");
        }
        this.throwIfNotPrepared();
        StringIdItem stringIdItem = this.strings.get(cstString);
        if (stringIdItem == null) {
            throw new IllegalArgumentException("not found");
        }
        return stringIdItem.getIndex();
    }

    @Override
    protected void orderItems() {
        int n = 0;
        for (StringIdItem stringIdItem : this.strings.values()) {
            stringIdItem.setIndex(n);
            ++n;
        }
    }
}

