/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.io;

import com.android.dx.io.DexBuffer;
import com.android.dx.util.ByteArrayByteInput;
import com.android.dx.util.ByteInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EncodedValue
implements Comparable<EncodedValue> {
    private final byte[] data;

    public EncodedValue(byte[] byArray) {
        this.data = byArray;
    }

    public ByteInput asByteInput() {
        return new ByteArrayByteInput(this.data);
    }

    public byte[] getBytes() {
        return this.data;
    }

    public void writeTo(DexBuffer.Section section) {
        section.write(this.data);
    }

    @Override
    public int compareTo(EncodedValue encodedValue) {
        int n = Math.min(this.data.length, encodedValue.data.length);
        for (int i = 0; i < n; ++i) {
            if (this.data[i] == encodedValue.data[i]) continue;
            return (this.data[i] & 0xFF) - (encodedValue.data[i] & 0xFF);
        }
        return this.data.length - encodedValue.data.length;
    }

    public String toString() {
        return Integer.toHexString(this.data[0] & 0xFF) + "...(" + this.data.length + ")";
    }
}

