/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.merge;

import com.android.dx.dex.TableOfContents;
import com.android.dx.io.Annotation;
import com.android.dx.io.ClassDef;
import com.android.dx.io.DexBuffer;
import com.android.dx.io.EncodedValue;
import com.android.dx.io.EncodedValueReader;
import com.android.dx.io.FieldId;
import com.android.dx.io.MethodId;
import com.android.dx.io.ProtoId;
import com.android.dx.merge.SortableType;
import com.android.dx.merge.TypeList;
import com.android.dx.util.ByteArrayAnnotatedOutput;
import com.android.dx.util.ByteInput;
import com.android.dx.util.ByteOutput;
import com.android.dx.util.Leb128Utils;
import com.android.dx.util.Unsigned;
import java.util.HashMap;

public final class IndexMap {
    private final DexBuffer target;
    public final int[] stringIds;
    public final short[] typeIds;
    public final short[] protoIds;
    public final short[] fieldIds;
    public final short[] methodIds;
    private final HashMap<Integer, Integer> typeListOffsets;
    private final HashMap<Integer, Integer> annotationOffsets;
    private final HashMap<Integer, Integer> annotationSetOffsets;
    private final HashMap<Integer, Integer> annotationDirectoryOffsets;
    private final HashMap<Integer, Integer> staticValuesOffsets;

    public IndexMap(DexBuffer dexBuffer, TableOfContents tableOfContents) {
        this.target = dexBuffer;
        this.stringIds = new int[tableOfContents.stringIds.size];
        this.typeIds = new short[tableOfContents.typeIds.size];
        this.protoIds = new short[tableOfContents.protoIds.size];
        this.fieldIds = new short[tableOfContents.fieldIds.size];
        this.methodIds = new short[tableOfContents.methodIds.size];
        this.typeListOffsets = new HashMap();
        this.annotationOffsets = new HashMap();
        this.annotationSetOffsets = new HashMap();
        this.annotationDirectoryOffsets = new HashMap();
        this.staticValuesOffsets = new HashMap();
        this.typeListOffsets.put(0, 0);
        this.annotationSetOffsets.put(0, 0);
        this.annotationDirectoryOffsets.put(0, 0);
        this.staticValuesOffsets.put(0, 0);
    }

    public void putTypeListOffset(int n, int n2) {
        if (n <= 0 || n2 <= 0) {
            throw new IllegalArgumentException();
        }
        this.typeListOffsets.put(n, n2);
    }

    public void putAnnotationOffset(int n, int n2) {
        if (n <= 0 || n2 <= 0) {
            throw new IllegalArgumentException();
        }
        this.annotationOffsets.put(n, n2);
    }

    public void putAnnotationSetOffset(int n, int n2) {
        if (n <= 0 || n2 <= 0) {
            throw new IllegalArgumentException();
        }
        this.annotationSetOffsets.put(n, n2);
    }

    public void putAnnotationDirectoryOffset(int n, int n2) {
        if (n <= 0 || n2 <= 0) {
            throw new IllegalArgumentException();
        }
        this.annotationDirectoryOffsets.put(n, n2);
    }

    public void putStaticValuesOffset(int n, int n2) {
        if (n <= 0 || n2 <= 0) {
            throw new IllegalArgumentException();
        }
        this.staticValuesOffsets.put(n, n2);
    }

    public int adjustString(int n) {
        return n == -1 ? -1 : this.stringIds[n];
    }

    public int adjustType(int n) {
        return n == -1 ? -1 : this.typeIds[n] & 0xFFFF;
    }

    public TypeList adjustTypeList(TypeList typeList) {
        if (typeList == TypeList.EMPTY) {
            return typeList;
        }
        short[] sArray = (short[])typeList.getTypes().clone();
        for (int i = 0; i < sArray.length; ++i) {
            sArray[i] = (short)this.adjustType(sArray[i]);
        }
        return new TypeList(this.target, sArray);
    }

    public int adjustProto(int n) {
        return this.protoIds[n] & 0xFFFF;
    }

    public int adjustField(int n) {
        return this.fieldIds[n] & 0xFFFF;
    }

    public int adjustMethod(int n) {
        return this.methodIds[n] & 0xFFFF;
    }

    public int adjustTypeListOffset(int n) {
        return this.typeListOffsets.get(n);
    }

    public int adjustAnnotation(int n) {
        return this.annotationOffsets.get(n);
    }

    public int adjustAnnotationSet(int n) {
        return this.annotationSetOffsets.get(n);
    }

    public int adjustAnnotationDirectory(int n) {
        return this.annotationDirectoryOffsets.get(n);
    }

    public int adjustStaticValues(int n) {
        return this.staticValuesOffsets.get(n);
    }

    public MethodId adjust(MethodId methodId) {
        return new MethodId(this.target, this.adjustType(methodId.getDeclaringClassIndex()), this.adjustProto(methodId.getProtoIndex()), this.adjustString(methodId.getNameIndex()));
    }

    public FieldId adjust(FieldId fieldId) {
        return new FieldId(this.target, this.adjustType(fieldId.getDeclaringClassIndex()), this.adjustType(fieldId.getTypeIndex()), this.adjustString(fieldId.getNameIndex()));
    }

    public ProtoId adjust(ProtoId protoId) {
        return new ProtoId(this.target, this.adjustString(protoId.getShortyIndex()), this.adjustType(protoId.getReturnTypeIndex()), this.adjustTypeListOffset(protoId.getParametersOffset()));
    }

    public ClassDef adjust(ClassDef classDef) {
        return new ClassDef(this.target, classDef.getOffset(), this.adjustType(classDef.getTypeIndex()), classDef.getAccessFlags(), this.adjustType(classDef.getSupertypeIndex()), this.adjustTypeListOffset(classDef.getInterfacesOffset()), classDef.getSourceFileIndex(), classDef.getAnnotationsOffset(), classDef.getClassDataOffset(), classDef.getStaticValuesOffset());
    }

    public SortableType adjust(SortableType sortableType) {
        return new SortableType(sortableType.getBuffer(), this.adjust(sortableType.getClassDef()));
    }

    public EncodedValue adjustEncodedValue(EncodedValue encodedValue) {
        ByteArrayAnnotatedOutput byteArrayAnnotatedOutput = new ByteArrayAnnotatedOutput(32);
        new EncodedValueTransformer(encodedValue, byteArrayAnnotatedOutput).readValue();
        return new EncodedValue(byteArrayAnnotatedOutput.toByteArray());
    }

    public EncodedValue adjustEncodedArray(EncodedValue encodedValue) {
        ByteArrayAnnotatedOutput byteArrayAnnotatedOutput = new ByteArrayAnnotatedOutput(32);
        new EncodedValueTransformer(encodedValue, byteArrayAnnotatedOutput).readArray();
        return new EncodedValue(byteArrayAnnotatedOutput.toByteArray());
    }

    public Annotation adjust(Annotation annotation) {
        int[] nArray = (int[])annotation.getNames().clone();
        EncodedValue[] encodedValueArray = (EncodedValue[])annotation.getValues().clone();
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = this.adjustString(nArray[i]);
            encodedValueArray[i] = this.adjustEncodedValue(encodedValueArray[i]);
        }
        return new Annotation(this.target, annotation.getVisibility(), this.adjustType(annotation.getTypeIndex()), nArray, encodedValueArray);
    }

    private final class EncodedValueTransformer
    extends EncodedValueReader {
        private final ByteOutput out;

        public EncodedValueTransformer(EncodedValue encodedValue, ByteOutput byteOutput) {
            super(encodedValue);
            this.out = byteOutput;
        }

        protected void visitArray(int n) {
            Leb128Utils.writeUnsignedLeb128(this.out, n);
        }

        protected void visitAnnotation(int n, int n2) {
            Leb128Utils.writeUnsignedLeb128(this.out, IndexMap.this.adjustType(n));
            Leb128Utils.writeUnsignedLeb128(this.out, n2);
        }

        protected void visitAnnotationName(int n) {
            Leb128Utils.writeUnsignedLeb128(this.out, IndexMap.this.adjustString(n));
        }

        protected void visitPrimitive(int n, int n2, int n3, int n4) {
            this.out.writeByte(n);
            this.copyBytes(this.in, this.out, n4);
        }

        protected void visitString(int n, int n2) {
            this.writeTypeAndSizeAndIndex(n, IndexMap.this.adjustString(n2));
        }

        protected void visitType(int n, int n2) {
            this.writeTypeAndSizeAndIndex(n, IndexMap.this.adjustType(n2));
        }

        protected void visitField(int n, int n2) {
            this.writeTypeAndSizeAndIndex(n, IndexMap.this.adjustField(n2));
        }

        protected void visitMethod(int n, int n2) {
            this.writeTypeAndSizeAndIndex(n, IndexMap.this.adjustMethod(n2));
        }

        protected void visitArrayValue(int n) {
            this.out.writeByte(n);
        }

        protected void visitAnnotationValue(int n) {
            this.out.writeByte(n);
        }

        protected void visitEncodedBoolean(int n) {
            this.out.writeByte(n);
        }

        protected void visitEncodedNull(int n) {
            this.out.writeByte(n);
        }

        private void writeTypeAndSizeAndIndex(int n, int n2) {
            int n3 = Unsigned.compare(n2, 255) <= 0 ? 1 : (Unsigned.compare(n2, 65535) <= 0 ? 2 : (Unsigned.compare(n2, 0xFFFFFF) <= 0 ? 3 : 4));
            int n4 = n3 - 1 << 5 | n;
            this.out.writeByte(n4);
            for (int i = 0; i < n3; ++i) {
                this.out.writeByte(n2 & 0xFF);
                n2 >>>= 8;
            }
        }

        private void copyBytes(ByteInput byteInput, ByteOutput byteOutput, int n) {
            for (int i = 0; i < n; ++i) {
                byteOutput.writeByte(byteInput.readByte());
            }
        }
    }
}

