/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.rop.code;

import com.android.dx.rop.code.BasicBlock;
import com.android.dx.rop.code.FillArrayDataInsn;
import com.android.dx.rop.code.Insn;
import com.android.dx.rop.code.InsnList;
import com.android.dx.rop.code.PlainCstInsn;
import com.android.dx.rop.code.PlainInsn;
import com.android.dx.rop.code.RegisterSpec;
import com.android.dx.rop.code.RegisterSpecList;
import com.android.dx.rop.code.SwitchInsn;
import com.android.dx.rop.code.ThrowingCstInsn;
import com.android.dx.rop.code.ThrowingInsn;
import com.android.dx.rop.type.StdTypeList;
import com.android.dx.rop.type.TypeList;
import com.android.dx.util.Hex;
import com.android.dx.util.IntList;
import com.android.dx.util.LabeledList;

public final class BasicBlockList
extends LabeledList {
    private int regCount;

    public BasicBlockList(int n) {
        super(n);
        this.regCount = -1;
    }

    private BasicBlockList(BasicBlockList basicBlockList) {
        super(basicBlockList);
        this.regCount = basicBlockList.regCount;
    }

    public BasicBlock get(int n) {
        return (BasicBlock)this.get0(n);
    }

    public void set(int n, BasicBlock basicBlock) {
        super.set(n, basicBlock);
        this.regCount = -1;
    }

    public int getRegCount() {
        if (this.regCount == -1) {
            RegCountVisitor regCountVisitor = new RegCountVisitor();
            this.forEachInsn(regCountVisitor);
            this.regCount = regCountVisitor.getRegCount();
        }
        return this.regCount;
    }

    public int getInstructionCount() {
        int n = this.size();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            BasicBlock basicBlock = (BasicBlock)this.getOrNull0(i);
            if (basicBlock == null) continue;
            n2 += basicBlock.getInsns().size();
        }
        return n2;
    }

    public int getEffectiveInstructionCount() {
        int n = this.size();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            BasicBlock basicBlock = (BasicBlock)this.getOrNull0(i);
            if (basicBlock == null) continue;
            InsnList insnList = basicBlock.getInsns();
            int n3 = insnList.size();
            for (int j = 0; j < n3; ++j) {
                Insn insn = insnList.get(j);
                if (insn.getOpcode().getOpcode() == 54) continue;
                ++n2;
            }
        }
        return n2;
    }

    public BasicBlock labelToBlock(int n) {
        int n2 = this.indexOfLabel(n);
        if (n2 < 0) {
            throw new IllegalArgumentException("no such label: " + Hex.u2(n));
        }
        return this.get(n2);
    }

    public void forEachInsn(Insn.Visitor visitor) {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            BasicBlock basicBlock = this.get(i);
            InsnList insnList = basicBlock.getInsns();
            insnList.forEach(visitor);
        }
    }

    public BasicBlockList withRegisterOffset(int n) {
        int n2 = this.size();
        BasicBlockList basicBlockList = new BasicBlockList(n2);
        for (int i = 0; i < n2; ++i) {
            BasicBlock basicBlock = (BasicBlock)this.get0(i);
            if (basicBlock == null) continue;
            basicBlockList.set(i, basicBlock.withRegisterOffset(n));
        }
        if (this.isImmutable()) {
            basicBlockList.setImmutable();
        }
        return basicBlockList;
    }

    public BasicBlockList getMutableCopy() {
        return new BasicBlockList(this);
    }

    public BasicBlock preferredSuccessorOf(BasicBlock basicBlock) {
        int n = basicBlock.getPrimarySuccessor();
        IntList intList = basicBlock.getSuccessors();
        int n2 = intList.size();
        switch (n2) {
            case 0: {
                return null;
            }
            case 1: {
                return this.labelToBlock(intList.get(0));
            }
        }
        if (n != -1) {
            return this.labelToBlock(n);
        }
        return this.labelToBlock(intList.get(0));
    }

    public boolean catchesEqual(BasicBlock basicBlock, BasicBlock basicBlock2) {
        TypeList typeList;
        TypeList typeList2 = basicBlock.getExceptionHandlerTypes();
        if (!StdTypeList.equalContents(typeList2, typeList = basicBlock2.getExceptionHandlerTypes())) {
            return false;
        }
        IntList intList = basicBlock.getSuccessors();
        IntList intList2 = basicBlock2.getSuccessors();
        int n = intList.size();
        int n2 = basicBlock.getPrimarySuccessor();
        int n3 = basicBlock2.getPrimarySuccessor();
        if ((n2 == -1 || n3 == -1) && n2 != n3) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            int n4 = intList.get(i);
            int n5 = intList2.get(i);
            if (!(n4 == n2 ? n5 != n3 : n4 != n5)) continue;
            return false;
        }
        return true;
    }

    private static class RegCountVisitor
    implements Insn.Visitor {
        private int regCount = 0;

        public int getRegCount() {
            return this.regCount;
        }

        public void visitPlainInsn(PlainInsn plainInsn) {
            this.visit(plainInsn);
        }

        public void visitPlainCstInsn(PlainCstInsn plainCstInsn) {
            this.visit(plainCstInsn);
        }

        public void visitSwitchInsn(SwitchInsn switchInsn) {
            this.visit(switchInsn);
        }

        public void visitThrowingCstInsn(ThrowingCstInsn throwingCstInsn) {
            this.visit(throwingCstInsn);
        }

        public void visitThrowingInsn(ThrowingInsn throwingInsn) {
            this.visit(throwingInsn);
        }

        public void visitFillArrayDataInsn(FillArrayDataInsn fillArrayDataInsn) {
            this.visit(fillArrayDataInsn);
        }

        private void visit(Insn insn) {
            RegisterSpec registerSpec = insn.getResult();
            if (registerSpec != null) {
                this.processReg(registerSpec);
            }
            RegisterSpecList registerSpecList = insn.getSources();
            int n = registerSpecList.size();
            for (int i = 0; i < n; ++i) {
                this.processReg(registerSpecList.get(i));
            }
        }

        private void processReg(RegisterSpec registerSpec) {
            int n = registerSpec.getNextReg();
            if (n > this.regCount) {
                this.regCount = n;
            }
        }
    }
}

