/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.dex.code;

import com.android.dx.dex.code.CodeAddress;
import com.android.dx.dex.code.DalvInsn;
import com.android.dx.dex.code.Dops;
import com.android.dx.dex.code.VariableSizeInsn;
import com.android.dx.rop.code.RegisterSpecList;
import com.android.dx.rop.code.SourcePosition;
import com.android.dx.util.AnnotatedOutput;
import com.android.dx.util.Hex;
import com.android.dx.util.IntList;

public final class SwitchData
extends VariableSizeInsn {
    private final CodeAddress user;
    private final IntList cases;
    private final CodeAddress[] targets;
    private final boolean packed;

    public SwitchData(SourcePosition sourcePosition, CodeAddress codeAddress, IntList intList, CodeAddress[] codeAddressArray) {
        super(sourcePosition, RegisterSpecList.EMPTY);
        if (codeAddress == null) {
            throw new NullPointerException("user == null");
        }
        if (intList == null) {
            throw new NullPointerException("cases == null");
        }
        if (codeAddressArray == null) {
            throw new NullPointerException("targets == null");
        }
        int n = intList.size();
        if (n != codeAddressArray.length) {
            throw new IllegalArgumentException("cases / targets mismatch");
        }
        if (n > 65535) {
            throw new IllegalArgumentException("too many cases");
        }
        this.user = codeAddress;
        this.cases = intList;
        this.targets = codeAddressArray;
        this.packed = SwitchData.shouldPack(intList);
    }

    public int codeSize() {
        return this.packed ? (int)SwitchData.packedCodeSize(this.cases) : (int)SwitchData.sparseCodeSize(this.cases);
    }

    public void writeTo(AnnotatedOutput annotatedOutput) {
        int n = this.user.getAddress();
        int n2 = Dops.PACKED_SWITCH.getFormat().codeSize();
        int n3 = this.targets.length;
        if (this.packed) {
            int n4 = n3 == 0 ? 0 : this.cases.get(0);
            int n5 = n3 == 0 ? 0 : this.cases.get(n3 - 1);
            int n6 = n5 - n4 + 1;
            annotatedOutput.writeShort(256);
            annotatedOutput.writeShort(n6);
            annotatedOutput.writeInt(n4);
            int n7 = 0;
            for (int i = 0; i < n6; ++i) {
                int n8;
                int n9 = n4 + i;
                int n10 = this.cases.get(n7);
                if (n10 > n9) {
                    n8 = n2;
                } else {
                    n8 = this.targets[n7].getAddress() - n;
                    ++n7;
                }
                annotatedOutput.writeInt(n8);
            }
        } else {
            int n11;
            annotatedOutput.writeShort(512);
            annotatedOutput.writeShort(n3);
            for (n11 = 0; n11 < n3; ++n11) {
                annotatedOutput.writeInt(this.cases.get(n11));
            }
            for (n11 = 0; n11 < n3; ++n11) {
                int n12 = this.targets[n11].getAddress() - n;
                annotatedOutput.writeInt(n12);
            }
        }
    }

    public DalvInsn withRegisters(RegisterSpecList registerSpecList) {
        return new SwitchData(this.getPosition(), this.user, this.cases, this.targets);
    }

    public boolean isPacked() {
        return this.packed;
    }

    protected String argString() {
        StringBuffer stringBuffer = new StringBuffer(100);
        int n = this.targets.length;
        for (int i = 0; i < n; ++i) {
            stringBuffer.append("\n    ");
            stringBuffer.append(this.cases.get(i));
            stringBuffer.append(": ");
            stringBuffer.append(this.targets[i]);
        }
        return stringBuffer.toString();
    }

    protected String listingString0(boolean bl) {
        int n = this.user.getAddress();
        StringBuffer stringBuffer = new StringBuffer(100);
        int n2 = this.targets.length;
        stringBuffer.append(this.packed ? "packed" : "sparse");
        stringBuffer.append("-switch-payload // for switch @ ");
        stringBuffer.append(Hex.u2(n));
        for (int i = 0; i < n2; ++i) {
            int n3 = this.targets[i].getAddress();
            int n4 = n3 - n;
            stringBuffer.append("\n  ");
            stringBuffer.append(this.cases.get(i));
            stringBuffer.append(": ");
            stringBuffer.append(Hex.u4(n3));
            stringBuffer.append(" // ");
            stringBuffer.append(Hex.s4(n4));
        }
        return stringBuffer.toString();
    }

    private static long packedCodeSize(IntList intList) {
        int n = intList.size();
        long l = intList.get(0);
        long l2 = intList.get(n - 1);
        long l3 = (l2 - l + 1L) * 2L + 4L;
        return l3 <= Integer.MAX_VALUE ? l3 : -1L;
    }

    private static long sparseCodeSize(IntList intList) {
        int n = intList.size();
        return (long)n * 4L + 2L;
    }

    private static boolean shouldPack(IntList intList) {
        int n = intList.size();
        if (n < 2) {
            return true;
        }
        long l = SwitchData.packedCodeSize(intList);
        long l2 = SwitchData.sparseCodeSize(intList);
        return l >= 0L && l <= l2 * 5L / 4L;
    }
}

