/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.dex.file;

import com.android.dx.dex.code.CatchHandlerList;
import com.android.dx.dex.code.CatchTable;
import com.android.dx.dex.code.DalvCode;
import com.android.dx.dex.file.DexFile;
import com.android.dx.dex.file.TypeIdsSection;
import com.android.dx.util.AnnotatedOutput;
import com.android.dx.util.ByteArrayAnnotatedOutput;
import com.android.dx.util.Hex;
import java.io.PrintWriter;
import java.util.Map;
import java.util.TreeMap;

public final class CatchStructs {
    private static final int TRY_ITEM_WRITE_SIZE = 8;
    private final DalvCode code;
    private CatchTable table;
    private byte[] encodedHandlers;
    private int encodedHandlerHeaderSize;
    private TreeMap<CatchHandlerList, Integer> handlerOffsets;

    public CatchStructs(DalvCode dalvCode) {
        this.code = dalvCode;
        this.table = null;
        this.encodedHandlers = null;
        this.encodedHandlerHeaderSize = 0;
        this.handlerOffsets = null;
    }

    private void finishProcessingIfNecessary() {
        if (this.table == null) {
            this.table = this.code.getCatches();
        }
    }

    public int triesSize() {
        this.finishProcessingIfNecessary();
        return this.table.size();
    }

    public void debugPrint(PrintWriter printWriter, String string) {
        this.annotateEntries(string, printWriter, null);
    }

    public void encode(DexFile dexFile) {
        this.finishProcessingIfNecessary();
        TypeIdsSection typeIdsSection = dexFile.getTypeIds();
        int n = this.table.size();
        this.handlerOffsets = new TreeMap();
        for (int i = 0; i < n; ++i) {
            this.handlerOffsets.put(this.table.get(i).getHandlers(), null);
        }
        if (this.handlerOffsets.size() > 65535) {
            throw new UnsupportedOperationException("too many catch handlers");
        }
        ByteArrayAnnotatedOutput byteArrayAnnotatedOutput = new ByteArrayAnnotatedOutput();
        this.encodedHandlerHeaderSize = byteArrayAnnotatedOutput.writeUleb128(this.handlerOffsets.size());
        for (Map.Entry<CatchHandlerList, Integer> entry : this.handlerOffsets.entrySet()) {
            CatchHandlerList catchHandlerList = entry.getKey();
            int n2 = catchHandlerList.size();
            boolean bl = catchHandlerList.catchesAll();
            entry.setValue(byteArrayAnnotatedOutput.getCursor());
            if (bl) {
                byteArrayAnnotatedOutput.writeSleb128(-(n2 - 1));
                --n2;
            } else {
                byteArrayAnnotatedOutput.writeSleb128(n2);
            }
            for (int i = 0; i < n2; ++i) {
                CatchHandlerList.Entry entry2 = catchHandlerList.get(i);
                byteArrayAnnotatedOutput.writeUleb128(typeIdsSection.indexOf(entry2.getExceptionType()));
                byteArrayAnnotatedOutput.writeUleb128(entry2.getHandler());
            }
            if (!bl) continue;
            byteArrayAnnotatedOutput.writeUleb128(catchHandlerList.get(n2).getHandler());
        }
        this.encodedHandlers = byteArrayAnnotatedOutput.toByteArray();
    }

    public int writeSize() {
        return this.triesSize() * 8 + this.encodedHandlers.length;
    }

    public void writeTo(DexFile dexFile, AnnotatedOutput annotatedOutput) {
        this.finishProcessingIfNecessary();
        if (annotatedOutput.annotates()) {
            this.annotateEntries("  ", null, annotatedOutput);
        }
        int n = this.table.size();
        for (int i = 0; i < n; ++i) {
            CatchTable.Entry entry = this.table.get(i);
            int n2 = entry.getStart();
            int n3 = entry.getEnd();
            int n4 = n3 - n2;
            if (n4 >= 65536) {
                throw new UnsupportedOperationException("bogus exception range: " + Hex.u4(n2) + ".." + Hex.u4(n3));
            }
            annotatedOutput.writeInt(n2);
            annotatedOutput.writeShort(n4);
            annotatedOutput.writeShort(this.handlerOffsets.get(entry.getHandlers()));
        }
        annotatedOutput.write(this.encodedHandlers);
    }

    private void annotateEntries(String string, PrintWriter printWriter, AnnotatedOutput annotatedOutput) {
        Object object;
        Object object2;
        int n;
        this.finishProcessingIfNecessary();
        boolean bl = annotatedOutput != null;
        int n2 = bl ? 6 : 0;
        int n3 = bl ? 2 : 0;
        int n4 = this.table.size();
        String string2 = string + "  ";
        if (bl) {
            annotatedOutput.annotate(0, string + "tries:");
        } else {
            printWriter.println(string + "tries:");
        }
        for (n = 0; n < n4; ++n) {
            object2 = this.table.get(n);
            CatchHandlerList catchHandlerList = ((CatchTable.Entry)object2).getHandlers();
            String object3 = string2 + "try " + Hex.u2or4(((CatchTable.Entry)object2).getStart()) + ".." + Hex.u2or4(((CatchTable.Entry)object2).getEnd());
            object = catchHandlerList.toHuman(string2, "");
            if (bl) {
                annotatedOutput.annotate(n2, object3);
                annotatedOutput.annotate(n3, (String)object);
                continue;
            }
            printWriter.println(object3);
            printWriter.println((String)object);
        }
        if (!bl) {
            return;
        }
        annotatedOutput.annotate(0, string + "handlers:");
        annotatedOutput.annotate(this.encodedHandlerHeaderSize, string2 + "size: " + Hex.u2(this.handlerOffsets.size()));
        n = 0;
        object2 = null;
        for (Map.Entry entry : this.handlerOffsets.entrySet()) {
            object = (CatchHandlerList)entry.getKey();
            int n5 = (Integer)entry.getValue();
            if (object2 != null) {
                CatchStructs.annotateAndConsumeHandlers((CatchHandlerList)object2, n, n5 - n, string2, printWriter, annotatedOutput);
            }
            object2 = object;
            n = n5;
        }
        CatchStructs.annotateAndConsumeHandlers((CatchHandlerList)object2, n, this.encodedHandlers.length - n, string2, printWriter, annotatedOutput);
    }

    private static void annotateAndConsumeHandlers(CatchHandlerList catchHandlerList, int n, int n2, String string, PrintWriter printWriter, AnnotatedOutput annotatedOutput) {
        String string2 = catchHandlerList.toHuman(string, Hex.u2(n) + ": ");
        if (printWriter != null) {
            printWriter.println(string2);
        }
        annotatedOutput.annotate(n2, string2);
    }
}

