/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.io;

public final class ClassData {
    private final Field[] staticFields;
    private final Field[] instanceFields;
    private final Method[] directMethods;
    private final Method[] virtualMethods;

    public ClassData(Field[] fieldArray, Field[] fieldArray2, Method[] methodArray, Method[] methodArray2) {
        this.staticFields = fieldArray;
        this.instanceFields = fieldArray2;
        this.directMethods = methodArray;
        this.virtualMethods = methodArray2;
    }

    public Field[] getStaticFields() {
        return this.staticFields;
    }

    public Field[] getInstanceFields() {
        return this.instanceFields;
    }

    public Method[] getDirectMethods() {
        return this.directMethods;
    }

    public Method[] getVirtualMethods() {
        return this.virtualMethods;
    }

    public Field[] allFields() {
        Field[] fieldArray = new Field[this.staticFields.length + this.instanceFields.length];
        System.arraycopy(this.staticFields, 0, fieldArray, 0, this.staticFields.length);
        System.arraycopy(this.instanceFields, 0, fieldArray, this.staticFields.length, this.instanceFields.length);
        return fieldArray;
    }

    public Method[] allMethods() {
        Method[] methodArray = new Method[this.directMethods.length + this.virtualMethods.length];
        System.arraycopy(this.directMethods, 0, methodArray, 0, this.directMethods.length);
        System.arraycopy(this.virtualMethods, 0, methodArray, this.directMethods.length, this.virtualMethods.length);
        return methodArray;
    }

    public static class Method {
        private final int methodIndex;
        private final int accessFlags;
        private final int codeOffset;

        public Method(int n, int n2, int n3) {
            this.methodIndex = n;
            this.accessFlags = n2;
            this.codeOffset = n3;
        }

        public int getMethodIndex() {
            return this.methodIndex;
        }

        public int getAccessFlags() {
            return this.accessFlags;
        }

        public int getCodeOffset() {
            return this.codeOffset;
        }
    }

    public static class Field {
        private final int fieldIndex;
        private final int accessFlags;

        public Field(int n, int n2) {
            this.fieldIndex = n;
            this.accessFlags = n2;
        }

        public int getFieldIndex() {
            return this.fieldIndex;
        }

        public int getAccessFlags() {
            return this.accessFlags;
        }
    }
}

