/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.rop.code;

import com.android.dx.rop.code.CstInsn;
import com.android.dx.rop.code.Insn;
import com.android.dx.rop.code.RegisterSpec;
import com.android.dx.rop.code.RegisterSpecList;
import com.android.dx.rop.code.Rop;
import com.android.dx.rop.code.SourcePosition;
import com.android.dx.rop.code.ThrowingInsn;
import com.android.dx.rop.cst.Constant;
import com.android.dx.rop.cst.CstString;
import com.android.dx.rop.type.Type;
import com.android.dx.rop.type.TypeList;

public final class ThrowingCstInsn
extends CstInsn {
    private final TypeList catches;

    public ThrowingCstInsn(Rop rop, SourcePosition sourcePosition, RegisterSpecList registerSpecList, TypeList typeList, Constant constant) {
        super(rop, sourcePosition, null, registerSpecList, constant);
        if (rop.getBranchingness() != 6) {
            throw new IllegalArgumentException("bogus branchingness");
        }
        if (typeList == null) {
            throw new NullPointerException("catches == null");
        }
        this.catches = typeList;
    }

    public String getInlineString() {
        Constant constant = this.getConstant();
        String string = constant.toHuman();
        if (constant instanceof CstString) {
            string = ((CstString)constant).toQuoted();
        }
        return string + " " + ThrowingInsn.toCatchString(this.catches);
    }

    public TypeList getCatches() {
        return this.catches;
    }

    public void accept(Insn.Visitor visitor) {
        visitor.visitThrowingCstInsn(this);
    }

    public Insn withAddedCatch(Type type) {
        return new ThrowingCstInsn(this.getOpcode(), this.getPosition(), this.getSources(), this.catches.withAddedType(type), this.getConstant());
    }

    public Insn withRegisterOffset(int n) {
        return new ThrowingCstInsn(this.getOpcode(), this.getPosition(), this.getSources().withOffset(n), this.catches, this.getConstant());
    }

    public Insn withNewRegisters(RegisterSpec registerSpec, RegisterSpecList registerSpecList) {
        return new ThrowingCstInsn(this.getOpcode(), this.getPosition(), registerSpecList, this.catches, this.getConstant());
    }
}

