/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.rop.cst;

import com.android.dx.rop.cst.CstLiteral32;
import com.android.dx.rop.type.Type;
import com.android.dx.util.Hex;

public final class CstShort
extends CstLiteral32 {
    public static final CstShort VALUE_0 = CstShort.make((short)0);

    public static CstShort make(short s) {
        return new CstShort(s);
    }

    public static CstShort make(int n) {
        short s = (short)n;
        if (s != n) {
            throw new IllegalArgumentException("bogus short value: " + n);
        }
        return CstShort.make(s);
    }

    private CstShort(short s) {
        super(s);
    }

    public String toString() {
        int n = this.getIntBits();
        return "short{0x" + Hex.u2(n) + " / " + n + '}';
    }

    public Type getType() {
        return Type.SHORT;
    }

    public String typeName() {
        return "short";
    }

    public String toHuman() {
        return Integer.toString(this.getIntBits());
    }

    public short getValue() {
        return (short)this.getIntBits();
    }
}

