/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.cf.code;

import com.android.dx.cf.code.ByteOps;
import com.android.dx.cf.code.SimException;
import com.android.dx.cf.code.SwitchList;
import com.android.dx.rop.cst.Constant;
import com.android.dx.rop.cst.ConstantPool;
import com.android.dx.rop.cst.CstDouble;
import com.android.dx.rop.cst.CstFloat;
import com.android.dx.rop.cst.CstInteger;
import com.android.dx.rop.cst.CstKnownNull;
import com.android.dx.rop.cst.CstLiteralBits;
import com.android.dx.rop.cst.CstLong;
import com.android.dx.rop.cst.CstType;
import com.android.dx.rop.type.Type;
import com.android.dx.util.Bits;
import com.android.dx.util.ByteArray;
import com.android.dx.util.Hex;
import java.util.ArrayList;

public final class BytecodeArray {
    public static final Visitor EMPTY_VISITOR = new BaseVisitor();
    private final ByteArray bytes;
    private final ConstantPool pool;

    public BytecodeArray(ByteArray byteArray, ConstantPool constantPool) {
        if (byteArray == null) {
            throw new NullPointerException("bytes == null");
        }
        if (constantPool == null) {
            throw new NullPointerException("pool == null");
        }
        this.bytes = byteArray;
        this.pool = constantPool;
    }

    public ByteArray getBytes() {
        return this.bytes;
    }

    public int size() {
        return this.bytes.size();
    }

    public int byteLength() {
        return 4 + this.bytes.size();
    }

    public void forEach(Visitor visitor) {
        int n = this.bytes.size();
        for (int i = 0; i < n; i += this.parseInstruction(i, visitor)) {
        }
    }

    public int[] getInstructionOffsets() {
        int n;
        int n2 = this.bytes.size();
        int[] nArray = Bits.makeBitSet(n2);
        for (int i = 0; i < n2; i += n) {
            Bits.set(nArray, i, true);
            n = this.parseInstruction(i, null);
        }
        return nArray;
    }

    public void processWorkSet(int[] nArray, Visitor visitor) {
        int n;
        if (visitor == null) {
            throw new NullPointerException("visitor == null");
        }
        while ((n = Bits.findFirst(nArray, 0)) >= 0) {
            Bits.clear(nArray, n);
            this.parseInstruction(n, visitor);
            visitor.setPreviousOffset(n);
        }
    }

    public int parseInstruction(int n, Visitor visitor) {
        if (visitor == null) {
            visitor = EMPTY_VISITOR;
        }
        try {
            int n2 = this.bytes.getUnsignedByte(n);
            int n3 = ByteOps.opInfo(n2);
            int n4 = n3 & 0x1F;
            switch (n2) {
                case 0: {
                    visitor.visitNoArgs(n2, n, 1, Type.VOID);
                    return 1;
                }
                case 1: {
                    visitor.visitConstant(18, n, 1, CstKnownNull.THE_ONE, 0);
                    return 1;
                }
                case 2: {
                    visitor.visitConstant(18, n, 1, CstInteger.VALUE_M1, -1);
                    return 1;
                }
                case 3: {
                    visitor.visitConstant(18, n, 1, CstInteger.VALUE_0, 0);
                    return 1;
                }
                case 4: {
                    visitor.visitConstant(18, n, 1, CstInteger.VALUE_1, 1);
                    return 1;
                }
                case 5: {
                    visitor.visitConstant(18, n, 1, CstInteger.VALUE_2, 2);
                    return 1;
                }
                case 6: {
                    visitor.visitConstant(18, n, 1, CstInteger.VALUE_3, 3);
                    return 1;
                }
                case 7: {
                    visitor.visitConstant(18, n, 1, CstInteger.VALUE_4, 4);
                    return 1;
                }
                case 8: {
                    visitor.visitConstant(18, n, 1, CstInteger.VALUE_5, 5);
                    return 1;
                }
                case 9: {
                    visitor.visitConstant(18, n, 1, CstLong.VALUE_0, 0);
                    return 1;
                }
                case 10: {
                    visitor.visitConstant(18, n, 1, CstLong.VALUE_1, 0);
                    return 1;
                }
                case 11: {
                    visitor.visitConstant(18, n, 1, CstFloat.VALUE_0, 0);
                    return 1;
                }
                case 12: {
                    visitor.visitConstant(18, n, 1, CstFloat.VALUE_1, 0);
                    return 1;
                }
                case 13: {
                    visitor.visitConstant(18, n, 1, CstFloat.VALUE_2, 0);
                    return 1;
                }
                case 14: {
                    visitor.visitConstant(18, n, 1, CstDouble.VALUE_0, 0);
                    return 1;
                }
                case 15: {
                    visitor.visitConstant(18, n, 1, CstDouble.VALUE_1, 0);
                    return 1;
                }
                case 16: {
                    int n5 = this.bytes.getByte(n + 1);
                    visitor.visitConstant(18, n, 2, CstInteger.make(n5), n5);
                    return 2;
                }
                case 17: {
                    int n6 = this.bytes.getShort(n + 1);
                    visitor.visitConstant(18, n, 3, CstInteger.make(n6), n6);
                    return 3;
                }
                case 18: {
                    int n7 = this.bytes.getUnsignedByte(n + 1);
                    Constant constant = this.pool.get(n7);
                    int n8 = constant instanceof CstInteger ? ((CstInteger)constant).getValue() : 0;
                    visitor.visitConstant(18, n, 2, constant, n8);
                    return 2;
                }
                case 19: {
                    int n9 = this.bytes.getUnsignedShort(n + 1);
                    Constant constant = this.pool.get(n9);
                    int n10 = constant instanceof CstInteger ? ((CstInteger)constant).getValue() : 0;
                    visitor.visitConstant(18, n, 3, constant, n10);
                    return 3;
                }
                case 20: {
                    int n11 = this.bytes.getUnsignedShort(n + 1);
                    Constant constant = this.pool.get(n11);
                    visitor.visitConstant(20, n, 3, constant, 0);
                    return 3;
                }
                case 21: {
                    int n12 = this.bytes.getUnsignedByte(n + 1);
                    visitor.visitLocal(21, n, 2, n12, Type.INT, 0);
                    return 2;
                }
                case 22: {
                    int n13 = this.bytes.getUnsignedByte(n + 1);
                    visitor.visitLocal(21, n, 2, n13, Type.LONG, 0);
                    return 2;
                }
                case 23: {
                    int n14 = this.bytes.getUnsignedByte(n + 1);
                    visitor.visitLocal(21, n, 2, n14, Type.FLOAT, 0);
                    return 2;
                }
                case 24: {
                    int n15 = this.bytes.getUnsignedByte(n + 1);
                    visitor.visitLocal(21, n, 2, n15, Type.DOUBLE, 0);
                    return 2;
                }
                case 25: {
                    int n16 = this.bytes.getUnsignedByte(n + 1);
                    visitor.visitLocal(21, n, 2, n16, Type.OBJECT, 0);
                    return 2;
                }
                case 26: 
                case 27: 
                case 28: 
                case 29: {
                    int n17 = n2 - 26;
                    visitor.visitLocal(21, n, 1, n17, Type.INT, 0);
                    return 1;
                }
                case 30: 
                case 31: 
                case 32: 
                case 33: {
                    int n18 = n2 - 30;
                    visitor.visitLocal(21, n, 1, n18, Type.LONG, 0);
                    return 1;
                }
                case 34: 
                case 35: 
                case 36: 
                case 37: {
                    int n19 = n2 - 34;
                    visitor.visitLocal(21, n, 1, n19, Type.FLOAT, 0);
                    return 1;
                }
                case 38: 
                case 39: 
                case 40: 
                case 41: {
                    int n20 = n2 - 38;
                    visitor.visitLocal(21, n, 1, n20, Type.DOUBLE, 0);
                    return 1;
                }
                case 42: 
                case 43: 
                case 44: 
                case 45: {
                    int n21 = n2 - 42;
                    visitor.visitLocal(21, n, 1, n21, Type.OBJECT, 0);
                    return 1;
                }
                case 46: {
                    visitor.visitNoArgs(46, n, 1, Type.INT);
                    return 1;
                }
                case 47: {
                    visitor.visitNoArgs(46, n, 1, Type.LONG);
                    return 1;
                }
                case 48: {
                    visitor.visitNoArgs(46, n, 1, Type.FLOAT);
                    return 1;
                }
                case 49: {
                    visitor.visitNoArgs(46, n, 1, Type.DOUBLE);
                    return 1;
                }
                case 50: {
                    visitor.visitNoArgs(46, n, 1, Type.OBJECT);
                    return 1;
                }
                case 51: {
                    visitor.visitNoArgs(46, n, 1, Type.BYTE);
                    return 1;
                }
                case 52: {
                    visitor.visitNoArgs(46, n, 1, Type.CHAR);
                    return 1;
                }
                case 53: {
                    visitor.visitNoArgs(46, n, 1, Type.SHORT);
                    return 1;
                }
                case 54: {
                    int n22 = this.bytes.getUnsignedByte(n + 1);
                    visitor.visitLocal(54, n, 2, n22, Type.INT, 0);
                    return 2;
                }
                case 55: {
                    int n23 = this.bytes.getUnsignedByte(n + 1);
                    visitor.visitLocal(54, n, 2, n23, Type.LONG, 0);
                    return 2;
                }
                case 56: {
                    int n24 = this.bytes.getUnsignedByte(n + 1);
                    visitor.visitLocal(54, n, 2, n24, Type.FLOAT, 0);
                    return 2;
                }
                case 57: {
                    int n25 = this.bytes.getUnsignedByte(n + 1);
                    visitor.visitLocal(54, n, 2, n25, Type.DOUBLE, 0);
                    return 2;
                }
                case 58: {
                    int n26 = this.bytes.getUnsignedByte(n + 1);
                    visitor.visitLocal(54, n, 2, n26, Type.OBJECT, 0);
                    return 2;
                }
                case 59: 
                case 60: 
                case 61: 
                case 62: {
                    int n27 = n2 - 59;
                    visitor.visitLocal(54, n, 1, n27, Type.INT, 0);
                    return 1;
                }
                case 63: 
                case 64: 
                case 65: 
                case 66: {
                    int n28 = n2 - 63;
                    visitor.visitLocal(54, n, 1, n28, Type.LONG, 0);
                    return 1;
                }
                case 67: 
                case 68: 
                case 69: 
                case 70: {
                    int n29 = n2 - 67;
                    visitor.visitLocal(54, n, 1, n29, Type.FLOAT, 0);
                    return 1;
                }
                case 71: 
                case 72: 
                case 73: 
                case 74: {
                    int n30 = n2 - 71;
                    visitor.visitLocal(54, n, 1, n30, Type.DOUBLE, 0);
                    return 1;
                }
                case 75: 
                case 76: 
                case 77: 
                case 78: {
                    int n31 = n2 - 75;
                    visitor.visitLocal(54, n, 1, n31, Type.OBJECT, 0);
                    return 1;
                }
                case 79: {
                    visitor.visitNoArgs(79, n, 1, Type.INT);
                    return 1;
                }
                case 80: {
                    visitor.visitNoArgs(79, n, 1, Type.LONG);
                    return 1;
                }
                case 81: {
                    visitor.visitNoArgs(79, n, 1, Type.FLOAT);
                    return 1;
                }
                case 82: {
                    visitor.visitNoArgs(79, n, 1, Type.DOUBLE);
                    return 1;
                }
                case 83: {
                    visitor.visitNoArgs(79, n, 1, Type.OBJECT);
                    return 1;
                }
                case 84: {
                    visitor.visitNoArgs(79, n, 1, Type.BYTE);
                    return 1;
                }
                case 85: {
                    visitor.visitNoArgs(79, n, 1, Type.CHAR);
                    return 1;
                }
                case 86: {
                    visitor.visitNoArgs(79, n, 1, Type.SHORT);
                    return 1;
                }
                case 87: 
                case 88: 
                case 89: 
                case 90: 
                case 91: 
                case 92: 
                case 93: 
                case 94: 
                case 95: {
                    visitor.visitNoArgs(n2, n, 1, Type.VOID);
                    return 1;
                }
                case 96: 
                case 100: 
                case 104: 
                case 108: 
                case 112: 
                case 116: 
                case 120: 
                case 122: 
                case 124: 
                case 126: 
                case 128: 
                case 130: {
                    visitor.visitNoArgs(n2, n, 1, Type.INT);
                    return 1;
                }
                case 97: 
                case 101: 
                case 105: 
                case 109: 
                case 113: 
                case 117: 
                case 121: 
                case 123: 
                case 125: 
                case 127: 
                case 129: 
                case 131: {
                    visitor.visitNoArgs(n2 - 1, n, 1, Type.LONG);
                    return 1;
                }
                case 98: 
                case 102: 
                case 106: 
                case 110: 
                case 114: 
                case 118: {
                    visitor.visitNoArgs(n2 - 2, n, 1, Type.FLOAT);
                    return 1;
                }
                case 99: 
                case 103: 
                case 107: 
                case 111: 
                case 115: 
                case 119: {
                    visitor.visitNoArgs(n2 - 3, n, 1, Type.DOUBLE);
                    return 1;
                }
                case 132: {
                    int n32 = this.bytes.getUnsignedByte(n + 1);
                    int n33 = this.bytes.getByte(n + 2);
                    visitor.visitLocal(n2, n, 3, n32, Type.INT, n33);
                    return 3;
                }
                case 133: 
                case 140: 
                case 143: {
                    visitor.visitNoArgs(n2, n, 1, Type.LONG);
                    return 1;
                }
                case 134: 
                case 137: 
                case 144: {
                    visitor.visitNoArgs(n2, n, 1, Type.FLOAT);
                    return 1;
                }
                case 135: 
                case 138: 
                case 141: {
                    visitor.visitNoArgs(n2, n, 1, Type.DOUBLE);
                    return 1;
                }
                case 136: 
                case 139: 
                case 142: 
                case 145: 
                case 146: 
                case 147: 
                case 148: 
                case 149: 
                case 150: 
                case 151: 
                case 152: 
                case 190: {
                    visitor.visitNoArgs(n2, n, 1, Type.INT);
                    return 1;
                }
                case 153: 
                case 154: 
                case 155: 
                case 156: 
                case 157: 
                case 158: 
                case 159: 
                case 160: 
                case 161: 
                case 162: 
                case 163: 
                case 164: 
                case 165: 
                case 166: 
                case 167: 
                case 168: 
                case 198: 
                case 199: {
                    int n34 = n + this.bytes.getShort(n + 1);
                    visitor.visitBranch(n2, n, 3, n34);
                    return 3;
                }
                case 169: {
                    int n35 = this.bytes.getUnsignedByte(n + 1);
                    visitor.visitLocal(n2, n, 2, n35, Type.RETURN_ADDRESS, 0);
                    return 2;
                }
                case 170: {
                    return this.parseTableswitch(n, visitor);
                }
                case 171: {
                    return this.parseLookupswitch(n, visitor);
                }
                case 172: {
                    visitor.visitNoArgs(172, n, 1, Type.INT);
                    return 1;
                }
                case 173: {
                    visitor.visitNoArgs(172, n, 1, Type.LONG);
                    return 1;
                }
                case 174: {
                    visitor.visitNoArgs(172, n, 1, Type.FLOAT);
                    return 1;
                }
                case 175: {
                    visitor.visitNoArgs(172, n, 1, Type.DOUBLE);
                    return 1;
                }
                case 176: {
                    visitor.visitNoArgs(172, n, 1, Type.OBJECT);
                    return 1;
                }
                case 177: 
                case 191: 
                case 194: 
                case 195: {
                    visitor.visitNoArgs(n2, n, 1, Type.VOID);
                    return 1;
                }
                case 178: 
                case 179: 
                case 180: 
                case 181: 
                case 182: 
                case 183: 
                case 184: 
                case 187: 
                case 189: 
                case 192: 
                case 193: {
                    int n36 = this.bytes.getUnsignedShort(n + 1);
                    Constant constant = this.pool.get(n36);
                    visitor.visitConstant(n2, n, 3, constant, 0);
                    return 3;
                }
                case 185: {
                    int n37 = this.bytes.getUnsignedShort(n + 1);
                    int n38 = this.bytes.getUnsignedByte(n + 3);
                    int n39 = this.bytes.getUnsignedByte(n + 4);
                    Constant constant = this.pool.get(n37);
                    visitor.visitConstant(n2, n, 5, constant, n38 | n39 << 8);
                    return 5;
                }
                case 188: {
                    return this.parseNewarray(n, visitor);
                }
                case 196: {
                    return this.parseWide(n, visitor);
                }
                case 197: {
                    int n40 = this.bytes.getUnsignedShort(n + 1);
                    int n41 = this.bytes.getUnsignedByte(n + 3);
                    Constant constant = this.pool.get(n40);
                    visitor.visitConstant(n2, n, 4, constant, n41);
                    return 4;
                }
                case 200: 
                case 201: {
                    int n42 = n + this.bytes.getInt(n + 1);
                    int n43 = n2 == 200 ? 167 : 168;
                    visitor.visitBranch(n43, n, 5, n42);
                    return 5;
                }
            }
            visitor.visitInvalid(n2, n, 1);
            return 1;
        }
        catch (SimException simException) {
            simException.addContext("...at bytecode offset " + Hex.u4(n));
            throw simException;
        }
        catch (RuntimeException runtimeException) {
            SimException simException = new SimException(runtimeException);
            simException.addContext("...at bytecode offset " + Hex.u4(n));
            throw simException;
        }
    }

    private int parseTableswitch(int n, Visitor visitor) {
        int n2;
        int n3;
        int n4 = n + 4 & 0xFFFFFFFC;
        int n5 = 0;
        for (n3 = n + 1; n3 < n4; ++n3) {
            n5 = n5 << 8 | this.bytes.getUnsignedByte(n3);
        }
        n3 = n + this.bytes.getInt(n4);
        int n6 = this.bytes.getInt(n4 + 4);
        int n7 = this.bytes.getInt(n4 + 8);
        int n8 = n7 - n6 + 1;
        n4 += 12;
        if (n6 > n7) {
            throw new SimException("low / high inversion");
        }
        SwitchList switchList = new SwitchList(n8);
        for (n2 = 0; n2 < n8; ++n2) {
            int n9 = n + this.bytes.getInt(n4);
            n4 += 4;
            switchList.add(n6 + n2, n9);
        }
        switchList.setDefaultTarget(n3);
        switchList.removeSuperfluousDefaults();
        switchList.setImmutable();
        n2 = n4 - n;
        visitor.visitSwitch(171, n, n2, switchList, n5);
        return n2;
    }

    private int parseLookupswitch(int n, Visitor visitor) {
        int n2;
        int n3;
        int n4 = n + 4 & 0xFFFFFFFC;
        int n5 = 0;
        for (n3 = n + 1; n3 < n4; ++n3) {
            n5 = n5 << 8 | this.bytes.getUnsignedByte(n3);
        }
        n3 = n + this.bytes.getInt(n4);
        int n6 = this.bytes.getInt(n4 + 4);
        n4 += 8;
        SwitchList switchList = new SwitchList(n6);
        for (n2 = 0; n2 < n6; ++n2) {
            int n7 = this.bytes.getInt(n4);
            int n8 = n + this.bytes.getInt(n4 + 4);
            n4 += 8;
            switchList.add(n7, n8);
        }
        switchList.setDefaultTarget(n3);
        switchList.removeSuperfluousDefaults();
        switchList.setImmutable();
        n2 = n4 - n;
        visitor.visitSwitch(171, n, n2, switchList, n5);
        return n2;
    }

    private int parseNewarray(int n, Visitor visitor) {
        int n2;
        CstType cstType;
        int n3 = this.bytes.getUnsignedByte(n + 1);
        switch (n3) {
            case 4: {
                cstType = CstType.BOOLEAN_ARRAY;
                break;
            }
            case 5: {
                cstType = CstType.CHAR_ARRAY;
                break;
            }
            case 7: {
                cstType = CstType.DOUBLE_ARRAY;
                break;
            }
            case 6: {
                cstType = CstType.FLOAT_ARRAY;
                break;
            }
            case 8: {
                cstType = CstType.BYTE_ARRAY;
                break;
            }
            case 9: {
                cstType = CstType.SHORT_ARRAY;
                break;
            }
            case 10: {
                cstType = CstType.INT_ARRAY;
                break;
            }
            case 11: {
                cstType = CstType.LONG_ARRAY;
                break;
            }
            default: {
                throw new SimException("bad newarray code " + Hex.u1(n3));
            }
        }
        int n4 = visitor.getPreviousOffset();
        ConstantParserVisitor constantParserVisitor = new ConstantParserVisitor();
        int n5 = 0;
        if (n4 >= 0) {
            this.parseInstruction(n4, constantParserVisitor);
            if (constantParserVisitor.cst instanceof CstInteger && constantParserVisitor.length + n4 == n) {
                n5 = constantParserVisitor.value;
            }
        }
        int n6 = 0;
        int n7 = n2 = n + 2;
        ArrayList<Constant> arrayList = new ArrayList<Constant>();
        if (n5 != 0) {
            while (true) {
                int n8;
                boolean bl = false;
                if ((n8 = this.bytes.getUnsignedByte(n2++)) != 89) break;
                this.parseInstruction(n2, constantParserVisitor);
                if (constantParserVisitor.length == 0 || !(constantParserVisitor.cst instanceof CstInteger) || constantParserVisitor.value != n6) break;
                this.parseInstruction(n2 += constantParserVisitor.length, constantParserVisitor);
                if (constantParserVisitor.length == 0 || !(constantParserVisitor.cst instanceof CstLiteralBits)) break;
                n2 += constantParserVisitor.length;
                arrayList.add(constantParserVisitor.cst);
                n8 = this.bytes.getUnsignedByte(n2++);
                switch (n3) {
                    case 4: 
                    case 8: {
                        if (n8 == 84) break;
                        bl = true;
                        break;
                    }
                    case 5: {
                        if (n8 == 85) break;
                        bl = true;
                        break;
                    }
                    case 7: {
                        if (n8 == 82) break;
                        bl = true;
                        break;
                    }
                    case 6: {
                        if (n8 == 81) break;
                        bl = true;
                        break;
                    }
                    case 9: {
                        if (n8 == 86) break;
                        bl = true;
                        break;
                    }
                    case 10: {
                        if (n8 == 79) break;
                        bl = true;
                        break;
                    }
                    case 11: {
                        if (n8 == 80) break;
                        bl = true;
                        break;
                    }
                    default: {
                        bl = true;
                    }
                }
                if (bl) break;
                n7 = n2;
                ++n6;
            }
        }
        if (n6 < 2 || n6 != n5) {
            visitor.visitNewarray(n, 2, cstType, null);
            return 2;
        }
        visitor.visitNewarray(n, n7 - n, cstType, arrayList);
        return n7 - n;
    }

    private int parseWide(int n, Visitor visitor) {
        int n2 = this.bytes.getUnsignedByte(n + 1);
        int n3 = this.bytes.getUnsignedShort(n + 2);
        switch (n2) {
            case 21: {
                visitor.visitLocal(21, n, 4, n3, Type.INT, 0);
                return 4;
            }
            case 22: {
                visitor.visitLocal(21, n, 4, n3, Type.LONG, 0);
                return 4;
            }
            case 23: {
                visitor.visitLocal(21, n, 4, n3, Type.FLOAT, 0);
                return 4;
            }
            case 24: {
                visitor.visitLocal(21, n, 4, n3, Type.DOUBLE, 0);
                return 4;
            }
            case 25: {
                visitor.visitLocal(21, n, 4, n3, Type.OBJECT, 0);
                return 4;
            }
            case 54: {
                visitor.visitLocal(54, n, 4, n3, Type.INT, 0);
                return 4;
            }
            case 55: {
                visitor.visitLocal(54, n, 4, n3, Type.LONG, 0);
                return 4;
            }
            case 56: {
                visitor.visitLocal(54, n, 4, n3, Type.FLOAT, 0);
                return 4;
            }
            case 57: {
                visitor.visitLocal(54, n, 4, n3, Type.DOUBLE, 0);
                return 4;
            }
            case 58: {
                visitor.visitLocal(54, n, 4, n3, Type.OBJECT, 0);
                return 4;
            }
            case 169: {
                visitor.visitLocal(n2, n, 4, n3, Type.RETURN_ADDRESS, 0);
                return 4;
            }
            case 132: {
                int n4 = this.bytes.getShort(n + 4);
                visitor.visitLocal(n2, n, 6, n3, Type.INT, n4);
                return 6;
            }
        }
        visitor.visitInvalid(196, n, 1);
        return 1;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ConstantParserVisitor
    extends BaseVisitor {
        Constant cst;
        int length;
        int value;

        ConstantParserVisitor() {
        }

        private void clear() {
            this.length = 0;
        }

        @Override
        public void visitInvalid(int n, int n2, int n3) {
            this.clear();
        }

        @Override
        public void visitNoArgs(int n, int n2, int n3, Type type) {
            this.clear();
        }

        @Override
        public void visitLocal(int n, int n2, int n3, int n4, Type type, int n5) {
            this.clear();
        }

        @Override
        public void visitConstant(int n, int n2, int n3, Constant constant, int n4) {
            this.cst = constant;
            this.length = n3;
            this.value = n4;
        }

        @Override
        public void visitBranch(int n, int n2, int n3, int n4) {
            this.clear();
        }

        @Override
        public void visitSwitch(int n, int n2, int n3, SwitchList switchList, int n4) {
            this.clear();
        }

        @Override
        public void visitNewarray(int n, int n2, CstType cstType, ArrayList<Constant> arrayList) {
            this.clear();
        }

        @Override
        public void setPreviousOffset(int n) {
        }

        @Override
        public int getPreviousOffset() {
            return -1;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BaseVisitor
    implements Visitor {
        private int previousOffset = -1;

        BaseVisitor() {
        }

        @Override
        public void visitInvalid(int n, int n2, int n3) {
        }

        @Override
        public void visitNoArgs(int n, int n2, int n3, Type type) {
        }

        @Override
        public void visitLocal(int n, int n2, int n3, int n4, Type type, int n5) {
        }

        @Override
        public void visitConstant(int n, int n2, int n3, Constant constant, int n4) {
        }

        @Override
        public void visitBranch(int n, int n2, int n3, int n4) {
        }

        @Override
        public void visitSwitch(int n, int n2, int n3, SwitchList switchList, int n4) {
        }

        @Override
        public void visitNewarray(int n, int n2, CstType cstType, ArrayList<Constant> arrayList) {
        }

        @Override
        public void setPreviousOffset(int n) {
            this.previousOffset = n;
        }

        @Override
        public int getPreviousOffset() {
            return this.previousOffset;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Visitor {
        public void visitInvalid(int var1, int var2, int var3);

        public void visitNoArgs(int var1, int var2, int var3, Type var4);

        public void visitLocal(int var1, int var2, int var3, int var4, Type var5, int var6);

        public void visitConstant(int var1, int var2, int var3, Constant var4, int var5);

        public void visitBranch(int var1, int var2, int var3, int var4);

        public void visitSwitch(int var1, int var2, int var3, SwitchList var4, int var5);

        public void visitNewarray(int var1, int var2, CstType var3, ArrayList<Constant> var4);

        public void setPreviousOffset(int var1);

        public int getPreviousOffset();
    }
}

