/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.command.dump;

import com.android.dx.cf.code.ConcreteMethod;
import com.android.dx.cf.code.Ropper;
import com.android.dx.cf.iface.Member;
import com.android.dx.cf.iface.Method;
import com.android.dx.command.dump.Args;
import com.android.dx.command.dump.BlockDumper;
import com.android.dx.rop.code.AccessFlags;
import com.android.dx.rop.code.DexTranslationAdvice;
import com.android.dx.rop.code.RopMethod;
import com.android.dx.ssa.Optimizer;
import com.android.dx.ssa.SsaBasicBlock;
import com.android.dx.ssa.SsaInsn;
import com.android.dx.ssa.SsaMethod;
import com.android.dx.util.ByteArray;
import com.android.dx.util.Hex;
import com.android.dx.util.IntList;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.EnumSet;

public class SsaDumper
extends BlockDumper {
    public static void dump(byte[] byArray, PrintStream printStream, String string, Args args) {
        SsaDumper ssaDumper = new SsaDumper(byArray, printStream, string, args);
        ssaDumper.dump();
    }

    private SsaDumper(byte[] byArray, PrintStream printStream, String string, Args args) {
        super(byArray, printStream, string, true, args);
    }

    public void endParsingMember(ByteArray byteArray, int n, String string, String string2, Member member) {
        if (!(member instanceof Method)) {
            return;
        }
        if (!this.shouldDumpMethod(string)) {
            return;
        }
        if ((member.getAccessFlags() & 0x500) != 0) {
            return;
        }
        ConcreteMethod concreteMethod = new ConcreteMethod((Method)member, this.classFile, true, true);
        DexTranslationAdvice dexTranslationAdvice = DexTranslationAdvice.THE_ONE;
        RopMethod ropMethod = Ropper.convert(concreteMethod, dexTranslationAdvice);
        SsaMethod ssaMethod = null;
        boolean bl = AccessFlags.isStatic(concreteMethod.getAccessFlags());
        int n2 = SsaDumper.computeParamWidth(concreteMethod, bl);
        if (this.args.ssaStep == null) {
            ssaMethod = Optimizer.debugNoRegisterAllocation(ropMethod, n2, bl, true, dexTranslationAdvice, EnumSet.allOf(Optimizer.OptionalStep.class));
        } else if ("edge-split".equals(this.args.ssaStep)) {
            ssaMethod = Optimizer.debugEdgeSplit(ropMethod, n2, bl, true, dexTranslationAdvice);
        } else if ("phi-placement".equals(this.args.ssaStep)) {
            ssaMethod = Optimizer.debugPhiPlacement(ropMethod, n2, bl, true, dexTranslationAdvice);
        } else if ("renaming".equals(this.args.ssaStep)) {
            ssaMethod = Optimizer.debugRenaming(ropMethod, n2, bl, true, dexTranslationAdvice);
        } else if ("dead-code".equals(this.args.ssaStep)) {
            ssaMethod = Optimizer.debugDeadCodeRemover(ropMethod, n2, bl, true, dexTranslationAdvice);
        }
        StringBuffer stringBuffer = new StringBuffer(2000);
        stringBuffer.append("first ");
        stringBuffer.append(Hex.u2(ssaMethod.blockIndexToRopLabel(ssaMethod.getEntryBlockIndex())));
        stringBuffer.append('\n');
        ArrayList<SsaBasicBlock> arrayList = ssaMethod.getBlocks();
        ArrayList arrayList2 = (ArrayList)arrayList.clone();
        Collections.sort(arrayList2, SsaBasicBlock.LABEL_COMPARATOR);
        for (SsaBasicBlock ssaBasicBlock : arrayList2) {
            stringBuffer.append("block ").append(Hex.u2(ssaBasicBlock.getRopLabel())).append('\n');
            BitSet bitSet = ssaBasicBlock.getPredecessors();
            int n3 = bitSet.nextSetBit(0);
            while (n3 >= 0) {
                stringBuffer.append("  pred ");
                stringBuffer.append(Hex.u2(ssaMethod.blockIndexToRopLabel(n3)));
                stringBuffer.append('\n');
                n3 = bitSet.nextSetBit(n3 + 1);
            }
            stringBuffer.append("  live in:" + ssaBasicBlock.getLiveInRegs());
            stringBuffer.append("\n");
            for (SsaInsn ssaInsn : ssaBasicBlock.getInsns()) {
                stringBuffer.append("  ");
                stringBuffer.append(ssaInsn.toHuman());
                stringBuffer.append('\n');
            }
            if (ssaBasicBlock.getSuccessors().cardinality() == 0) {
                stringBuffer.append("  returns\n");
            } else {
                int n4 = ssaBasicBlock.getPrimarySuccessorRopLabel();
                IntList intList = ssaBasicBlock.getRopLabelSuccessorList();
                int n5 = intList.size();
                for (int i = 0; i < n5; ++i) {
                    stringBuffer.append("  next ");
                    stringBuffer.append(Hex.u2(intList.get(i)));
                    if (n5 != 1 && n4 == intList.get(i)) {
                        stringBuffer.append(" *");
                    }
                    stringBuffer.append('\n');
                }
            }
            stringBuffer.append("  live out:" + ssaBasicBlock.getLiveOutRegs());
            stringBuffer.append("\n");
        }
        this.suppressDump = false;
        this.setAt(byteArray, 0);
        this.parsed(byteArray, 0, byteArray.size(), stringBuffer.toString());
        this.suppressDump = true;
    }
}

