/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.dex.cf;

import com.android.dx.dex.cf.CfOptions;
import com.android.dx.rop.code.RopMethod;
import com.android.dx.rop.code.TranslationAdvice;
import com.android.dx.ssa.Optimizer;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.EnumSet;
import java.util.HashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OptimizerOptions {
    private static HashSet<String> optimizeList;
    private static HashSet<String> dontOptimizeList;
    private static boolean optimizeListsLoaded;

    private OptimizerOptions() {
    }

    public static void loadOptimizeLists(String string, String string2) {
        if (optimizeListsLoaded) {
            return;
        }
        if (string != null && string2 != null) {
            throw new RuntimeException("optimize and don't optimize lists  are mutually exclusive.");
        }
        if (string != null) {
            optimizeList = OptimizerOptions.loadStringsFromFile(string);
        }
        if (string2 != null) {
            dontOptimizeList = OptimizerOptions.loadStringsFromFile(string2);
        }
        optimizeListsLoaded = true;
    }

    private static HashSet<String> loadStringsFromFile(String string) {
        HashSet<String> hashSet = new HashSet<String>();
        try {
            String string2;
            FileReader fileReader = new FileReader(string);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            while (null != (string2 = bufferedReader.readLine())) {
                hashSet.add(string2);
            }
            fileReader.close();
        }
        catch (IOException iOException) {
            throw new RuntimeException("Error with optimize list: " + string, iOException);
        }
        return hashSet;
    }

    public static void compareOptimizerStep(RopMethod ropMethod, int n, boolean bl, CfOptions cfOptions, TranslationAdvice translationAdvice, RopMethod ropMethod2) {
        EnumSet<Optimizer.OptionalStep> enumSet = EnumSet.allOf(Optimizer.OptionalStep.class);
        enumSet.remove((Object)Optimizer.OptionalStep.CONST_COLLECTOR);
        RopMethod ropMethod3 = Optimizer.optimize(ropMethod, n, bl, cfOptions.localInfo, translationAdvice, enumSet);
        int n2 = ropMethod2.getBlocks().getEffectiveInstructionCount();
        int n3 = ropMethod3.getBlocks().getEffectiveInstructionCount();
        System.err.printf("optimize step regs:(%d/%d/%.2f%%) insns:(%d/%d/%.2f%%)\n", ropMethod2.getBlocks().getRegCount(), ropMethod3.getBlocks().getRegCount(), 100.0 * (double)((float)(ropMethod3.getBlocks().getRegCount() - ropMethod2.getBlocks().getRegCount()) / (float)ropMethod3.getBlocks().getRegCount()), n2, n3, 100.0 * (double)((float)(n3 - n2) / (float)n3));
    }

    public static boolean shouldOptimize(String string) {
        if (optimizeList != null) {
            return optimizeList.contains(string);
        }
        if (dontOptimizeList != null) {
            return !dontOptimizeList.contains(string);
        }
        return true;
    }
}

