/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.io;

import com.android.dx.dex.TableOfContents;
import com.android.dx.io.Annotation;
import com.android.dx.io.ClassData;
import com.android.dx.io.ClassDef;
import com.android.dx.io.Code;
import com.android.dx.io.EncodedValue;
import com.android.dx.io.EncodedValueReader;
import com.android.dx.io.FieldId;
import com.android.dx.io.MethodId;
import com.android.dx.io.ProtoId;
import com.android.dx.merge.TypeList;
import com.android.dx.util.ByteInput;
import com.android.dx.util.ByteOutput;
import com.android.dx.util.DexException;
import com.android.dx.util.FileUtils;
import com.android.dx.util.Leb128Utils;
import com.android.dx.util.Mutf8;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UTFDataFormatException;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DexBuffer {
    private byte[] data;
    private final TableOfContents tableOfContents = new TableOfContents();
    private int length = 0;
    private final List<String> strings = new AbstractList<String>(){

        @Override
        public String get(int n) {
            DexBuffer.checkBounds(n, ((DexBuffer)DexBuffer.this).tableOfContents.stringIds.size);
            return DexBuffer.this.open(((DexBuffer)DexBuffer.this).tableOfContents.stringIds.off + n * 4).readString();
        }

        @Override
        public int size() {
            return ((DexBuffer)DexBuffer.this).tableOfContents.stringIds.size;
        }
    };
    private final List<Integer> typeIds = new AbstractList<Integer>(){

        @Override
        public Integer get(int n) {
            DexBuffer.checkBounds(n, ((DexBuffer)DexBuffer.this).tableOfContents.typeIds.size);
            return DexBuffer.this.open(((DexBuffer)DexBuffer.this).tableOfContents.typeIds.off + n * 4).readInt();
        }

        @Override
        public int size() {
            return ((DexBuffer)DexBuffer.this).tableOfContents.typeIds.size;
        }
    };
    private final List<String> typeNames = new AbstractList<String>(){

        @Override
        public String get(int n) {
            DexBuffer.checkBounds(n, ((DexBuffer)DexBuffer.this).tableOfContents.typeIds.size);
            return (String)DexBuffer.this.strings.get((Integer)DexBuffer.this.typeIds.get(n));
        }

        @Override
        public int size() {
            return ((DexBuffer)DexBuffer.this).tableOfContents.typeIds.size;
        }
    };
    private final List<ProtoId> protoIds = new AbstractList<ProtoId>(){

        @Override
        public ProtoId get(int n) {
            DexBuffer.checkBounds(n, ((DexBuffer)DexBuffer.this).tableOfContents.protoIds.size);
            return DexBuffer.this.open(((DexBuffer)DexBuffer.this).tableOfContents.protoIds.off + 12 * n).readProtoId();
        }

        @Override
        public int size() {
            return ((DexBuffer)DexBuffer.this).tableOfContents.protoIds.size;
        }
    };
    private final List<FieldId> fieldIds = new AbstractList<FieldId>(){

        @Override
        public FieldId get(int n) {
            DexBuffer.checkBounds(n, ((DexBuffer)DexBuffer.this).tableOfContents.fieldIds.size);
            return DexBuffer.this.open(((DexBuffer)DexBuffer.this).tableOfContents.fieldIds.off + 8 * n).readFieldId();
        }

        @Override
        public int size() {
            return ((DexBuffer)DexBuffer.this).tableOfContents.fieldIds.size;
        }
    };
    private final List<MethodId> methodIds = new AbstractList<MethodId>(){

        @Override
        public MethodId get(int n) {
            DexBuffer.checkBounds(n, ((DexBuffer)DexBuffer.this).tableOfContents.methodIds.size);
            return DexBuffer.this.open(((DexBuffer)DexBuffer.this).tableOfContents.methodIds.off + 8 * n).readMethodId();
        }

        @Override
        public int size() {
            return ((DexBuffer)DexBuffer.this).tableOfContents.methodIds.size;
        }
    };

    public DexBuffer() {
        this.data = new byte[0];
    }

    public DexBuffer(byte[] byArray) throws IOException {
        this.data = byArray;
        this.length = byArray.length;
        this.tableOfContents.readFrom(this);
    }

    public DexBuffer(InputStream inputStream) throws IOException {
        this.loadFrom(inputStream);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DexBuffer(File file) throws IOException {
        if (FileUtils.hasArchiveSuffix(file.getName())) {
            ZipFile zipFile = new ZipFile(file);
            ZipEntry zipEntry = zipFile.getEntry("classes.dex");
            if (zipEntry == null) throw new DexException("Expected classes.dex in " + file);
            this.loadFrom(zipFile.getInputStream(zipEntry));
            zipFile.close();
            return;
        } else {
            if (!file.getName().endsWith(".dex")) throw new DexException("unknown output extension: " + file);
            this.loadFrom(new FileInputStream(file));
        }
    }

    private void loadFrom(InputStream inputStream) throws IOException {
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[8192];
        while ((n = inputStream.read(byArray)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        inputStream.close();
        this.data = byteArrayOutputStream.toByteArray();
        this.length = this.data.length;
        this.tableOfContents.readFrom(this);
    }

    private static void checkBounds(int n, int n2) {
        if (n < 0 || n >= n2) {
            throw new IndexOutOfBoundsException("index:" + n + ", length=" + n2);
        }
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        outputStream.write(this.data);
    }

    public void writeTo(File file) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        this.writeTo(fileOutputStream);
        ((OutputStream)fileOutputStream).close();
    }

    public TableOfContents getTableOfContents() {
        return this.tableOfContents;
    }

    public Section open(int n) {
        if (n < 0 || n > this.length) {
            throw new IllegalArgumentException("position=" + n + " length=" + this.length);
        }
        return new Section(n);
    }

    public Section appendSection(int n, String string) {
        int n2 = DexBuffer.fourByteAlign(this.length + n);
        Section section = new Section(string, this.length, n2);
        this.length = n2;
        return section;
    }

    public void noMoreSections() {
        this.data = new byte[this.length];
    }

    public int getLength() {
        return this.length;
    }

    public static int fourByteAlign(int n) {
        return n + 3 & 0xFFFFFFFC;
    }

    public byte[] getBytes() {
        return this.data;
    }

    public List<String> strings() {
        return this.strings;
    }

    public List<Integer> typeIds() {
        return this.typeIds;
    }

    public List<String> typeNames() {
        return this.typeNames;
    }

    public List<ProtoId> protoIds() {
        return this.protoIds;
    }

    public List<FieldId> fieldIds() {
        return this.fieldIds;
    }

    public List<MethodId> methodIds() {
        return this.methodIds;
    }

    public Iterable<ClassDef> classDefs() {
        return new Iterable<ClassDef>(){

            @Override
            public Iterator<ClassDef> iterator() {
                if (!((DexBuffer)DexBuffer.this).tableOfContents.classDefs.exists()) {
                    return Collections.emptySet().iterator();
                }
                return new Iterator<ClassDef>(){
                    private Section in;
                    private int count;
                    {
                        this.in = DexBuffer.this.open(((DexBuffer)DexBuffer.this).tableOfContents.classDefs.off);
                        this.count = 0;
                    }

                    @Override
                    public boolean hasNext() {
                        return this.count < ((DexBuffer)DexBuffer.this).tableOfContents.classDefs.size;
                    }

                    @Override
                    public ClassDef next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        ++this.count;
                        return this.in.readClassDef();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public TypeList readTypeList(int n) {
        if (n == 0) {
            return TypeList.EMPTY;
        }
        return this.open(n).readTypeList();
    }

    public ClassData readClassData(ClassDef classDef) {
        int n = classDef.getClassDataOffset();
        if (n == 0) {
            throw new IllegalArgumentException("offset == 0");
        }
        return this.open(n).readClassData();
    }

    public Code readCode(ClassData.Method method) {
        int n = method.getCodeOffset();
        if (n == 0) {
            throw new IllegalArgumentException("offset == 0");
        }
        return this.open(n).readCode();
    }

    public final class Section
    implements ByteInput,
    ByteOutput {
        private final String name;
        private int position;
        private final int limit;
        private final int initialPosition;

        private Section(String string, int n, int n2) {
            this.name = string;
            this.position = this.initialPosition = n;
            this.limit = n2;
        }

        private Section(int n) {
            this("section", n, dexBuffer.data.length);
        }

        public int getPosition() {
            return this.position;
        }

        public int readInt() {
            int n = DexBuffer.this.data[this.position] & 0xFF | (DexBuffer.this.data[this.position + 1] & 0xFF) << 8 | (DexBuffer.this.data[this.position + 2] & 0xFF) << 16 | (DexBuffer.this.data[this.position + 3] & 0xFF) << 24;
            this.position += 4;
            return n;
        }

        public short readShort() {
            int n = DexBuffer.this.data[this.position] & 0xFF | (DexBuffer.this.data[this.position + 1] & 0xFF) << 8;
            this.position += 2;
            return (short)n;
        }

        public int readUnsignedShort() {
            return this.readShort() & 0xFFFF;
        }

        public byte readByte() {
            return (byte)(DexBuffer.this.data[this.position++] & 0xFF);
        }

        public byte[] readByteArray(int n) {
            byte[] byArray = Arrays.copyOfRange(DexBuffer.this.data, this.position, this.position + n);
            this.position += n;
            return byArray;
        }

        public short[] readShortArray(int n) {
            short[] sArray = new short[n];
            for (int i = 0; i < n; ++i) {
                sArray[i] = this.readShort();
            }
            return sArray;
        }

        public int readUleb128() {
            return Leb128Utils.readUnsignedLeb128(this);
        }

        public int readUleb128p1() {
            return Leb128Utils.readUnsignedLeb128(this) - 1;
        }

        public int readSleb128() {
            return Leb128Utils.readSignedLeb128(this);
        }

        public TypeList readTypeList() {
            int n = this.readInt();
            short[] sArray = new short[n];
            for (int i = 0; i < n; ++i) {
                sArray[i] = this.readShort();
            }
            this.alignToFourBytes();
            return new TypeList(DexBuffer.this, sArray);
        }

        public String readString() {
            int n = this.readInt();
            int n2 = this.position;
            this.position = n;
            try {
                int n3 = this.readUleb128();
                String string = Mutf8.decode(this, new char[n3]);
                if (string.length() != n3) {
                    throw new DexException("Declared length " + n3 + " doesn't match decoded length of " + string.length());
                }
                String string2 = string;
                return string2;
            }
            catch (UTFDataFormatException uTFDataFormatException) {
                throw new DexException(uTFDataFormatException);
            }
            finally {
                this.position = n2;
            }
        }

        public FieldId readFieldId() {
            int n = this.readUnsignedShort();
            int n2 = this.readUnsignedShort();
            int n3 = this.readInt();
            return new FieldId(DexBuffer.this, n, n2, n3);
        }

        public MethodId readMethodId() {
            int n = this.readUnsignedShort();
            int n2 = this.readUnsignedShort();
            int n3 = this.readInt();
            return new MethodId(DexBuffer.this, n, n2, n3);
        }

        public ProtoId readProtoId() {
            int n = this.readInt();
            int n2 = this.readInt();
            int n3 = this.readInt();
            return new ProtoId(DexBuffer.this, n, n2, n3);
        }

        public ClassDef readClassDef() {
            int n = this.getPosition();
            int n2 = this.readInt();
            int n3 = this.readInt();
            int n4 = this.readInt();
            int n5 = this.readInt();
            int n6 = this.readInt();
            int n7 = this.readInt();
            int n8 = this.readInt();
            int n9 = this.readInt();
            return new ClassDef(DexBuffer.this, n, n2, n3, n4, n5, n6, n7, n8, n9);
        }

        private Code readCode() {
            Code.Try[] tryArray;
            Code.CatchHandler[] catchHandlerArray;
            int n = this.readUnsignedShort();
            int n2 = this.readUnsignedShort();
            int n3 = this.readUnsignedShort();
            int n4 = this.readUnsignedShort();
            int n5 = this.readInt();
            int n6 = this.readInt();
            short[] sArray = this.readShortArray(n6);
            if (n4 > 0) {
                if (sArray.length % 2 == 1) {
                    this.readShort();
                }
                Section section = DexBuffer.this.open(this.position);
                this.skip(n4 * 8);
                catchHandlerArray = this.readCatchHandlers();
                tryArray = section.readTries(n4, catchHandlerArray);
            } else {
                tryArray = new Code.Try[]{};
                catchHandlerArray = new Code.CatchHandler[]{};
            }
            return new Code(n, n2, n3, n5, sArray, tryArray, catchHandlerArray);
        }

        private Code.CatchHandler[] readCatchHandlers() {
            int n = this.position;
            int n2 = this.readUleb128();
            Code.CatchHandler[] catchHandlerArray = new Code.CatchHandler[n2];
            for (int i = 0; i < n2; ++i) {
                int n3 = this.position - n;
                catchHandlerArray[i] = this.readCatchHandler(n3);
            }
            return catchHandlerArray;
        }

        private Code.Try[] readTries(int n, Code.CatchHandler[] catchHandlerArray) {
            Code.Try[] tryArray = new Code.Try[n];
            for (int i = 0; i < n; ++i) {
                int n2 = this.readInt();
                int n3 = this.readUnsignedShort();
                int n4 = this.readUnsignedShort();
                int n5 = this.findCatchHandlerIndex(catchHandlerArray, n4);
                tryArray[i] = new Code.Try(n2, n3, n5);
            }
            return tryArray;
        }

        private int findCatchHandlerIndex(Code.CatchHandler[] catchHandlerArray, int n) {
            for (int i = 0; i < catchHandlerArray.length; ++i) {
                Code.CatchHandler catchHandler = catchHandlerArray[i];
                if (catchHandler.getOffset() != n) continue;
                return i;
            }
            throw new IllegalArgumentException();
        }

        private Code.CatchHandler readCatchHandler(int n) {
            int n2;
            int n3 = this.readSleb128();
            int n4 = Math.abs(n3);
            int[] nArray = new int[n4];
            int[] nArray2 = new int[n4];
            for (n2 = 0; n2 < n4; ++n2) {
                nArray[n2] = this.readUleb128();
                nArray2[n2] = this.readUleb128();
            }
            n2 = n3 <= 0 ? this.readUleb128() : -1;
            return new Code.CatchHandler(nArray, nArray2, n2, n);
        }

        private ClassData readClassData() {
            int n = this.readUleb128();
            int n2 = this.readUleb128();
            int n3 = this.readUleb128();
            int n4 = this.readUleb128();
            ClassData.Field[] fieldArray = this.readFields(n);
            ClassData.Field[] fieldArray2 = this.readFields(n2);
            ClassData.Method[] methodArray = this.readMethods(n3);
            ClassData.Method[] methodArray2 = this.readMethods(n4);
            return new ClassData(fieldArray, fieldArray2, methodArray, methodArray2);
        }

        private ClassData.Field[] readFields(int n) {
            ClassData.Field[] fieldArray = new ClassData.Field[n];
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                int n3 = this.readUleb128();
                fieldArray[i] = new ClassData.Field(n2 += this.readUleb128(), n3);
            }
            return fieldArray;
        }

        private ClassData.Method[] readMethods(int n) {
            ClassData.Method[] methodArray = new ClassData.Method[n];
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                int n3 = this.readUleb128();
                int n4 = this.readUleb128();
                methodArray[i] = new ClassData.Method(n2 += this.readUleb128(), n3, n4);
            }
            return methodArray;
        }

        public Annotation readAnnotation() {
            byte by = this.readByte();
            int n = this.readUleb128();
            int n2 = this.readUleb128();
            int[] nArray = new int[n2];
            EncodedValue[] encodedValueArray = new EncodedValue[n2];
            for (int i = 0; i < n2; ++i) {
                nArray[i] = this.readUleb128();
                encodedValueArray[i] = this.readEncodedValue();
            }
            return new Annotation(DexBuffer.this, by, n, nArray, encodedValueArray);
        }

        public EncodedValue readEncodedValue() {
            int n = this.position;
            new EncodedValueReader(this).readValue();
            int n2 = this.position;
            return new EncodedValue(Arrays.copyOfRange(DexBuffer.this.data, n, n2));
        }

        public EncodedValue readEncodedArray() {
            int n = this.position;
            new EncodedValueReader(this).readArray();
            int n2 = this.position;
            return new EncodedValue(Arrays.copyOfRange(DexBuffer.this.data, n, n2));
        }

        private void ensureCapacity(int n) {
            if (this.position + n > this.limit) {
                throw new DexException("Section limit " + this.limit + " exceeded by " + this.name);
            }
        }

        public void skip(int n) {
            if (n < 0) {
                throw new IllegalArgumentException();
            }
            this.ensureCapacity(n);
            this.position += n;
        }

        public void alignToFourBytes() {
            int n = this.position;
            this.position = DexBuffer.fourByteAlign(this.position);
            for (int i = n; i < this.position; ++i) {
                ((DexBuffer)DexBuffer.this).data[i] = 0;
            }
        }

        public void assertFourByteAligned() {
            if ((this.position & 3) != 0) {
                throw new IllegalStateException("Not four byte aligned!");
            }
        }

        public void write(byte[] byArray) {
            this.ensureCapacity(byArray.length);
            System.arraycopy(byArray, 0, DexBuffer.this.data, this.position, byArray.length);
            this.position += byArray.length;
        }

        public void writeByte(int n) {
            this.ensureCapacity(1);
            ((DexBuffer)DexBuffer.this).data[this.position++] = (byte)n;
        }

        public void writeShort(short s) {
            this.ensureCapacity(2);
            ((DexBuffer)DexBuffer.this).data[this.position] = (byte)s;
            ((DexBuffer)DexBuffer.this).data[this.position + 1] = (byte)(s >>> 8);
            this.position += 2;
        }

        public void writeUnsignedShort(int n) {
            short s = (short)n;
            if (n != (s & 0xFFFF)) {
                throw new IllegalArgumentException("Expected an unsigned short: " + n);
            }
            this.writeShort(s);
        }

        public void write(short[] sArray) {
            for (short s : sArray) {
                this.writeShort(s);
            }
        }

        public void writeInt(int n) {
            this.ensureCapacity(4);
            ((DexBuffer)DexBuffer.this).data[this.position] = (byte)n;
            ((DexBuffer)DexBuffer.this).data[this.position + 1] = (byte)(n >>> 8);
            ((DexBuffer)DexBuffer.this).data[this.position + 2] = (byte)(n >>> 16);
            ((DexBuffer)DexBuffer.this).data[this.position + 3] = (byte)(n >>> 24);
            this.position += 4;
        }

        public void writeUleb128(int n) {
            try {
                Leb128Utils.writeUnsignedLeb128(this, n);
                this.ensureCapacity(0);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw new DexException("Section limit " + this.limit + " exceeded by " + this.name);
            }
        }

        public void writeUleb128p1(int n) {
            this.writeUleb128(n + 1);
        }

        public void writeSleb128(int n) {
            try {
                Leb128Utils.writeSignedLeb128(this, n);
                this.ensureCapacity(0);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw new DexException("Section limit " + this.limit + " exceeded by " + this.name);
            }
        }

        public void writeStringData(String string) {
            try {
                int n = string.length();
                this.writeUleb128(n);
                this.write(Mutf8.encode(string));
                this.writeByte(0);
            }
            catch (UTFDataFormatException uTFDataFormatException) {
                throw new AssertionError();
            }
        }

        public void writeTypeList(TypeList typeList) {
            short[] sArray = typeList.getTypes();
            this.writeInt(sArray.length);
            for (short s : sArray) {
                this.writeShort(s);
            }
            this.alignToFourBytes();
        }

        public int remaining() {
            return this.limit - this.position;
        }

        public int used() {
            return this.position - this.initialPosition;
        }
    }
}

