/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.io;

import com.android.dx.io.EncodedValue;
import com.android.dx.util.ByteInput;
import com.android.dx.util.Leb128Utils;

public class EncodedValueReader {
    public static final int ENCODED_BYTE = 0;
    public static final int ENCODED_SHORT = 2;
    public static final int ENCODED_CHAR = 3;
    public static final int ENCODED_INT = 4;
    public static final int ENCODED_LONG = 6;
    public static final int ENCODED_FLOAT = 16;
    public static final int ENCODED_DOUBLE = 17;
    public static final int ENCODED_STRING = 23;
    public static final int ENCODED_TYPE = 24;
    public static final int ENCODED_FIELD = 25;
    public static final int ENCODED_ENUM = 27;
    public static final int ENCODED_METHOD = 26;
    public static final int ENCODED_ARRAY = 28;
    public static final int ENCODED_ANNOTATION = 29;
    public static final int ENCODED_NULL = 30;
    public static final int ENCODED_BOOLEAN = 31;
    protected final ByteInput in;

    public EncodedValueReader(ByteInput byteInput) {
        this.in = byteInput;
    }

    public EncodedValueReader(EncodedValue encodedValue) {
        this(encodedValue.asByteInput());
    }

    public final void readArray() {
        int n = Leb128Utils.readUnsignedLeb128(this.in);
        this.visitArray(n);
        for (int i = 0; i < n; ++i) {
            this.readValue();
        }
    }

    public final void readAnnotation() {
        int n = Leb128Utils.readUnsignedLeb128(this.in);
        int n2 = Leb128Utils.readUnsignedLeb128(this.in);
        this.visitAnnotation(n, n2);
        for (int i = 0; i < n2; ++i) {
            this.visitAnnotationName(Leb128Utils.readUnsignedLeb128(this.in));
            this.readValue();
        }
    }

    public final void readValue() {
        int n = this.in.readByte() & 0xFF;
        int n2 = n & 0x1F;
        int n3 = (n & 0xE0) >> 5;
        int n4 = n3 + 1;
        switch (n2) {
            case 0: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 16: 
            case 17: {
                this.visitPrimitive(n, n2, n3, n4);
                break;
            }
            case 23: {
                this.visitString(n2, this.readIndex(this.in, n4));
                break;
            }
            case 24: {
                this.visitType(n2, this.readIndex(this.in, n4));
                break;
            }
            case 25: 
            case 27: {
                this.visitField(n2, this.readIndex(this.in, n4));
                break;
            }
            case 26: {
                this.visitMethod(n2, this.readIndex(this.in, n4));
                break;
            }
            case 28: {
                this.visitArrayValue(n);
                this.readArray();
                break;
            }
            case 29: {
                this.visitAnnotationValue(n);
                this.readAnnotation();
                break;
            }
            case 30: {
                this.visitEncodedNull(n);
                break;
            }
            case 31: {
                this.visitEncodedBoolean(n);
            }
        }
    }

    protected void visitArray(int n) {
    }

    protected void visitAnnotation(int n, int n2) {
    }

    protected void visitAnnotationName(int n) {
    }

    protected void visitPrimitive(int n, int n2, int n3, int n4) {
        for (int i = 0; i < n4; ++i) {
            this.in.readByte();
        }
    }

    protected void visitString(int n, int n2) {
    }

    protected void visitType(int n, int n2) {
    }

    protected void visitField(int n, int n2) {
    }

    protected void visitMethod(int n, int n2) {
    }

    protected void visitArrayValue(int n) {
    }

    protected void visitAnnotationValue(int n) {
    }

    protected void visitEncodedBoolean(int n) {
    }

    protected void visitEncodedNull(int n) {
    }

    private int readIndex(ByteInput byteInput, int n) {
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            n2 += (byteInput.readByte() & 0xFF) << n3;
            n3 += 8;
        }
        return n2;
    }
}

