/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.rop.code;

import com.android.dx.rop.code.RegisterSpec;
import com.android.dx.rop.type.Type;
import com.android.dx.rop.type.TypeList;
import com.android.dx.util.FixedSizeList;
import java.util.BitSet;

public final class RegisterSpecList
extends FixedSizeList
implements TypeList {
    public static final RegisterSpecList EMPTY = new RegisterSpecList(0);

    public static RegisterSpecList make(RegisterSpec registerSpec) {
        RegisterSpecList registerSpecList = new RegisterSpecList(1);
        registerSpecList.set(0, registerSpec);
        return registerSpecList;
    }

    public static RegisterSpecList make(RegisterSpec registerSpec, RegisterSpec registerSpec2) {
        RegisterSpecList registerSpecList = new RegisterSpecList(2);
        registerSpecList.set(0, registerSpec);
        registerSpecList.set(1, registerSpec2);
        return registerSpecList;
    }

    public static RegisterSpecList make(RegisterSpec registerSpec, RegisterSpec registerSpec2, RegisterSpec registerSpec3) {
        RegisterSpecList registerSpecList = new RegisterSpecList(3);
        registerSpecList.set(0, registerSpec);
        registerSpecList.set(1, registerSpec2);
        registerSpecList.set(2, registerSpec3);
        return registerSpecList;
    }

    public static RegisterSpecList make(RegisterSpec registerSpec, RegisterSpec registerSpec2, RegisterSpec registerSpec3, RegisterSpec registerSpec4) {
        RegisterSpecList registerSpecList = new RegisterSpecList(4);
        registerSpecList.set(0, registerSpec);
        registerSpecList.set(1, registerSpec2);
        registerSpecList.set(2, registerSpec3);
        registerSpecList.set(3, registerSpec4);
        return registerSpecList;
    }

    public RegisterSpecList(int n) {
        super(n);
    }

    public Type getType(int n) {
        return this.get(n).getType().getType();
    }

    public int getWordCount() {
        int n = this.size();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            n2 += this.getType(i).getCategory();
        }
        return n2;
    }

    public TypeList withAddedType(Type type) {
        throw new UnsupportedOperationException("unsupported");
    }

    public RegisterSpec get(int n) {
        return (RegisterSpec)this.get0(n);
    }

    public RegisterSpec specForRegister(int n) {
        int n2 = this.size();
        for (int i = 0; i < n2; ++i) {
            RegisterSpec registerSpec = this.get(i);
            if (registerSpec.getReg() != n) continue;
            return registerSpec;
        }
        return null;
    }

    public int indexOfRegister(int n) {
        int n2 = this.size();
        for (int i = 0; i < n2; ++i) {
            RegisterSpec registerSpec = this.get(i);
            if (registerSpec.getReg() != n) continue;
            return i;
        }
        return -1;
    }

    public void set(int n, RegisterSpec registerSpec) {
        this.set0(n, registerSpec);
    }

    public int getRegistersSize() {
        int n = this.size();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            int n3;
            RegisterSpec registerSpec = (RegisterSpec)this.get0(i);
            if (registerSpec == null || (n3 = registerSpec.getNextReg()) <= n2) continue;
            n2 = n3;
        }
        return n2;
    }

    public RegisterSpecList withFirst(RegisterSpec registerSpec) {
        int n = this.size();
        RegisterSpecList registerSpecList = new RegisterSpecList(n + 1);
        for (int i = 0; i < n; ++i) {
            registerSpecList.set0(i + 1, this.get0(i));
        }
        registerSpecList.set0(0, registerSpec);
        if (this.isImmutable()) {
            registerSpecList.setImmutable();
        }
        return registerSpecList;
    }

    public RegisterSpecList withoutFirst() {
        int n = this.size() - 1;
        if (n == 0) {
            return EMPTY;
        }
        RegisterSpecList registerSpecList = new RegisterSpecList(n);
        for (int i = 0; i < n; ++i) {
            registerSpecList.set0(i, this.get0(i + 1));
        }
        if (this.isImmutable()) {
            registerSpecList.setImmutable();
        }
        return registerSpecList;
    }

    public RegisterSpecList withoutLast() {
        int n = this.size() - 1;
        if (n == 0) {
            return EMPTY;
        }
        RegisterSpecList registerSpecList = new RegisterSpecList(n);
        for (int i = 0; i < n; ++i) {
            registerSpecList.set0(i, this.get0(i));
        }
        if (this.isImmutable()) {
            registerSpecList.setImmutable();
        }
        return registerSpecList;
    }

    public RegisterSpecList subset(BitSet bitSet) {
        int n = this.size() - bitSet.cardinality();
        if (n == 0) {
            return EMPTY;
        }
        RegisterSpecList registerSpecList = new RegisterSpecList(n);
        int n2 = 0;
        for (int i = 0; i < this.size(); ++i) {
            if (bitSet.get(i)) continue;
            registerSpecList.set0(n2, this.get0(i));
            ++n2;
        }
        if (this.isImmutable()) {
            registerSpecList.setImmutable();
        }
        return registerSpecList;
    }

    public RegisterSpecList withOffset(int n) {
        int n2 = this.size();
        if (n2 == 0) {
            return this;
        }
        RegisterSpecList registerSpecList = new RegisterSpecList(n2);
        for (int i = 0; i < n2; ++i) {
            RegisterSpec registerSpec = (RegisterSpec)this.get0(i);
            if (registerSpec == null) continue;
            registerSpecList.set0(i, registerSpec.withOffset(n));
        }
        if (this.isImmutable()) {
            registerSpecList.setImmutable();
        }
        return registerSpecList;
    }

    public RegisterSpecList withExpandedRegisters(int n, boolean bl, BitSet bitSet) {
        int n2 = this.size();
        if (n2 == 0) {
            return this;
        }
        RegisterSpecList registerSpecList = new RegisterSpecList(n2);
        for (int i = 0; i < n2; ++i) {
            boolean bl2;
            RegisterSpec registerSpec = (RegisterSpec)this.get0(i);
            boolean bl3 = bitSet == null ? true : (bl2 = !bitSet.get(i));
            if (bl2) {
                registerSpecList.set0(i, registerSpec.withReg(n));
                if (!bl) {
                    n += registerSpec.getCategory();
                }
            } else {
                registerSpecList.set0(i, registerSpec);
            }
            if (!bl) continue;
            bl = false;
        }
        if (this.isImmutable()) {
            registerSpecList.setImmutable();
        }
        return registerSpecList;
    }
}

