/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.rop.code;

import com.android.dx.rop.code.BasicBlock;
import com.android.dx.rop.code.BasicBlockList;
import com.android.dx.util.Hex;
import com.android.dx.util.IntList;
import com.android.dx.util.MutabilityControl;

public final class RopMethod {
    private final BasicBlockList blocks;
    private final int firstLabel;
    private IntList[] predecessors;
    private IntList exitPredecessors;

    public RopMethod(BasicBlockList basicBlockList, int n) {
        if (basicBlockList == null) {
            throw new NullPointerException("blocks == null");
        }
        if (n < 0) {
            throw new IllegalArgumentException("firstLabel < 0");
        }
        this.blocks = basicBlockList;
        this.firstLabel = n;
        this.predecessors = null;
        this.exitPredecessors = null;
    }

    public BasicBlockList getBlocks() {
        return this.blocks;
    }

    public int getFirstLabel() {
        return this.firstLabel;
    }

    public IntList labelToPredecessors(int n) {
        IntList intList;
        if (this.exitPredecessors == null) {
            this.calcPredecessors();
        }
        if ((intList = this.predecessors[n]) == null) {
            throw new RuntimeException("no such block: " + Hex.u2(n));
        }
        return intList;
    }

    public IntList getExitPredecessors() {
        if (this.exitPredecessors == null) {
            this.calcPredecessors();
        }
        return this.exitPredecessors;
    }

    public RopMethod withRegisterOffset(int n) {
        RopMethod ropMethod = new RopMethod(this.blocks.withRegisterOffset(n), this.firstLabel);
        if (this.exitPredecessors != null) {
            ropMethod.exitPredecessors = this.exitPredecessors;
            ropMethod.predecessors = this.predecessors;
        }
        return ropMethod;
    }

    private void calcPredecessors() {
        Object object;
        int n;
        int n2 = this.blocks.getMaxLabel();
        IntList[] intListArray = new IntList[n2];
        IntList intList = new IntList(10);
        int n3 = this.blocks.size();
        for (n = 0; n < n3; ++n) {
            object = this.blocks.get(n);
            int n4 = ((BasicBlock)object).getLabel();
            IntList intList2 = ((BasicBlock)object).getSuccessors();
            int n5 = intList2.size();
            if (n5 == 0) {
                intList.add(n4);
                continue;
            }
            for (int i = 0; i < n5; ++i) {
                int n6 = intList2.get(i);
                IntList intList3 = intListArray[n6];
                if (intList3 == null) {
                    intListArray[n6] = intList3 = new IntList(10);
                }
                intList3.add(n4);
            }
        }
        for (n = 0; n < n2; ++n) {
            object = intListArray[n];
            if (object == null) continue;
            ((IntList)object).sort();
            ((MutabilityControl)object).setImmutable();
        }
        intList.sort();
        intList.setImmutable();
        if (intListArray[this.firstLabel] == null) {
            intListArray[this.firstLabel] = IntList.EMPTY;
        }
        this.predecessors = intListArray;
        this.exitPredecessors = intList;
    }
}

