/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.rop.code;

import com.android.dx.rop.code.Insn;
import com.android.dx.rop.code.RegisterSpec;
import com.android.dx.rop.code.RegisterSpecList;
import com.android.dx.rop.code.Rop;
import com.android.dx.rop.code.SourcePosition;
import com.android.dx.rop.type.Type;
import com.android.dx.rop.type.TypeList;

public final class ThrowingInsn
extends Insn {
    private final TypeList catches;

    public static String toCatchString(TypeList typeList) {
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append("catch");
        int n = typeList.size();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(" ");
            stringBuffer.append(typeList.getType(i).toHuman());
        }
        return stringBuffer.toString();
    }

    public ThrowingInsn(Rop rop, SourcePosition sourcePosition, RegisterSpecList registerSpecList, TypeList typeList) {
        super(rop, sourcePosition, null, registerSpecList);
        if (rop.getBranchingness() != 6) {
            throw new IllegalArgumentException("bogus branchingness");
        }
        if (typeList == null) {
            throw new NullPointerException("catches == null");
        }
        this.catches = typeList;
    }

    public String getInlineString() {
        return ThrowingInsn.toCatchString(this.catches);
    }

    public TypeList getCatches() {
        return this.catches;
    }

    public void accept(Insn.Visitor visitor) {
        visitor.visitThrowingInsn(this);
    }

    public Insn withAddedCatch(Type type) {
        return new ThrowingInsn(this.getOpcode(), this.getPosition(), this.getSources(), this.catches.withAddedType(type));
    }

    public Insn withRegisterOffset(int n) {
        return new ThrowingInsn(this.getOpcode(), this.getPosition(), this.getSources().withOffset(n), this.catches);
    }

    public Insn withNewRegisters(RegisterSpec registerSpec, RegisterSpecList registerSpecList) {
        return new ThrowingInsn(this.getOpcode(), this.getPosition(), registerSpecList, this.catches);
    }
}

