/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.ssa;

import com.android.dx.ssa.Dominators;
import com.android.dx.ssa.SetFactory;
import com.android.dx.ssa.SsaBasicBlock;
import com.android.dx.ssa.SsaMethod;
import com.android.dx.util.IntSet;
import java.util.ArrayList;
import java.util.BitSet;

public class DomFront {
    private static boolean DEBUG = false;
    private final SsaMethod meth;
    private final ArrayList<SsaBasicBlock> nodes;
    private final DomInfo[] domInfos;

    public DomFront(SsaMethod ssaMethod) {
        this.meth = ssaMethod;
        this.nodes = ssaMethod.getBlocks();
        int n = this.nodes.size();
        this.domInfos = new DomInfo[n];
        for (int i = 0; i < n; ++i) {
            this.domInfos[i] = new DomInfo();
        }
    }

    public DomInfo[] run() {
        int n;
        int n2 = this.nodes.size();
        if (DEBUG) {
            for (int i = 0; i < n2; ++i) {
                SsaBasicBlock ssaBasicBlock = this.nodes.get(i);
                System.out.println("pred[" + i + "]: " + ssaBasicBlock.getPredecessors());
            }
        }
        Dominators dominators = Dominators.make(this.meth, this.domInfos, false);
        if (DEBUG) {
            for (int i = 0; i < n2; ++i) {
                DomInfo domInfo = this.domInfos[i];
                System.out.println("idom[" + i + "]: " + domInfo.idom);
            }
        }
        this.buildDomTree();
        if (DEBUG) {
            this.debugPrintDomChildren();
        }
        for (n = 0; n < n2; ++n) {
            this.domInfos[n].dominanceFrontiers = SetFactory.makeDomFrontSet(n2);
        }
        this.calcDomFronts();
        if (DEBUG) {
            for (n = 0; n < n2; ++n) {
                System.out.println("df[" + n + "]: " + this.domInfos[n].dominanceFrontiers);
            }
        }
        return this.domInfos;
    }

    private void debugPrintDomChildren() {
        int n = this.nodes.size();
        for (int i = 0; i < n; ++i) {
            SsaBasicBlock ssaBasicBlock = this.nodes.get(i);
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append('{');
            boolean bl = false;
            for (SsaBasicBlock ssaBasicBlock2 : ssaBasicBlock.getDomChildren()) {
                if (bl) {
                    stringBuffer.append(',');
                }
                stringBuffer.append(ssaBasicBlock2);
                bl = true;
            }
            stringBuffer.append('}');
            System.out.println("domChildren[" + ssaBasicBlock + "]: " + stringBuffer);
        }
    }

    private void buildDomTree() {
        int n = this.nodes.size();
        for (int i = 0; i < n; ++i) {
            DomInfo domInfo = this.domInfos[i];
            if (domInfo.idom == -1) continue;
            SsaBasicBlock ssaBasicBlock = this.nodes.get(domInfo.idom);
            ssaBasicBlock.addDomChild(this.nodes.get(i));
        }
    }

    private void calcDomFronts() {
        int n = this.nodes.size();
        for (int i = 0; i < n; ++i) {
            SsaBasicBlock ssaBasicBlock = this.nodes.get(i);
            DomInfo domInfo = this.domInfos[i];
            BitSet bitSet = ssaBasicBlock.getPredecessors();
            if (bitSet.cardinality() <= 1) continue;
            int n2 = bitSet.nextSetBit(0);
            while (n2 >= 0) {
                int n3 = n2;
                while (n3 != domInfo.idom && n3 != -1) {
                    DomInfo domInfo2 = this.domInfos[n3];
                    if (domInfo2.dominanceFrontiers.has(i)) break;
                    domInfo2.dominanceFrontiers.add(i);
                    n3 = domInfo2.idom;
                }
                n2 = bitSet.nextSetBit(n2 + 1);
            }
        }
    }

    public static class DomInfo {
        public IntSet dominanceFrontiers;
        public int idom = -1;
    }
}

