/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.ssa.back;

import com.android.dx.rop.code.CstInsn;
import com.android.dx.rop.code.LocalItem;
import com.android.dx.rop.code.RegisterSpec;
import com.android.dx.rop.code.RegisterSpecList;
import com.android.dx.rop.code.Rop;
import com.android.dx.rop.cst.CstInteger;
import com.android.dx.ssa.InterferenceRegisterMapper;
import com.android.dx.ssa.NormalSsaInsn;
import com.android.dx.ssa.Optimizer;
import com.android.dx.ssa.PhiInsn;
import com.android.dx.ssa.RegisterMapper;
import com.android.dx.ssa.SsaBasicBlock;
import com.android.dx.ssa.SsaInsn;
import com.android.dx.ssa.SsaMethod;
import com.android.dx.ssa.back.InterferenceGraph;
import com.android.dx.ssa.back.RegisterAllocator;
import com.android.dx.util.IntIterator;
import com.android.dx.util.IntSet;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Map;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FirstFitLocalCombiningAllocator
extends RegisterAllocator {
    private static final boolean DEBUG = false;
    private final Map<LocalItem, ArrayList<RegisterSpec>> localVariables;
    private final ArrayList<NormalSsaInsn> moveResultPseudoInsns;
    private final ArrayList<NormalSsaInsn> invokeRangeInsns;
    private final ArrayList<PhiInsn> phiInsns;
    private final BitSet ssaRegsMapped;
    private final InterferenceRegisterMapper mapper;
    private final int paramRangeEnd;
    private final BitSet reservedRopRegs;
    private final BitSet usedRopRegs;
    private final boolean minimizeRegisters;

    public FirstFitLocalCombiningAllocator(SsaMethod ssaMethod, InterferenceGraph interferenceGraph, boolean bl) {
        super(ssaMethod, interferenceGraph);
        this.ssaRegsMapped = new BitSet(ssaMethod.getRegCount());
        this.mapper = new InterferenceRegisterMapper(interferenceGraph, ssaMethod.getRegCount());
        this.minimizeRegisters = bl;
        this.paramRangeEnd = ssaMethod.getParamWidth();
        this.reservedRopRegs = new BitSet(this.paramRangeEnd * 2);
        this.reservedRopRegs.set(0, this.paramRangeEnd);
        this.usedRopRegs = new BitSet(this.paramRangeEnd * 2);
        this.localVariables = new TreeMap<LocalItem, ArrayList<RegisterSpec>>();
        this.moveResultPseudoInsns = new ArrayList();
        this.invokeRangeInsns = new ArrayList();
        this.phiInsns = new ArrayList();
    }

    @Override
    public boolean wantsParamsMovedHigh() {
        return true;
    }

    @Override
    public RegisterMapper allocateRegisters() {
        this.analyzeInstructions();
        this.handleLocalAssociatedParams();
        this.handleUnassociatedParameters();
        this.handleInvokeRangeInsns();
        this.handleLocalAssociatedOther();
        this.handleCheckCastResults();
        this.handlePhiInsns();
        this.handleNormalUnassociated();
        return this.mapper;
    }

    private void printLocalVars() {
        System.out.println("Printing local vars");
        for (Map.Entry<LocalItem, ArrayList<RegisterSpec>> entry : this.localVariables.entrySet()) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append('{');
            stringBuilder.append(' ');
            for (RegisterSpec registerSpec : entry.getValue()) {
                stringBuilder.append('v');
                stringBuilder.append(registerSpec.getReg());
                stringBuilder.append(' ');
            }
            stringBuilder.append('}');
            System.out.printf("Local: %s Registers: %s\n", entry.getKey(), stringBuilder);
        }
    }

    private void handleLocalAssociatedParams() {
        for (ArrayList<RegisterSpec> arrayList : this.localVariables.values()) {
            int n = arrayList.size();
            int n2 = -1;
            int n3 = 0;
            for (int i = 0; i < n; ++i) {
                RegisterSpec registerSpec = arrayList.get(i);
                int n4 = registerSpec.getReg();
                n2 = this.getParameterIndexForReg(n4);
                if (n2 < 0) continue;
                n3 = registerSpec.getCategory();
                this.addMapping(registerSpec, n2);
                break;
            }
            if (n2 < 0) continue;
            this.tryMapRegs(arrayList, n2, n3, true);
        }
    }

    private int getParameterIndexForReg(int n) {
        SsaInsn ssaInsn = this.ssaMeth.getDefinitionForRegister(n);
        if (ssaInsn == null) {
            return -1;
        }
        Rop rop = ssaInsn.getOpcode();
        if (rop != null && rop.getOpcode() == 3) {
            CstInsn cstInsn = (CstInsn)ssaInsn.getOriginalRopInsn();
            return ((CstInteger)cstInsn.getConstant()).getValue();
        }
        return -1;
    }

    private void handleLocalAssociatedOther() {
        for (ArrayList<RegisterSpec> arrayList : this.localVariables.values()) {
            int n = this.paramRangeEnd;
            boolean bl = false;
            do {
                int n2 = 1;
                int n3 = arrayList.size();
                for (int i = 0; i < n3; ++i) {
                    RegisterSpec registerSpec = arrayList.get(i);
                    int n4 = registerSpec.getCategory();
                    if (this.ssaRegsMapped.get(registerSpec.getReg()) || n4 <= n2) continue;
                    n2 = n4;
                }
                if (this.canMapRegs(arrayList, n = this.findRopRegForLocal(n, n2))) {
                    bl = this.tryMapRegs(arrayList, n, n2, true);
                }
                ++n;
            } while (!bl);
        }
    }

    private boolean tryMapRegs(ArrayList<RegisterSpec> arrayList, int n, int n2, boolean bl) {
        boolean bl2 = false;
        for (RegisterSpec registerSpec : arrayList) {
            if (this.ssaRegsMapped.get(registerSpec.getReg())) continue;
            boolean bl3 = this.tryMapReg(registerSpec, n, n2);
            boolean bl4 = bl2 = !bl3 || bl2;
            if (!bl3 || !bl) continue;
            this.markReserved(n, registerSpec.getCategory());
        }
        return !bl2;
    }

    private boolean tryMapReg(RegisterSpec registerSpec, int n, int n2) {
        if (registerSpec.getCategory() <= n2 && !this.ssaRegsMapped.get(registerSpec.getReg()) && this.canMapReg(registerSpec, n)) {
            this.addMapping(registerSpec, n);
            return true;
        }
        return false;
    }

    private void markReserved(int n, int n2) {
        this.reservedRopRegs.set(n, n + n2, true);
    }

    private boolean rangeContainsReserved(int n, int n2) {
        for (int i = n; i < n + n2; ++i) {
            if (!this.reservedRopRegs.get(i)) continue;
            return true;
        }
        return false;
    }

    private boolean isThisPointerReg(int n) {
        return n == 0 && !this.ssaMeth.isStatic();
    }

    private int findNextUnreservedRopReg(int n, int n2) {
        int n3 = this.reservedRopRegs.nextClearBit(n);
        while (true) {
            int n4;
            for (n4 = 1; n4 < n2 && !this.reservedRopRegs.get(n3 + n4); ++n4) {
            }
            if (n4 == n2) {
                return n3;
            }
            n3 = this.reservedRopRegs.nextClearBit(n3 + n4);
        }
    }

    private int findRopRegForLocal(int n, int n2) {
        int n3 = this.usedRopRegs.nextClearBit(n);
        while (true) {
            int n4;
            for (n4 = 1; n4 < n2 && !this.usedRopRegs.get(n3 + n4); ++n4) {
            }
            if (n4 == n2) {
                return n3;
            }
            n3 = this.usedRopRegs.nextClearBit(n3 + n4);
        }
    }

    private void handleUnassociatedParameters() {
        int n = this.ssaMeth.getRegCount();
        for (int i = 0; i < n; ++i) {
            if (this.ssaRegsMapped.get(i)) continue;
            int n2 = this.getParameterIndexForReg(i);
            RegisterSpec registerSpec = this.getDefinitionSpecForSsaReg(i);
            if (n2 < 0) continue;
            this.addMapping(registerSpec, n2);
        }
    }

    private void handleInvokeRangeInsns() {
        for (NormalSsaInsn normalSsaInsn : this.invokeRangeInsns) {
            this.adjustAndMapSourceRangeRange(normalSsaInsn);
        }
    }

    private void handleCheckCastResults() {
        for (NormalSsaInsn normalSsaInsn : this.moveResultPseudoInsns) {
            int n;
            int n2;
            boolean bl;
            SsaBasicBlock ssaBasicBlock;
            ArrayList<SsaInsn> arrayList;
            SsaInsn ssaInsn;
            RegisterSpec registerSpec = normalSsaInsn.getResult();
            int n3 = registerSpec.getReg();
            BitSet bitSet = normalSsaInsn.getBlock().getPredecessors();
            if (bitSet.cardinality() != 1 || (ssaInsn = (arrayList = (ssaBasicBlock = this.ssaMeth.getBlocks().get(bitSet.nextSetBit(0))).getInsns()).get(arrayList.size() - 1)).getOpcode().getOpcode() != 43) continue;
            RegisterSpec registerSpec2 = ssaInsn.getSources().get(0);
            int n4 = registerSpec2.getReg();
            int n5 = registerSpec2.getCategory();
            boolean bl2 = this.ssaRegsMapped.get(n3);
            if (bl2 & !(bl = this.ssaRegsMapped.get(n4))) {
                n2 = this.mapper.oldToNew(n3);
                bl = this.tryMapReg(registerSpec2, n2, n5);
            }
            if (bl & !bl2) {
                n2 = this.mapper.oldToNew(n4);
                bl2 = this.tryMapReg(registerSpec, n2, n5);
            }
            if (!bl2 || !bl) {
                n2 = this.findNextUnreservedRopReg(this.paramRangeEnd, n5);
                ArrayList<RegisterSpec> arrayList2 = new ArrayList<RegisterSpec>(2);
                arrayList2.add(registerSpec);
                arrayList2.add(registerSpec2);
                while (!this.tryMapRegs(arrayList2, n2, n5, false)) {
                    n2 = this.findNextUnreservedRopReg(n2 + 1, n5);
                }
            }
            int n6 = n2 = ssaInsn.getOriginalRopInsn().getCatches().size() != 0 ? 1 : 0;
            int n7 = this.mapper.oldToNew(n3);
            if (n7 == (n = this.mapper.oldToNew(n4)) || n2 != 0) continue;
            ((NormalSsaInsn)ssaInsn).changeOneSource(0, this.insertMoveBefore(ssaInsn, registerSpec2));
            this.addMapping(ssaInsn.getSources().get(0), n7);
        }
    }

    private void handlePhiInsns() {
        for (PhiInsn phiInsn : this.phiInsns) {
            this.processPhiInsn(phiInsn);
        }
    }

    private void handleNormalUnassociated() {
        int n = this.ssaMeth.getRegCount();
        for (int i = 0; i < n; ++i) {
            RegisterSpec registerSpec;
            if (this.ssaRegsMapped.get(i) || (registerSpec = this.getDefinitionSpecForSsaReg(i)) == null) continue;
            int n2 = registerSpec.getCategory();
            int n3 = this.findNextUnreservedRopReg(this.paramRangeEnd, n2);
            while (!this.canMapReg(registerSpec, n3)) {
                n3 = this.findNextUnreservedRopReg(n3 + 1, n2);
            }
            this.addMapping(registerSpec, n3);
        }
    }

    private boolean canMapRegs(ArrayList<RegisterSpec> arrayList, int n) {
        for (RegisterSpec registerSpec : arrayList) {
            if (this.ssaRegsMapped.get(registerSpec.getReg()) || this.canMapReg(registerSpec, n)) continue;
            return false;
        }
        return true;
    }

    private boolean canMapReg(RegisterSpec registerSpec, int n) {
        int n2 = registerSpec.getCategory();
        return !this.spansParamRange(n, n2) && !this.mapper.interferes(registerSpec, n);
    }

    private boolean spansParamRange(int n, int n2) {
        return n < this.paramRangeEnd && n + n2 > this.paramRangeEnd;
    }

    private void analyzeInstructions() {
        this.ssaMeth.forEachInsn(new SsaInsn.Visitor(){

            public void visitMoveInsn(NormalSsaInsn normalSsaInsn) {
                this.processInsn(normalSsaInsn);
            }

            public void visitPhiInsn(PhiInsn phiInsn) {
                this.processInsn(phiInsn);
            }

            public void visitNonMoveInsn(NormalSsaInsn normalSsaInsn) {
                this.processInsn(normalSsaInsn);
            }

            private void processInsn(SsaInsn ssaInsn) {
                RegisterSpec registerSpec = ssaInsn.getLocalAssignment();
                if (registerSpec != null) {
                    LocalItem localItem = registerSpec.getLocalItem();
                    ArrayList<RegisterSpec> arrayList = (ArrayList<RegisterSpec>)FirstFitLocalCombiningAllocator.this.localVariables.get(localItem);
                    if (arrayList == null) {
                        arrayList = new ArrayList<RegisterSpec>();
                        FirstFitLocalCombiningAllocator.this.localVariables.put(localItem, arrayList);
                    }
                    arrayList.add(registerSpec);
                }
                if (ssaInsn instanceof NormalSsaInsn) {
                    if (ssaInsn.getOpcode().getOpcode() == 56) {
                        FirstFitLocalCombiningAllocator.this.moveResultPseudoInsns.add((NormalSsaInsn)ssaInsn);
                    } else if (Optimizer.getAdvice().requiresSourcesInOrder(ssaInsn.getOriginalRopInsn().getOpcode(), ssaInsn.getSources())) {
                        FirstFitLocalCombiningAllocator.this.invokeRangeInsns.add((NormalSsaInsn)ssaInsn);
                    }
                } else if (ssaInsn instanceof PhiInsn) {
                    FirstFitLocalCombiningAllocator.this.phiInsns.add((PhiInsn)ssaInsn);
                }
            }
        });
    }

    private void addMapping(RegisterSpec registerSpec, int n) {
        int n2 = registerSpec.getReg();
        if (this.ssaRegsMapped.get(n2) || !this.canMapReg(registerSpec, n)) {
            throw new RuntimeException("attempt to add invalid register mapping");
        }
        int n3 = registerSpec.getCategory();
        this.mapper.addMapping(registerSpec.getReg(), n, n3);
        this.ssaRegsMapped.set(n2);
        this.usedRopRegs.set(n, n + n3);
    }

    private void adjustAndMapSourceRangeRange(NormalSsaInsn normalSsaInsn) {
        int n = this.findRangeAndAdjust(normalSsaInsn);
        RegisterSpecList registerSpecList = normalSsaInsn.getSources();
        int n2 = registerSpecList.size();
        int n3 = n;
        for (int i = 0; i < n2; ++i) {
            RegisterSpec registerSpec = registerSpecList.get(i);
            int n4 = registerSpec.getReg();
            int n5 = registerSpec.getCategory();
            int n6 = n3;
            n3 += n5;
            if (this.ssaRegsMapped.get(n4)) continue;
            LocalItem localItem = this.getLocalItemForReg(n4);
            this.addMapping(registerSpec, n6);
            if (localItem == null) continue;
            this.markReserved(n6, n5);
            ArrayList<RegisterSpec> arrayList = this.localVariables.get(localItem);
            int n7 = arrayList.size();
            for (int j = 0; j < n7; ++j) {
                RegisterSpec registerSpec2 = arrayList.get(j);
                int n8 = registerSpec2.getReg();
                if (-1 != registerSpecList.indexOfRegister(n8)) continue;
                this.tryMapReg(registerSpec2, n6, n5);
            }
        }
    }

    private int findRangeAndAdjust(NormalSsaInsn normalSsaInsn) {
        int n;
        int n2;
        int n3;
        RegisterSpecList registerSpecList = normalSsaInsn.getSources();
        int n4 = registerSpecList.size();
        int[] nArray = new int[n4];
        int n5 = 0;
        for (n3 = 0; n3 < n4; ++n3) {
            nArray[n3] = n2 = registerSpecList.get(n3).getCategory();
            n5 += nArray[n3];
        }
        n3 = Integer.MIN_VALUE;
        n2 = -1;
        BitSet bitSet = null;
        int n6 = 0;
        for (n = 0; n < n4; ++n) {
            BitSet bitSet2;
            int n7;
            int n8;
            int n9 = registerSpecList.get(n).getReg();
            if (n != 0) {
                n6 -= nArray[n - 1];
            }
            if (!this.ssaRegsMapped.get(n9) || (n8 = this.mapper.oldToNew(n9) + n6) < 0 || this.spansParamRange(n8, n5) || (n7 = this.fitPlanForRange(n8, normalSsaInsn, nArray, bitSet2 = new BitSet(n4))) < 0) continue;
            int n10 = n7 - bitSet2.cardinality();
            if (n10 > n3) {
                n3 = n10;
                n2 = n8;
                bitSet = bitSet2;
            }
            if (n7 == n5) break;
        }
        if (n2 == -1) {
            bitSet = new BitSet(n4);
            n2 = this.findAnyFittingRange(normalSsaInsn, n5, nArray, bitSet);
        }
        n = bitSet.nextSetBit(0);
        while (n >= 0) {
            normalSsaInsn.changeOneSource(n, this.insertMoveBefore(normalSsaInsn, registerSpecList.get(n)));
            n = bitSet.nextSetBit(n + 1);
        }
        return n2;
    }

    private int findAnyFittingRange(NormalSsaInsn normalSsaInsn, int n, int[] nArray, BitSet bitSet) {
        int n2;
        int n3 = this.paramRangeEnd;
        while ((n2 = this.fitPlanForRange(n3 = this.findNextUnreservedRopReg(n3, n), normalSsaInsn, nArray, bitSet)) < 0) {
            ++n3;
            bitSet.clear();
        }
        return n3;
    }

    private int fitPlanForRange(int n, NormalSsaInsn normalSsaInsn, int[] nArray, BitSet bitSet) {
        RegisterSpecList registerSpecList = normalSsaInsn.getSources();
        int n2 = registerSpecList.size();
        int n3 = 0;
        IntSet intSet = normalSsaInsn.getBlock().getLiveOutRegs();
        RegisterSpecList registerSpecList2 = this.ssaSetToSpecs(intSet);
        BitSet bitSet2 = new BitSet(this.ssaMeth.getRegCount());
        for (int i = 0; i < n2; ++i) {
            RegisterSpec registerSpec = registerSpecList.get(i);
            int n4 = registerSpec.getReg();
            int n5 = nArray[i];
            if (i != 0) {
                n += nArray[i - 1];
            }
            if (this.ssaRegsMapped.get(n4) && this.mapper.oldToNew(n4) == n) {
                n3 += n5;
            } else {
                if (this.rangeContainsReserved(n, n5)) {
                    n3 = -1;
                    break;
                }
                if (!this.ssaRegsMapped.get(n4) && this.canMapReg(registerSpec, n) && !bitSet2.get(n4)) {
                    n3 += n5;
                } else if (!this.mapper.areAnyPinned(registerSpecList2, n, n5) && !this.mapper.areAnyPinned(registerSpecList, n, n5)) {
                    bitSet.set(i);
                } else {
                    n3 = -1;
                    break;
                }
            }
            bitSet2.set(n4);
        }
        return n3;
    }

    RegisterSpecList ssaSetToSpecs(IntSet intSet) {
        RegisterSpecList registerSpecList = new RegisterSpecList(intSet.elements());
        IntIterator intIterator = intSet.iterator();
        int n = 0;
        while (intIterator.hasNext()) {
            registerSpecList.set(n++, this.getDefinitionSpecForSsaReg(intIterator.next()));
        }
        return registerSpecList;
    }

    private LocalItem getLocalItemForReg(int n) {
        for (Map.Entry<LocalItem, ArrayList<RegisterSpec>> entry : this.localVariables.entrySet()) {
            for (RegisterSpec registerSpec : entry.getValue()) {
                if (registerSpec.getReg() != n) continue;
                return entry.getKey();
            }
        }
        return null;
    }

    private void processPhiInsn(PhiInsn phiInsn) {
        int n;
        RegisterSpec registerSpec = phiInsn.getResult();
        int n2 = registerSpec.getReg();
        int n3 = registerSpec.getCategory();
        RegisterSpecList registerSpecList = phiInsn.getSources();
        int n4 = registerSpecList.size();
        ArrayList<RegisterSpec> arrayList = new ArrayList<RegisterSpec>();
        Multiset multiset = new Multiset(n4 + 1);
        if (this.ssaRegsMapped.get(n2)) {
            multiset.add(this.mapper.oldToNew(n2));
        } else {
            arrayList.add(registerSpec);
        }
        for (n = 0; n < n4; ++n) {
            RegisterSpec registerSpec2 = registerSpecList.get(n);
            SsaInsn ssaInsn = this.ssaMeth.getDefinitionForRegister(registerSpec2.getReg());
            RegisterSpec registerSpec3 = ssaInsn.getResult();
            int n5 = registerSpec3.getReg();
            if (this.ssaRegsMapped.get(n5)) {
                multiset.add(this.mapper.oldToNew(n5));
                continue;
            }
            arrayList.add(registerSpec3);
        }
        for (n = 0; n < multiset.getSize(); ++n) {
            int n6 = multiset.getAndRemoveHighestCount();
            this.tryMapRegs(arrayList, n6, n3, false);
        }
        n = this.findNextUnreservedRopReg(this.paramRangeEnd, n3);
        while (!this.tryMapRegs(arrayList, n, n3, false)) {
            n = this.findNextUnreservedRopReg(n + 1, n3);
        }
    }

    private static class Multiset {
        private final int[] reg;
        private final int[] count;
        private int size;

        public Multiset(int n) {
            this.reg = new int[n];
            this.count = new int[n];
            this.size = 0;
        }

        public void add(int n) {
            for (int i = 0; i < this.size; ++i) {
                if (this.reg[i] != n) continue;
                int n2 = i;
                this.count[n2] = this.count[n2] + 1;
                return;
            }
            this.reg[this.size] = n;
            this.count[this.size] = 1;
            ++this.size;
        }

        public int getAndRemoveHighestCount() {
            int n = -1;
            int n2 = -1;
            int n3 = 0;
            for (int i = 0; i < this.size; ++i) {
                if (n3 >= this.count[i]) continue;
                n = i;
                n2 = this.reg[i];
                n3 = this.count[i];
            }
            this.count[n] = 0;
            return n2;
        }

        public int getSize() {
            return this.size;
        }
    }
}

