/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.cf.direct;

import com.android.dx.cf.direct.AttributeFactory;
import com.android.dx.cf.direct.AttributeListParser;
import com.android.dx.cf.direct.DirectClassFile;
import com.android.dx.cf.iface.AttributeList;
import com.android.dx.cf.iface.Member;
import com.android.dx.cf.iface.ParseException;
import com.android.dx.cf.iface.ParseObserver;
import com.android.dx.cf.iface.StdAttributeList;
import com.android.dx.rop.cst.ConstantPool;
import com.android.dx.rop.cst.CstNat;
import com.android.dx.rop.cst.CstString;
import com.android.dx.rop.cst.CstType;
import com.android.dx.util.ByteArray;
import com.android.dx.util.Hex;

abstract class MemberListParser {
    private final DirectClassFile cf;
    private final CstType definer;
    private final int offset;
    private final AttributeFactory attributeFactory;
    private int endOffset;
    private ParseObserver observer;

    public MemberListParser(DirectClassFile directClassFile, CstType cstType, int n, AttributeFactory attributeFactory) {
        if (directClassFile == null) {
            throw new NullPointerException("cf == null");
        }
        if (n < 0) {
            throw new IllegalArgumentException("offset < 0");
        }
        if (attributeFactory == null) {
            throw new NullPointerException("attributeFactory == null");
        }
        this.cf = directClassFile;
        this.definer = cstType;
        this.offset = n;
        this.attributeFactory = attributeFactory;
        this.endOffset = -1;
    }

    public int getEndOffset() {
        this.parseIfNecessary();
        return this.endOffset;
    }

    public final void setObserver(ParseObserver parseObserver) {
        this.observer = parseObserver;
    }

    protected final void parseIfNecessary() {
        if (this.endOffset < 0) {
            this.parse();
        }
    }

    protected final int getCount() {
        ByteArray byteArray = this.cf.getBytes();
        return byteArray.getUnsignedShort(this.offset);
    }

    protected final CstType getDefiner() {
        return this.definer;
    }

    protected abstract String humanName();

    protected abstract String humanAccessFlags(int var1);

    protected abstract int getAttributeContext();

    protected abstract Member set(int var1, int var2, CstNat var3, AttributeList var4);

    private void parse() {
        int n = this.getAttributeContext();
        int n2 = this.getCount();
        int n3 = this.offset + 2;
        ByteArray byteArray = this.cf.getBytes();
        ConstantPool constantPool = this.cf.getConstantPool();
        if (this.observer != null) {
            this.observer.parsed(byteArray, this.offset, 2, this.humanName() + "s_count: " + Hex.u2(n2));
        }
        for (int i = 0; i < n2; ++i) {
            try {
                int n4 = byteArray.getUnsignedShort(n3);
                int n5 = byteArray.getUnsignedShort(n3 + 2);
                int n6 = byteArray.getUnsignedShort(n3 + 4);
                CstString cstString = (CstString)constantPool.get(n5);
                CstString cstString2 = (CstString)constantPool.get(n6);
                if (this.observer != null) {
                    this.observer.startParsingMember(byteArray, n3, cstString.getString(), cstString2.getString());
                    this.observer.parsed(byteArray, n3, 0, "\n" + this.humanName() + "s[" + i + "]:\n");
                    this.observer.changeIndent(1);
                    this.observer.parsed(byteArray, n3, 2, "access_flags: " + this.humanAccessFlags(n4));
                    this.observer.parsed(byteArray, n3 + 2, 2, "name: " + cstString.toHuman());
                    this.observer.parsed(byteArray, n3 + 4, 2, "descriptor: " + cstString2.toHuman());
                }
                AttributeListParser attributeListParser = new AttributeListParser(this.cf, n, n3 += 6, this.attributeFactory);
                attributeListParser.setObserver(this.observer);
                n3 = attributeListParser.getEndOffset();
                StdAttributeList stdAttributeList = attributeListParser.getList();
                stdAttributeList.setImmutable();
                CstNat cstNat = new CstNat(cstString, cstString2);
                Member member = this.set(i, n4, cstNat, stdAttributeList);
                if (this.observer == null) continue;
                this.observer.changeIndent(-1);
                this.observer.parsed(byteArray, n3, 0, "end " + this.humanName() + "s[" + i + "]\n");
                this.observer.endParsingMember(byteArray, n3, cstString.getString(), cstString2.getString(), member);
                continue;
            }
            catch (ParseException parseException) {
                parseException.addContext("...while parsing " + this.humanName() + "s[" + i + "]");
                throw parseException;
            }
            catch (RuntimeException runtimeException) {
                ParseException parseException = new ParseException(runtimeException);
                parseException.addContext("...while parsing " + this.humanName() + "s[" + i + "]");
                throw parseException;
            }
        }
        this.endOffset = n3;
    }
}

