/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.command.findusages;

import com.android.dx.io.ClassData;
import com.android.dx.io.ClassDef;
import com.android.dx.io.CodeReader;
import com.android.dx.io.DexBuffer;
import com.android.dx.io.FieldId;
import com.android.dx.io.MethodId;
import com.android.dx.io.OpcodeInfo;
import com.android.dx.io.instructions.DecodedInstruction;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FindUsages {
    private final DexBuffer dex;
    private final Set<Integer> methodIds;
    private final Set<Integer> fieldIds;
    private final CodeReader codeReader = new CodeReader();
    private final PrintWriter out;
    private ClassDef currentClass;
    private ClassData.Method currentMethod;

    public FindUsages(final DexBuffer dexBuffer, String string, String string2, final PrintWriter printWriter) {
        this.dex = dexBuffer;
        this.out = printWriter;
        HashSet<Integer> hashSet = new HashSet<Integer>();
        HashSet<Integer> hashSet2 = new HashSet<Integer>();
        Pattern pattern = Pattern.compile(string);
        Pattern pattern2 = Pattern.compile(string2);
        List<String> list = dexBuffer.strings();
        for (int i = 0; i < list.size(); ++i) {
            String string3 = list.get(i);
            if (pattern.matcher(string3).matches()) {
                hashSet.add(i);
            }
            if (!pattern2.matcher(string3).matches()) continue;
            hashSet2.add(i);
        }
        if (hashSet.isEmpty() || hashSet2.isEmpty()) {
            this.fieldIds = null;
            this.methodIds = null;
            return;
        }
        this.methodIds = new HashSet<Integer>();
        this.fieldIds = new HashSet<Integer>();
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            int n2 = Collections.binarySearch(dexBuffer.typeIds(), n);
            if (n2 < 0) continue;
            this.methodIds.addAll(this.getMethodIds(dexBuffer, hashSet2, n2));
            this.fieldIds.addAll(this.getFieldIds(dexBuffer, hashSet2, n2));
        }
        this.codeReader.setFieldVisitor(new CodeReader.Visitor(){

            public void visit(DecodedInstruction[] decodedInstructionArray, DecodedInstruction decodedInstruction) {
                int n = decodedInstruction.getIndex();
                if (FindUsages.this.fieldIds.contains(n)) {
                    printWriter.println(FindUsages.this.location() + ": field reference " + dexBuffer.fieldIds().get(n) + " (" + OpcodeInfo.getName(decodedInstruction.getOpcode()) + ")");
                }
            }
        });
        this.codeReader.setMethodVisitor(new CodeReader.Visitor(){

            public void visit(DecodedInstruction[] decodedInstructionArray, DecodedInstruction decodedInstruction) {
                int n = decodedInstruction.getIndex();
                if (FindUsages.this.methodIds.contains(n)) {
                    printWriter.println(FindUsages.this.location() + ": method reference " + dexBuffer.methodIds().get(n) + " (" + OpcodeInfo.getName(decodedInstruction.getOpcode()) + ")");
                }
            }
        });
    }

    private String location() {
        String string = this.dex.typeNames().get(this.currentClass.getTypeIndex());
        if (this.currentMethod != null) {
            MethodId methodId = this.dex.methodIds().get(this.currentMethod.getMethodIndex());
            return string + "." + this.dex.strings().get(methodId.getNameIndex());
        }
        return string;
    }

    public void findUsages() {
        if (this.fieldIds == null || this.methodIds == null) {
            return;
        }
        Iterator<ClassDef> iterator = this.dex.classDefs().iterator();
        while (iterator.hasNext()) {
            int n;
            ClassDef classDef;
            this.currentClass = classDef = iterator.next();
            this.currentMethod = null;
            if (classDef.getClassDataOffset() == 0) continue;
            ClassData classData = this.dex.readClassData(classDef);
            for (ClassData.Field field : classData.allFields()) {
                n = field.getFieldIndex();
                if (!this.fieldIds.contains(n)) continue;
                this.out.println(this.location() + " field declared " + this.dex.fieldIds().get(n));
            }
            Object[] objectArray = classData.allMethods();
            int n2 = objectArray.length;
            for (int i = 0; i < n2; ++i) {
                Object object;
                this.currentMethod = object = objectArray[i];
                n = ((ClassData.Method)object).getMethodIndex();
                if (this.methodIds.contains(n)) {
                    this.out.println(this.location() + " method declared " + this.dex.methodIds().get(n));
                }
                if (((ClassData.Method)object).getCodeOffset() == 0) continue;
                this.codeReader.visitAll(this.dex.readCode((ClassData.Method)object).getInstructions());
            }
        }
        this.currentClass = null;
        this.currentMethod = null;
    }

    private Set<Integer> getFieldIds(DexBuffer dexBuffer, Set<Integer> set, int n) {
        HashSet<Integer> hashSet = new HashSet<Integer>();
        int n2 = 0;
        for (FieldId fieldId : dexBuffer.fieldIds()) {
            if (set.contains(fieldId.getNameIndex()) && n == fieldId.getDeclaringClassIndex()) {
                hashSet.add(n2);
            }
            ++n2;
        }
        return hashSet;
    }

    private Set<Integer> getMethodIds(DexBuffer dexBuffer, Set<Integer> set, int n) {
        Set<Integer> set2 = this.findAssignableTypes(dexBuffer, n);
        HashSet<Integer> hashSet = new HashSet<Integer>();
        int n2 = 0;
        for (MethodId methodId : dexBuffer.methodIds()) {
            if (set.contains(methodId.getNameIndex()) && set2.contains(methodId.getDeclaringClassIndex())) {
                hashSet.add(n2);
            }
            ++n2;
        }
        return hashSet;
    }

    private Set<Integer> findAssignableTypes(DexBuffer dexBuffer, int n) {
        HashSet<Integer> hashSet = new HashSet<Integer>();
        hashSet.add(n);
        block0: for (ClassDef classDef : dexBuffer.classDefs()) {
            if (hashSet.contains(classDef.getSupertypeIndex())) {
                hashSet.add(classDef.getTypeIndex());
                continue;
            }
            for (short s : classDef.getInterfaces()) {
                if (!hashSet.contains(s)) continue;
                hashSet.add(classDef.getTypeIndex());
                continue block0;
            }
        }
        return hashSet;
    }
}

