/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.dex.code;

import com.android.dx.dex.code.BlockAddresses;
import com.android.dx.dex.code.CatchBuilder;
import com.android.dx.dex.code.CatchHandlerList;
import com.android.dx.dex.code.CatchTable;
import com.android.dx.dex.code.CodeAddress;
import com.android.dx.rop.code.BasicBlock;
import com.android.dx.rop.code.BasicBlockList;
import com.android.dx.rop.code.RopMethod;
import com.android.dx.rop.cst.CstType;
import com.android.dx.rop.type.Type;
import com.android.dx.rop.type.TypeList;
import com.android.dx.util.IntList;
import com.android.dx.util.MutabilityControl;
import java.util.ArrayList;
import java.util.HashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StdCatchBuilder
implements CatchBuilder {
    private static final int MAX_CATCH_RANGE = 65535;
    private final RopMethod method;
    private final int[] order;
    private final BlockAddresses addresses;

    public StdCatchBuilder(RopMethod ropMethod, int[] nArray, BlockAddresses blockAddresses) {
        if (ropMethod == null) {
            throw new NullPointerException("method == null");
        }
        if (nArray == null) {
            throw new NullPointerException("order == null");
        }
        if (blockAddresses == null) {
            throw new NullPointerException("addresses == null");
        }
        this.method = ropMethod;
        this.order = nArray;
        this.addresses = blockAddresses;
    }

    @Override
    public CatchTable build() {
        return StdCatchBuilder.build(this.method, this.order, this.addresses);
    }

    @Override
    public boolean hasAnyCatches() {
        BasicBlockList basicBlockList = this.method.getBlocks();
        int n = basicBlockList.size();
        for (int i = 0; i < n; ++i) {
            BasicBlock basicBlock = basicBlockList.get(i);
            TypeList typeList = basicBlock.getLastInsn().getCatches();
            if (typeList.size() == 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public HashSet<Type> getCatchTypes() {
        HashSet<Type> hashSet = new HashSet<Type>(20);
        BasicBlockList basicBlockList = this.method.getBlocks();
        int n = basicBlockList.size();
        for (int i = 0; i < n; ++i) {
            BasicBlock basicBlock = basicBlockList.get(i);
            TypeList typeList = basicBlock.getLastInsn().getCatches();
            int n2 = typeList.size();
            for (int j = 0; j < n2; ++j) {
                hashSet.add(typeList.getType(j));
            }
        }
        return hashSet;
    }

    public static CatchTable build(RopMethod ropMethod, int[] nArray, BlockAddresses blockAddresses) {
        Object object;
        int n;
        int n2 = nArray.length;
        BasicBlockList basicBlockList = ropMethod.getBlocks();
        ArrayList<CatchTable.Entry> arrayList = new ArrayList<CatchTable.Entry>(n2);
        CatchHandlerList catchHandlerList = CatchHandlerList.EMPTY;
        Object object2 = null;
        Object object3 = null;
        for (n = 0; n < n2; ++n) {
            object = basicBlockList.labelToBlock(nArray[n]);
            if (!((BasicBlock)object).canThrow()) continue;
            CatchHandlerList catchHandlerList2 = StdCatchBuilder.handlersFor((BasicBlock)object, blockAddresses);
            if (catchHandlerList.size() == 0) {
                object2 = object;
                object3 = object;
                catchHandlerList = catchHandlerList2;
                continue;
            }
            if (catchHandlerList.equals(catchHandlerList2) && StdCatchBuilder.rangeIsValid((BasicBlock)object2, (BasicBlock)object, blockAddresses)) {
                object3 = object;
                continue;
            }
            if (catchHandlerList.size() != 0) {
                CatchTable.Entry entry = StdCatchBuilder.makeEntry((BasicBlock)object2, (BasicBlock)object3, catchHandlerList, blockAddresses);
                arrayList.add(entry);
            }
            object2 = object;
            object3 = object;
            catchHandlerList = catchHandlerList2;
        }
        if (catchHandlerList.size() != 0) {
            CatchTable.Entry entry = StdCatchBuilder.makeEntry(object2, object3, catchHandlerList, blockAddresses);
            arrayList.add(entry);
        }
        if ((n = arrayList.size()) == 0) {
            return CatchTable.EMPTY;
        }
        object = new CatchTable(n);
        for (int i = 0; i < n; ++i) {
            ((CatchTable)object).set(i, (CatchTable.Entry)arrayList.get(i));
        }
        ((MutabilityControl)object).setImmutable();
        return object;
    }

    private static CatchHandlerList handlersFor(BasicBlock basicBlock, BlockAddresses blockAddresses) {
        IntList intList = basicBlock.getSuccessors();
        int n = intList.size();
        int n2 = basicBlock.getPrimarySuccessor();
        TypeList typeList = basicBlock.getLastInsn().getCatches();
        int n3 = typeList.size();
        if (n3 == 0) {
            return CatchHandlerList.EMPTY;
        }
        if (n2 == -1 && n != n3 || n2 != -1 && (n != n3 + 1 || n2 != intList.get(n3))) {
            throw new RuntimeException("shouldn't happen: weird successors list");
        }
        for (int i = 0; i < n3; ++i) {
            Type type = typeList.getType(i);
            if (!type.equals(Type.OBJECT)) continue;
            n3 = i + 1;
            break;
        }
        CatchHandlerList catchHandlerList = new CatchHandlerList(n3);
        for (int i = 0; i < n3; ++i) {
            CstType cstType = new CstType(typeList.getType(i));
            CodeAddress codeAddress = blockAddresses.getStart(intList.get(i));
            catchHandlerList.set(i, cstType, codeAddress.getAddress());
        }
        catchHandlerList.setImmutable();
        return catchHandlerList;
    }

    private static CatchTable.Entry makeEntry(BasicBlock basicBlock, BasicBlock basicBlock2, CatchHandlerList catchHandlerList, BlockAddresses blockAddresses) {
        CodeAddress codeAddress = blockAddresses.getLast(basicBlock);
        CodeAddress codeAddress2 = blockAddresses.getEnd(basicBlock2);
        return new CatchTable.Entry(codeAddress.getAddress(), codeAddress2.getAddress(), catchHandlerList);
    }

    private static boolean rangeIsValid(BasicBlock basicBlock, BasicBlock basicBlock2, BlockAddresses blockAddresses) {
        if (basicBlock == null) {
            throw new NullPointerException("start == null");
        }
        if (basicBlock2 == null) {
            throw new NullPointerException("end == null");
        }
        int n = blockAddresses.getLast(basicBlock).getAddress();
        int n2 = blockAddresses.getEnd(basicBlock2).getAddress();
        return n2 - n <= 65535;
    }
}

