/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.dex.file;

import com.android.dx.dex.file.DexFile;
import com.android.dx.dex.file.IndexedItem;
import com.android.dx.dex.file.ItemType;
import com.android.dx.dex.file.Section;
import com.android.dx.rop.cst.CstString;
import com.android.dx.util.AnnotatedOutput;
import com.android.dx.util.Hex;

public final class HeaderItem
extends IndexedItem {
    public ItemType itemType() {
        return ItemType.TYPE_HEADER_ITEM;
    }

    public int writeSize() {
        return 112;
    }

    public void addContents(DexFile dexFile) {
    }

    public void writeTo(DexFile dexFile, AnnotatedOutput annotatedOutput) {
        int n = dexFile.getMap().getFileOffset();
        Section section = dexFile.getFirstDataSection();
        Section section2 = dexFile.getLastDataSection();
        int n2 = section.getFileOffset();
        int n3 = section2.getFileOffset() + section2.writeSize() - n2;
        String string = dexFile.getDexOptions().getMagic();
        if (annotatedOutput.annotates()) {
            annotatedOutput.annotate(8, "magic: " + new CstString(string).toQuoted());
            annotatedOutput.annotate(4, "checksum");
            annotatedOutput.annotate(20, "signature");
            annotatedOutput.annotate(4, "file_size:       " + Hex.u4(dexFile.getFileSize()));
            annotatedOutput.annotate(4, "header_size:     " + Hex.u4(112));
            annotatedOutput.annotate(4, "endian_tag:      " + Hex.u4(305419896));
            annotatedOutput.annotate(4, "link_size:       0");
            annotatedOutput.annotate(4, "link_off:        0");
            annotatedOutput.annotate(4, "map_off:         " + Hex.u4(n));
        }
        for (int i = 0; i < 8; ++i) {
            annotatedOutput.writeByte(string.charAt(i));
        }
        annotatedOutput.writeZeroes(24);
        annotatedOutput.writeInt(dexFile.getFileSize());
        annotatedOutput.writeInt(112);
        annotatedOutput.writeInt(305419896);
        annotatedOutput.writeZeroes(8);
        annotatedOutput.writeInt(n);
        dexFile.getStringIds().writeHeaderPart(annotatedOutput);
        dexFile.getTypeIds().writeHeaderPart(annotatedOutput);
        dexFile.getProtoIds().writeHeaderPart(annotatedOutput);
        dexFile.getFieldIds().writeHeaderPart(annotatedOutput);
        dexFile.getMethodIds().writeHeaderPart(annotatedOutput);
        dexFile.getClassDefs().writeHeaderPart(annotatedOutput);
        if (annotatedOutput.annotates()) {
            annotatedOutput.annotate(4, "data_size:       " + Hex.u4(n3));
            annotatedOutput.annotate(4, "data_off:        " + Hex.u4(n2));
        }
        annotatedOutput.writeInt(n3);
        annotatedOutput.writeInt(n2);
    }
}

