/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.rop.code;

import com.android.dx.rop.code.RegisterSpec;
import com.android.dx.rop.code.RegisterSpecList;
import com.android.dx.rop.code.Rop;
import com.android.dx.rop.code.TranslationAdvice;
import com.android.dx.rop.cst.CstInteger;
import com.android.dx.rop.type.Type;

public final class DexTranslationAdvice
implements TranslationAdvice {
    public static final DexTranslationAdvice THE_ONE = new DexTranslationAdvice();
    public static final DexTranslationAdvice NO_SOURCES_IN_ORDER = new DexTranslationAdvice(true);
    private static final int MIN_INVOKE_IN_ORDER = 6;
    private final boolean disableSourcesInOrder;

    private DexTranslationAdvice() {
        this.disableSourcesInOrder = false;
    }

    private DexTranslationAdvice(boolean bl) {
        this.disableSourcesInOrder = bl;
    }

    public boolean hasConstantOperation(Rop rop, RegisterSpec registerSpec, RegisterSpec registerSpec2) {
        if (registerSpec.getType() != Type.INT) {
            return false;
        }
        if (!(registerSpec2.getTypeBearer() instanceof CstInteger)) {
            if (registerSpec.getTypeBearer() instanceof CstInteger && rop.getOpcode() == 15) {
                CstInteger cstInteger = (CstInteger)registerSpec.getTypeBearer();
                return cstInteger.fitsIn16Bits();
            }
            return false;
        }
        CstInteger cstInteger = (CstInteger)registerSpec2.getTypeBearer();
        switch (rop.getOpcode()) {
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: {
                return cstInteger.fitsIn16Bits();
            }
            case 23: 
            case 24: 
            case 25: {
                return cstInteger.fitsIn8Bits();
            }
            case 15: {
                CstInteger cstInteger2 = CstInteger.make(-cstInteger.getValue());
                return cstInteger2.fitsIn16Bits();
            }
        }
        return false;
    }

    public boolean requiresSourcesInOrder(Rop rop, RegisterSpecList registerSpecList) {
        return !this.disableSourcesInOrder && rop.isCallLike() && this.totalRopWidth(registerSpecList) >= 6;
    }

    private int totalRopWidth(RegisterSpecList registerSpecList) {
        int n = registerSpecList.size();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            n2 += registerSpecList.get(i).getCategory();
        }
        return n2;
    }

    public int getMaxOptimalRegisterCount() {
        return 16;
    }
}

