/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.rop.cst;

import com.android.dx.rop.cst.Constant;
import com.android.dx.rop.cst.TypedConstant;
import com.android.dx.rop.type.Type;
import com.android.dx.util.ByteArray;
import com.android.dx.util.Hex;

public final class CstString
extends TypedConstant {
    public static final CstString EMPTY_STRING = new CstString("");
    private final String string;
    private final ByteArray bytes;

    public static byte[] stringToUtf8Bytes(String string) {
        int n = string.length();
        byte[] byArray = new byte[n * 3];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c != '\u0000' && c < '\u0080') {
                byArray[n2] = (byte)c;
                ++n2;
                continue;
            }
            if (c < '\u0800') {
                byArray[n2] = (byte)(c >> 6 & 0x1F | 0xC0);
                byArray[n2 + 1] = (byte)(c & 0x3F | 0x80);
                n2 += 2;
                continue;
            }
            byArray[n2] = (byte)(c >> 12 & 0xF | 0xE0);
            byArray[n2 + 1] = (byte)(c >> 6 & 0x3F | 0x80);
            byArray[n2 + 2] = (byte)(c & 0x3F | 0x80);
            n2 += 3;
        }
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, 0, byArray2, 0, n2);
        return byArray2;
    }

    public static String utf8BytesToString(ByteArray byteArray) {
        int n = byteArray.size();
        char[] cArray = new char[n];
        int n2 = 0;
        int n3 = 0;
        while (n > 0) {
            char c;
            int n4 = byteArray.getUnsignedByte(n3);
            switch (n4 >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    --n;
                    if (n4 == 0) {
                        return CstString.throwBadUtf8(n4, n3);
                    }
                    c = (char)n4;
                    ++n3;
                    break;
                }
                case 12: 
                case 13: {
                    if ((n -= 2) < 0) {
                        return CstString.throwBadUtf8(n4, n3);
                    }
                    int n5 = byteArray.getUnsignedByte(n3 + 1);
                    if ((n5 & 0xC0) != 128) {
                        return CstString.throwBadUtf8(n5, n3 + 1);
                    }
                    int n6 = (n4 & 0x1F) << 6 | n5 & 0x3F;
                    if (n6 != 0 && n6 < 128) {
                        return CstString.throwBadUtf8(n5, n3 + 1);
                    }
                    c = (char)n6;
                    n3 += 2;
                    break;
                }
                case 14: {
                    if ((n -= 3) < 0) {
                        return CstString.throwBadUtf8(n4, n3);
                    }
                    int n5 = byteArray.getUnsignedByte(n3 + 1);
                    if ((n5 & 0xC0) != 128) {
                        return CstString.throwBadUtf8(n5, n3 + 1);
                    }
                    int n6 = byteArray.getUnsignedByte(n3 + 2);
                    if ((n5 & 0xC0) != 128) {
                        return CstString.throwBadUtf8(n6, n3 + 2);
                    }
                    int n7 = (n4 & 0xF) << 12 | (n5 & 0x3F) << 6 | n6 & 0x3F;
                    if (n7 < 2048) {
                        return CstString.throwBadUtf8(n6, n3 + 2);
                    }
                    c = (char)n7;
                    n3 += 3;
                    break;
                }
                default: {
                    return CstString.throwBadUtf8(n4, n3);
                }
            }
            cArray[n2] = c;
            ++n2;
        }
        return new String(cArray, 0, n2);
    }

    private static String throwBadUtf8(int n, int n2) {
        throw new IllegalArgumentException("bad utf-8 byte " + Hex.u1(n) + " at offset " + Hex.u4(n2));
    }

    public CstString(String string) {
        if (string == null) {
            throw new NullPointerException("string == null");
        }
        this.string = string.intern();
        this.bytes = new ByteArray(CstString.stringToUtf8Bytes(string));
    }

    public CstString(ByteArray byteArray) {
        if (byteArray == null) {
            throw new NullPointerException("bytes == null");
        }
        this.bytes = byteArray;
        this.string = CstString.utf8BytesToString(byteArray).intern();
    }

    public boolean equals(Object object) {
        if (!(object instanceof CstString)) {
            return false;
        }
        return this.string.equals(((CstString)object).string);
    }

    public int hashCode() {
        return this.string.hashCode();
    }

    protected int compareTo0(Constant constant) {
        return this.string.compareTo(((CstString)constant).string);
    }

    public String toString() {
        return "string{\"" + this.toHuman() + "\"}";
    }

    public String typeName() {
        return "utf8";
    }

    public boolean isCategory2() {
        return false;
    }

    public String toHuman() {
        int n = this.string.length();
        StringBuilder stringBuilder = new StringBuilder(n * 3 / 2);
        block5: for (int i = 0; i < n; ++i) {
            char c = this.string.charAt(i);
            if (c >= ' ' && c < '\u007f') {
                if (c == '\'' || c == '\"' || c == '\\') {
                    stringBuilder.append('\\');
                }
                stringBuilder.append(c);
                continue;
            }
            if (c <= '\u007f') {
                switch (c) {
                    case '\n': {
                        stringBuilder.append("\\n");
                        break;
                    }
                    case '\r': {
                        stringBuilder.append("\\r");
                        break;
                    }
                    case '\t': {
                        stringBuilder.append("\\t");
                        break;
                    }
                    default: {
                        int n2 = i < n - 1 ? (int)this.string.charAt(i + 1) : 0;
                        boolean bl = n2 >= 48 && n2 <= 55;
                        stringBuilder.append('\\');
                        for (int j = 6; j >= 0; j -= 3) {
                            char c2 = (char)((c >> j & 7) + 48);
                            if (c2 == '0' && !bl) continue;
                            stringBuilder.append(c2);
                            bl = true;
                        }
                        if (bl) continue block5;
                        stringBuilder.append('0');
                        break;
                    }
                }
                continue;
            }
            stringBuilder.append("\\u");
            stringBuilder.append(Character.forDigit(c >> 12, 16));
            stringBuilder.append(Character.forDigit(c >> 8 & 0xF, 16));
            stringBuilder.append(Character.forDigit(c >> 4 & 0xF, 16));
            stringBuilder.append(Character.forDigit(c & 0xF, 16));
        }
        return stringBuilder.toString();
    }

    public String toQuoted() {
        return '\"' + this.toHuman() + '\"';
    }

    public String toQuoted(int n) {
        String string;
        String string2 = this.toHuman();
        int n2 = string2.length();
        if (n2 <= n - 2) {
            string = "";
        } else {
            string2 = string2.substring(0, n - 5);
            string = "...";
        }
        return '\"' + string2 + string + '\"';
    }

    public String getString() {
        return this.string;
    }

    public ByteArray getBytes() {
        return this.bytes;
    }

    public int getUtf8Size() {
        return this.bytes.size();
    }

    public int getUtf16Size() {
        return this.string.length();
    }

    public Type getType() {
        return Type.STRING;
    }
}

