/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.ssa.back;

import com.android.dx.rop.code.RegisterSpec;
import com.android.dx.ssa.PhiInsn;
import com.android.dx.ssa.SsaBasicBlock;
import com.android.dx.ssa.SsaInsn;
import com.android.dx.ssa.SsaMethod;
import com.android.dx.ssa.back.InterferenceGraph;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;

public class LivenessAnalyzer {
    private final BitSet visitedBlocks;
    private final BitSet liveOutBlocks;
    private final int regV;
    private final SsaMethod ssaMeth;
    private final InterferenceGraph interference;
    private SsaBasicBlock blockN;
    private int statementIndex;
    private NextFunction nextFunction;

    public static InterferenceGraph constructInterferenceGraph(SsaMethod ssaMethod) {
        int n = ssaMethod.getRegCount();
        InterferenceGraph interferenceGraph = new InterferenceGraph(n);
        for (int i = 0; i < n; ++i) {
            new LivenessAnalyzer(ssaMethod, i, interferenceGraph).run();
        }
        LivenessAnalyzer.coInterferePhis(ssaMethod, interferenceGraph);
        return interferenceGraph;
    }

    private LivenessAnalyzer(SsaMethod ssaMethod, int n, InterferenceGraph interferenceGraph) {
        int n2 = ssaMethod.getBlocks().size();
        this.ssaMeth = ssaMethod;
        this.regV = n;
        this.visitedBlocks = new BitSet(n2);
        this.liveOutBlocks = new BitSet(n2);
        this.interference = interferenceGraph;
    }

    private void handleTailRecursion() {
        block5: while (this.nextFunction != NextFunction.DONE) {
            switch (this.nextFunction) {
                case LIVE_IN_AT_STATEMENT: {
                    this.nextFunction = NextFunction.DONE;
                    this.liveInAtStatement();
                    continue block5;
                }
                case LIVE_OUT_AT_STATEMENT: {
                    this.nextFunction = NextFunction.DONE;
                    this.liveOutAtStatement();
                    continue block5;
                }
                case LIVE_OUT_AT_BLOCK: {
                    this.nextFunction = NextFunction.DONE;
                    this.liveOutAtBlock();
                    continue block5;
                }
            }
        }
    }

    public void run() {
        int n;
        List<SsaInsn> list = this.ssaMeth.getUseListForRegister(this.regV);
        for (SsaInsn ssaInsn : list) {
            this.nextFunction = NextFunction.DONE;
            if (ssaInsn instanceof PhiInsn) {
                PhiInsn phiInsn = (PhiInsn)ssaInsn;
                Iterator<SsaBasicBlock> iterator = phiInsn.predBlocksForReg(this.regV, this.ssaMeth).iterator();
                while (iterator.hasNext()) {
                    SsaBasicBlock ssaBasicBlock;
                    this.blockN = ssaBasicBlock = iterator.next();
                    this.nextFunction = NextFunction.LIVE_OUT_AT_BLOCK;
                    this.handleTailRecursion();
                }
                continue;
            }
            this.blockN = ssaInsn.getBlock();
            this.statementIndex = this.blockN.getInsns().indexOf(ssaInsn);
            if (this.statementIndex < 0) {
                throw new RuntimeException("insn not found in it's own block");
            }
            this.nextFunction = NextFunction.LIVE_IN_AT_STATEMENT;
            this.handleTailRecursion();
        }
        while ((n = this.liveOutBlocks.nextSetBit(0)) >= 0) {
            this.blockN = this.ssaMeth.getBlocks().get(n);
            this.liveOutBlocks.clear(n);
            this.nextFunction = NextFunction.LIVE_OUT_AT_BLOCK;
            this.handleTailRecursion();
        }
    }

    private void liveOutAtBlock() {
        if (!this.visitedBlocks.get(this.blockN.getIndex())) {
            this.visitedBlocks.set(this.blockN.getIndex());
            this.blockN.addLiveOut(this.regV);
            ArrayList<SsaInsn> arrayList = this.blockN.getInsns();
            this.statementIndex = arrayList.size() - 1;
            this.nextFunction = NextFunction.LIVE_OUT_AT_STATEMENT;
        }
    }

    private void liveInAtStatement() {
        if (this.statementIndex == 0) {
            this.blockN.addLiveIn(this.regV);
            BitSet bitSet = this.blockN.getPredecessors();
            this.liveOutBlocks.or(bitSet);
        } else {
            --this.statementIndex;
            this.nextFunction = NextFunction.LIVE_OUT_AT_STATEMENT;
        }
    }

    private void liveOutAtStatement() {
        SsaInsn ssaInsn = this.blockN.getInsns().get(this.statementIndex);
        RegisterSpec registerSpec = ssaInsn.getResult();
        if (!ssaInsn.isResultReg(this.regV)) {
            if (registerSpec != null) {
                this.interference.add(this.regV, registerSpec.getReg());
            }
            this.nextFunction = NextFunction.LIVE_IN_AT_STATEMENT;
        }
    }

    private static void coInterferePhis(SsaMethod ssaMethod, InterferenceGraph interferenceGraph) {
        for (SsaBasicBlock ssaBasicBlock : ssaMethod.getBlocks()) {
            List<SsaInsn> list = ssaBasicBlock.getPhiInsns();
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < n; ++j) {
                    if (i == j) continue;
                    interferenceGraph.add(list.get(i).getResult().getReg(), list.get(j).getResult().getReg());
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum NextFunction {
        LIVE_IN_AT_STATEMENT,
        LIVE_OUT_AT_STATEMENT,
        LIVE_OUT_AT_BLOCK,
        DONE;

    }
}

