/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.util;

public final class Bits {
    private Bits() {
    }

    public static int[] makeBitSet(int n) {
        int n2 = n + 31 >> 5;
        return new int[n2];
    }

    public static int getMax(int[] nArray) {
        return nArray.length * 32;
    }

    public static boolean get(int[] nArray, int n) {
        int n2 = n >> 5;
        int n3 = 1 << (n & 0x1F);
        return (nArray[n2] & n3) != 0;
    }

    public static void set(int[] nArray, int n, boolean bl) {
        int n2 = n >> 5;
        int n3 = 1 << (n & 0x1F);
        if (bl) {
            int n4 = n2;
            nArray[n4] = nArray[n4] | n3;
        } else {
            int n5 = n2;
            nArray[n5] = nArray[n5] & ~n3;
        }
    }

    public static void set(int[] nArray, int n) {
        int n2 = n >> 5;
        int n3 = 1 << (n & 0x1F);
        int n4 = n2;
        nArray[n4] = nArray[n4] | n3;
    }

    public static void clear(int[] nArray, int n) {
        int n2 = n >> 5;
        int n3 = 1 << (n & 0x1F);
        int n4 = n2;
        nArray[n4] = nArray[n4] & ~n3;
    }

    public static boolean isEmpty(int[] nArray) {
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            if (nArray[i] == 0) continue;
            return false;
        }
        return true;
    }

    public static int bitCount(int[] nArray) {
        int n = nArray.length;
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            n2 += Integer.bitCount(nArray[i]);
        }
        return n2;
    }

    public static boolean anyInRange(int[] nArray, int n, int n2) {
        int n3 = Bits.findFirst(nArray, n);
        return n3 >= 0 && n3 < n2;
    }

    public static int findFirst(int[] nArray, int n) {
        int n2 = nArray.length;
        int n3 = n & 0x1F;
        for (int i = n >> 5; i < n2; ++i) {
            int n4;
            int n5 = nArray[i];
            if (n5 != 0 && (n4 = Bits.findFirst(n5, n3)) >= 0) {
                return (i << 5) + n4;
            }
            n3 = 0;
        }
        return -1;
    }

    public static int findFirst(int n, int n2) {
        int n3 = Integer.numberOfTrailingZeros(n &= ~((1 << n2) - 1));
        return n3 == 32 ? -1 : n3;
    }

    public static void or(int[] nArray, int[] nArray2) {
        for (int i = 0; i < nArray2.length; ++i) {
            int n = i;
            nArray[n] = nArray[n] | nArray2[i];
        }
    }

    public static String toHuman(int[] nArray) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        stringBuilder.append('{');
        int n = 32 * nArray.length;
        for (int i = 0; i < n; ++i) {
            if (!Bits.get(nArray, i)) continue;
            if (bl) {
                stringBuilder.append(',');
            }
            bl = true;
            stringBuilder.append(i);
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }
}

