@echo off
COLOR 81
:MENU
cls
@echo *****************************************
@echo *           EFS BACKUP                  *
@echo *****************************************
@echo * By A.S._id                            *
@echo *                                       *
@echo * To Use get ROOT                       *
@echo * connect to the USB debugging mode     *
@echo *                                       *
@echo * This Script will package BACKUP EFS   *
@echo * for flashing via Oidin.               *
@echo *                                       *
@echo * Options:                              *
@echo *                                       *
@echo * 1. BACKUP EFS                         *
@echo * 2. ODIN RESTORE                       *
@echo * 3. DD RESTORE                         *
@echo * 4. TAR.GZ_RESTORE                     *
@echo * 5. Exit                               *
@echo *****************************************
CHOICE /C:12345 /N /M "Please Select Option:"
IF ERRORLEVEL 5 GOTO EXIT
IF ERRORLEVEL 4 GOTO TAR.GZ_RESTORE
IF ERRORLEVEL 3 GOTO DD_RESTORE
IF ERRORLEVEL 2 GOTO ODIN_RESTORE
IF ERRORLEVEL 1 GOTO BACKUP

:BACKUP
CLS
@echo *****************************************
@echo *              BACKUP EFS               *
@echo *****************************************
CHOICE /C YN /M "WARNING: Do you wish to Continue? (This will make EFS BACKUP)"
IF ERRORLEVEL 2 GOTO MENU
@echo --- STARTING ----
@echo --- WAITING FOR DEVICE
bin\adb wait-for-device
@echo --- Backup efs image ---
bin\adb shell "echo | getprop > /sdcard/getprop.txt"
bin\adb pull /storage/sdcard0/getprop.txt
bin\adb shell "echo | getprop ril.product_code > /sdcard/version.txt ; getprop gsm.version.baseband >> /sdcard/version.txt ; getprop ril.serialnumber >> /sdcard/version.txt"
bin\adb pull /sdcard/version.txt
setlocal enabledelayedexpansion
for /f "tokens=*" %%a in (version.txt) do set "var=!var!%%a_"
echo %var%
bin\adb shell su -c "make_ext4fs -s -l 20M /sdcard/efs.img /efs"
bin\adb shell su -c "dd if=dev/block/mmcblk0p3 of=/sdcard/%var%EFS.raw.img"
bin\adb shell su -c "busybox tar cZvf /sdcard/%var%EFS.tar.gz /efs"
bin\adb pull /sdcard/efs.img
bin\adb pull /sdcard/%var%EFS.raw.img
bin\adb pull /sdcard/%var%EFS.tar.gz
bin\tar.exe -c efs.img >> %var%EFS.tar
bin\md5sum.exe -t %var%EFS.tar >> %var%EFS.tar 2>nul
REN %var%EFS.tar %var%EFS.tar.md5
bin\7za.exe a %var%EFS.zip %var%EFS.tar.md5 %var%EFS.raw.img %var%EFS.tar.gz getprop.txt
del *.img *.txt *.gz *.md5
@echo -
@echo -
@echo Finished. Output file is %var%EFS BACKUP
) ELSE ( @echo "ERROR: PACKAGING does not exist" )
pause
goto MENU

:ODIN_RESTORE
CLS
@echo *****************************************
@echo *              ODIN RESTORE             *
@echo *****************************************
CHOICE /C YN /M "WARNING: Do you wish to Continue? (This will Restore EFS via Odin)"
IF ERRORLEVEL 2 GOTO MENU
bin\7za.exe e *.zip *.md5
bin\adb reboot download
@echo --- For restore, to chose flash file EFS.tar.md5 into slot PDA ---
cd bin
Odin3.exe
cd ..\
del *.md5
pause
goto MENU

:DD_RESTORE
CLS
@echo *****************************************
@echo *              DD RESTORE               *
@echo *****************************************
CHOICE /C YN /M "WARNING: Do you wish to Continue? (This will Restore EFS via command dd)"
IF ERRORLEVEL 2 GOTO MENU
bin\7za.exe e *.zip *EFS.raw.img
@echo --- STARTING ----
@echo --- WAITING FOR DEVICE
bin\adb wait-for-device
@echo --- Restore efs partition ---
bin\adb push *EFS.raw.img /sdcard/EFS.raw.img
bin\adb shell su -c "dd if=/sdcard/EFS.raw.img of=/dev/block/mmcblk0p3 bs=4096"
del *.img
pause
goto MENU

:TAR.GZ_RESTORE
CLS
@echo *****************************************
@echo *              TAR.GZ RESTORE           *
@echo *****************************************
CHOICE /C YN /M "WARNING: Do you wish to Continue? (This will Restore EFS from tar.gz archive)"
IF ERRORLEVEL 2 GOTO MENU
bin\7za.exe e *.zip *EFS.tar.gz
@echo --- STARTING ----
@echo --- WAITING FOR DEVICE
bin\adb wait-for-device
@echo --- Restore efs directory ---
bin\adb push *EFS.tar.gz /sdcard/EFS.tar.gz
bin\adb shell su -c "busybox tar zxvf /sdcard/EFS.tar.gz -C /"
del *.gz
pause
goto MENU

:EXIT
@echo Good-Bye
pause
exit