/*
 * Decompiled with CFR 0.152.
 */
package com.android.signapk;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.security.DigestOutputStream;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import java.util.TreeMap;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.regex.Pattern;
import java.util.zip.ZipFile;
import javax.crypto.Cipher;
import javax.crypto.EncryptedPrivateKeyInfo;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import sun.misc.BASE64Encoder;
import sun.security.pkcs.ContentInfo;
import sun.security.pkcs.PKCS7;
import sun.security.pkcs.SignerInfo;
import sun.security.x509.AlgorithmId;
import sun.security.x509.X500Name;

class SignApk {
    private static final String CERT_SF_NAME = "META-INF/CERT.SF";
    private static final String CERT_RSA_NAME = "META-INF/CERT.RSA";
    private static Pattern stripPattern = Pattern.compile("^META-INF/(.*)[.](SF|RSA|DSA)$");

    SignApk() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static X509Certificate readPublicKey(File file) throws IOException, GeneralSecurityException {
        FileInputStream input = new FileInputStream(file);
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            X509Certificate x509Certificate = (X509Certificate)cf.generateCertificate(input);
            return x509Certificate;
        }
        finally {
            input.close();
        }
    }

    private static String readPassword(File keyFile) {
        System.out.print("Enter password for " + keyFile + " (password will not be hidden): ");
        System.out.flush();
        BufferedReader stdin = new BufferedReader(new InputStreamReader(System.in));
        try {
            return stdin.readLine();
        }
        catch (IOException ex) {
            return null;
        }
    }

    private static KeySpec decryptPrivateKey(byte[] encryptedPrivateKey, File keyFile) throws GeneralSecurityException {
        EncryptedPrivateKeyInfo epkInfo;
        try {
            epkInfo = new EncryptedPrivateKeyInfo(encryptedPrivateKey);
        }
        catch (IOException ex) {
            return null;
        }
        char[] password = SignApk.readPassword(keyFile).toCharArray();
        SecretKeyFactory skFactory = SecretKeyFactory.getInstance(epkInfo.getAlgName());
        SecretKey key = skFactory.generateSecret(new PBEKeySpec(password));
        Cipher cipher = Cipher.getInstance(epkInfo.getAlgName());
        cipher.init(2, (Key)key, epkInfo.getAlgParameters());
        try {
            return epkInfo.getKeySpec(cipher);
        }
        catch (InvalidKeySpecException ex) {
            System.err.println("signapk: Password for " + keyFile + " may be bad.");
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static PrivateKey readPrivateKey(File file) throws IOException, GeneralSecurityException {
        DataInputStream input = new DataInputStream(new FileInputStream(file));
        try {
            byte[] bytes = new byte[(int)file.length()];
            input.read(bytes);
            KeySpec spec = SignApk.decryptPrivateKey(bytes, file);
            if (spec == null) {
                spec = new PKCS8EncodedKeySpec(bytes);
            }
            try {
                PrivateKey privateKey = KeyFactory.getInstance("RSA").generatePrivate(spec);
                return privateKey;
            }
            catch (InvalidKeySpecException ex) {
                PrivateKey privateKey = KeyFactory.getInstance("DSA").generatePrivate(spec);
                input.close();
                return privateKey;
            }
        }
        finally {
            input.close();
        }
    }

    private static Manifest addDigestsToManifest(JarFile jar) throws IOException, GeneralSecurityException {
        Manifest input = jar.getManifest();
        Manifest output = new Manifest();
        Attributes main = output.getMainAttributes();
        if (input != null) {
            main.putAll((Map<?, ?>)input.getMainAttributes());
        } else {
            main.putValue("Manifest-Version", "1.0");
            main.putValue("Created-By", "1.0 (Android SignApk)");
        }
        BASE64Encoder base64 = new BASE64Encoder();
        MessageDigest md = MessageDigest.getInstance("SHA1");
        byte[] buffer = new byte[4096];
        TreeMap<String, JarEntry> byName = new TreeMap<String, JarEntry>();
        Enumeration<JarEntry> e = jar.entries();
        while (e.hasMoreElements()) {
            JarEntry entry = e.nextElement();
            byName.put(entry.getName(), entry);
        }
        for (JarEntry entry : byName.values()) {
            int num;
            String name = entry.getName();
            if (entry.isDirectory() || name.equals("META-INF/MANIFEST.MF") || name.equals(CERT_SF_NAME) || name.equals(CERT_RSA_NAME) || stripPattern != null && stripPattern.matcher(name).matches()) continue;
            InputStream data = jar.getInputStream(entry);
            while ((num = data.read(buffer)) > 0) {
                md.update(buffer, 0, num);
            }
            Attributes attr = null;
            if (input != null) {
                attr = input.getAttributes(name);
            }
            attr = attr != null ? new Attributes(attr) : new Attributes();
            attr.putValue("SHA1-Digest", base64.encode(md.digest()));
            output.getEntries().put(name, attr);
        }
        return output;
    }

    private static void writeSignatureFile(Manifest manifest, SignatureOutputStream out) throws IOException, GeneralSecurityException {
        Manifest sf = new Manifest();
        Attributes main = sf.getMainAttributes();
        main.putValue("Signature-Version", "1.0");
        main.putValue("Created-By", "1.0 (Android SignApk)");
        BASE64Encoder base64 = new BASE64Encoder();
        MessageDigest md = MessageDigest.getInstance("SHA1");
        PrintStream print = new PrintStream((OutputStream)new DigestOutputStream(new ByteArrayOutputStream(), md), true, "UTF-8");
        manifest.write(print);
        print.flush();
        main.putValue("SHA1-Digest-Manifest", base64.encode(md.digest()));
        Map<String, Attributes> entries = manifest.getEntries();
        for (Map.Entry<String, Attributes> entry : entries.entrySet()) {
            print.print("Name: " + entry.getKey() + "\r\n");
            for (Map.Entry<Object, Object> att : entry.getValue().entrySet()) {
                print.print(att.getKey() + ": " + att.getValue() + "\r\n");
            }
            print.print("\r\n");
            print.flush();
            Attributes sfAttr = new Attributes();
            sfAttr.putValue("SHA1-Digest", base64.encode(md.digest()));
            sf.getEntries().put(entry.getKey(), sfAttr);
        }
        sf.write(out);
        if (out.size() % 1024 == 0) {
            out.write(13);
            out.write(10);
        }
    }

    private static void writeSignatureBlock(Signature signature, X509Certificate publicKey, OutputStream out) throws IOException, GeneralSecurityException {
        SignerInfo signerInfo = new SignerInfo(new X500Name(publicKey.getIssuerX500Principal().getName()), publicKey.getSerialNumber(), AlgorithmId.get("SHA1"), AlgorithmId.get("RSA"), signature.sign());
        PKCS7 pkcs7 = new PKCS7(new AlgorithmId[]{AlgorithmId.get("SHA1")}, new ContentInfo(ContentInfo.DATA_OID, null), new X509Certificate[]{publicKey}, new SignerInfo[]{signerInfo});
        pkcs7.encodeSignedData(out);
    }

    private static void signWholeOutputFile(byte[] zipData, OutputStream outputStream, X509Certificate publicKey, PrivateKey privateKey) throws IOException, GeneralSecurityException {
        if (zipData[zipData.length - 22] != 80 || zipData[zipData.length - 21] != 75 || zipData[zipData.length - 20] != 5 || zipData[zipData.length - 19] != 6) {
            throw new IllegalArgumentException("zip data already has an archive comment");
        }
        Signature signature = Signature.getInstance("SHA1withRSA");
        signature.initSign(privateKey);
        signature.update(zipData, 0, zipData.length - 2);
        ByteArrayOutputStream temp = new ByteArrayOutputStream();
        byte[] message = "signed by SignApk".getBytes("UTF-8");
        temp.write(message);
        temp.write(0);
        SignApk.writeSignatureBlock(signature, publicKey, temp);
        int total_size = temp.size() + 6;
        if (total_size > 65535) {
            throw new IllegalArgumentException("signature is too big for ZIP file comment");
        }
        int signature_start = total_size - message.length - 1;
        temp.write(signature_start & 0xFF);
        temp.write(signature_start >> 8 & 0xFF);
        temp.write(255);
        temp.write(255);
        temp.write(total_size & 0xFF);
        temp.write(total_size >> 8 & 0xFF);
        temp.flush();
        byte[] b = temp.toByteArray();
        for (int i = 0; i < b.length - 3; ++i) {
            if (b[i] != 80 || b[i + 1] != 75 || b[i + 2] != 5 || b[i + 3] != 6) continue;
            throw new IllegalArgumentException("found spurious EOCD header at " + i);
        }
        outputStream.write(zipData, 0, zipData.length - 2);
        outputStream.write(total_size & 0xFF);
        outputStream.write(total_size >> 8 & 0xFF);
        temp.writeTo(outputStream);
    }

    private static void copyFiles(Manifest manifest, JarFile in, JarOutputStream out, long timestamp) throws IOException {
        byte[] buffer = new byte[4096];
        Map<String, Attributes> entries = manifest.getEntries();
        ArrayList<String> names = new ArrayList<String>(entries.keySet());
        Collections.sort(names);
        for (String name : names) {
            int num;
            JarEntry inEntry = in.getJarEntry(name);
            JarEntry outEntry = null;
            outEntry = inEntry.getMethod() == 0 ? new JarEntry(inEntry) : new JarEntry(name);
            outEntry.setTime(timestamp);
            out.putNextEntry(outEntry);
            InputStream data = in.getInputStream(inEntry);
            while ((num = data.read(buffer)) > 0) {
                out.write(buffer, 0, num);
            }
            out.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        if (args.length != 4 && args.length != 5) {
            System.err.println("Usage: signapk [-w] publickey.x509[.pem] privatekey.pk8 input.jar output.jar");
            System.exit(2);
        }
        boolean signWholeFile = false;
        int argstart = 0;
        if (args[0].equals("-w")) {
            signWholeFile = true;
            argstart = 1;
        }
        ZipFile inputJar = null;
        JarOutputStream outputJar = null;
        FileOutputStream outputFile = null;
        try {
            X509Certificate publicKey = SignApk.readPublicKey(new File(args[argstart + 0]));
            long timestamp = publicKey.getNotBefore().getTime() + 3600000L;
            PrivateKey privateKey = SignApk.readPrivateKey(new File(args[argstart + 1]));
            inputJar = new JarFile(new File(args[argstart + 2]), false);
            OutputStream outputStream = null;
            if (signWholeFile) {
                outputStream = new ByteArrayOutputStream();
            } else {
                outputFile = new FileOutputStream(args[argstart + 3]);
                outputStream = outputFile;
            }
            outputJar = new JarOutputStream(outputStream);
            outputJar.setLevel(9);
            Manifest manifest = SignApk.addDigestsToManifest((JarFile)inputJar);
            JarEntry je = new JarEntry("META-INF/MANIFEST.MF");
            je.setTime(timestamp);
            outputJar.putNextEntry(je);
            manifest.write(outputJar);
            Signature signature = Signature.getInstance("SHA1withRSA");
            signature.initSign(privateKey);
            je = new JarEntry(CERT_SF_NAME);
            je.setTime(timestamp);
            outputJar.putNextEntry(je);
            SignApk.writeSignatureFile(manifest, new SignatureOutputStream(outputJar, signature));
            je = new JarEntry(CERT_RSA_NAME);
            je.setTime(timestamp);
            outputJar.putNextEntry(je);
            SignApk.writeSignatureBlock(signature, publicKey, outputJar);
            SignApk.copyFiles(manifest, (JarFile)inputJar, outputJar, timestamp);
            outputJar.close();
            outputJar = null;
            outputStream.flush();
            if (signWholeFile) {
                outputFile = new FileOutputStream(args[argstart + 3]);
                SignApk.signWholeOutputFile(((ByteArrayOutputStream)outputStream).toByteArray(), outputFile, publicKey, privateKey);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        finally {
            try {
                if (inputJar != null) {
                    inputJar.close();
                }
                if (outputFile != null) {
                    outputFile.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                System.exit(1);
            }
        }
    }

    private static class SignatureOutputStream
    extends FilterOutputStream {
        private Signature mSignature;
        private int mCount;

        public SignatureOutputStream(OutputStream out, Signature sig) {
            super(out);
            this.mSignature = sig;
            this.mCount = 0;
        }

        public void write(int b) throws IOException {
            try {
                this.mSignature.update((byte)b);
            }
            catch (SignatureException e) {
                throw new IOException("SignatureException: " + e);
            }
            super.write(b);
            ++this.mCount;
        }

        public void write(byte[] b, int off, int len) throws IOException {
            try {
                this.mSignature.update(b, off, len);
            }
            catch (SignatureException e) {
                throw new IOException("SignatureException: " + e);
            }
            super.write(b, off, len);
            this.mCount += len;
        }

        public int size() {
            return this.mCount;
        }
    }
}

