#!/bin/python
# coding: utf8
##########################################
# Acer Iconia Toolkit                    #
# version:                0.7.2          #
# author:                 entonjackson   #
# contact:                XDA Developers #
# date:                   2013-07-25     #
##########################################
version = "v0.7.2"

from struct import calcsize
from time import sleep
import argparse
import os
import re
import subprocess
import sys

parser = argparse.ArgumentParser()
parser.add_argument("-d", "--debug", help="Print debug messages", action="store_true")
debug = parser.parse_args().debug

python3 = True
if sys.version_info < (3,0):
    python3 = False

arch = calcsize("P") * 8
if arch != 32 and arch != 64:
    print("E: Only 64bit and 32bit architecture supported.")
    print("")
    if python3:
        input("Press Enter to leave Application...")
    else:
        raw_input("Press Enter to leave Application...")
    sys.exit(1)

os_name = os.name
bin_folder   = os.path.join("bin", os_name, str(arch)) + os.sep
windows = True
adb = ""
if os_name == "posix":
    windows = False
    adb = "sudo " + bin_folder + "adb "
elif os_name == "nt":
    adb = bin_folder + "adb.exe "
else:
    print("Operating System: '" + os_name + "' not supported. Only for Windows and Unix/Linux.")
    print("")
    if python3:
        input("Press Enter to leave Application...")
    else:
        raw_input("Press Enter to leave Application...")
    sys.exit(1)

system_image = os.path.join("system_image", "system.img.gz")
busybox      = os.path.join("bin", "busybox")
baksmali     = os.path.join("bin", "baksmali.jar")
smali        = os.path.join("bin", "smali.jar")
zipalign     = bin_folder + "zipalign "
java         = "java -jar "
dev_null     = open(os.devnull, 'w')
su           = ""
dd_count     = ""
dd_seek      = ""
device       = ""
driver_url   = ""
a1           = False
b1_710       = False




def main():
    print("")
    print("======= Acer Iconia Toolkit " + version + " =======")
    print("")
    print("Which device do you have?")
    print("[1] Acer Iconia B1-A71")
    print("[2] Acer Iconia A1-810")
    print("[3] Acer Iconia B1-710 / B1-A710")
    print("[Q] Quit")
    print("")

    selection = ""
    if python3:
        selection = input("Enter a selection: ")
    else:
        selection = raw_input("Enter a selection: ")

    if selection == "q" or selection == "Q":
        sys.exit(0)

    if selection == "1":
        b1_a71_menu()
    elif selection == "2":
        a1_menu()
    elif selection == "3":
        b1_710_menu()
    else:
        print("E: Only '1', '2', '3' and 'Q' is allowed!")
        main()
    sys.exit(0)

def a1_menu():
    global a1
    global device
    global driver_url
    global dd_count
    global dd_seek
    global su

    a1 = True
    device = "Acer Iconia A1-810"
    driver_url = "http://goo.gl/i56Gn"
    dd_count = "262144"
    dd_seek = "17664"
    su = os.path.join("bin", "a1", "su")

    print("")
    print("======= " + device + " Toolkit " + version + " =======")
    print("")
    print("What do you want to do?")
    print("[1] Root")
    print("[2] Unroot")
    print("[3] Internal 2 External (needs root)")
    print("[4] Odex (needs root)")
    print("[Q] Quit")
    print("")

    selection = ""
    if python3:
        selection = input("Enter a selection: ")
    else:
        selection = raw_input("Enter a selection: ")

    if selection == "q" or selection == "Q":
        sys.exit(0)

    if selection == "3":
        swap_menu()
    
    if selection == "4":
        odex()

    if windows:
        if selection == "1":
            root()
        elif selection == "2":
            unroot()
        else:
            print("E: Only '1', '2', '3', '4' and 'Q' is allowed!")
            a1_menu()
    else:
        if selection == "1":
            unix_root_menu()
        elif selection == "2":
            unroot()
        else:
            print("E: Only '1', '2', '3', '4' and 'Q' is allowed!")
            a1_menu()
    sys.exit(0)

def b1_a71_menu():
    global su
    global device
    global driver_url
    global dd_count
    global dd_seek

    su = os.path.join("bin", "b1", "su")
    device = "Acer Iconia B1-A71"
    driver_url = "http://goo.gl/doR8L"
    dd_count = "156928"
    dd_seek = "8424"

    print("")
    print("======= " + device + " Toolkit " + version + " =======")
    print("")
    print("What do you want to do?")
    print("[1] Root")
    print("[2] Unroot")
    print("[3] Internal 2 External (needs root)")
    print("[4] Odex (needs root)")
    print("[Q] Quit")
    print("")

    selection = ""
    if python3:
        selection = input("Enter a selection: ")
    else:
        selection = raw_input("Enter a selection: ")

    if selection == "q" or selection == "Q":
        sys.exit(0)

    if selection == "3":
        swap_menu()

    if selection == "4":
        odex()

    if windows:
        if selection == "1":
            root()
        elif selection == "2":
            unroot()
        else:
            print("E: Only '1', '2', '3' or 'Q' is allowed!")
            b1_a71_menu()
    else:
        if selection == "1":
            unix_root_menu()
        elif selection == "2":
            unroot()
        else:
            print("E: Only '1', '2', '3' or 'Q' is allowed!")
            b1_a71_menu()
    sys.exit(0)


def b1_710_menu():
    global b1_710
    global su
    global device
    global driver_url
    global dd_count
    global dd_seek

    b1_710 = True
    su = os.path.join("bin", "b1", "su")
    device = "Acer Iconia B1-710 / B1-A710"
    driver_url = "http://goo.gl/Otbkb"
    dd_count = "262144"
    dd_seek = "9448"

    print("")
    print("======= " + device + " Toolkit " + version + " =======")
    print("")
    print("What do you want to do?")
    print("[1] Root")
    print("[2] Unroot")
    print("[3] Internal 2 External (needs root)")
    print("[4] Odex (needs root)")
    print("[Q] Quit")
    print("")

    selection = ""
    if python3:
        selection = input("Enter a selection: ")
    else:
        selection = raw_input("Enter a selection: ")

    if selection == "q" or selection == "Q":
        sys.exit(0)

    if selection == "3":
        swap_menu()

    if selection == "4":
        odex()

    if windows:
        if selection == "1":
            root()
        elif selection == "2":
            unroot()
        else:
            print("E: Only '1', '2', '3', '4' or 'Q' is allowed!")
            b1_a71_menu()
    else:
        if selection == "1":
            unix_root_menu()
        elif selection == "2":
            unroot()
        else:
            print("E: Only '1', '2', '3', '4' or 'Q' is allowed!")
            b1_a71_menu()
    sys.exit(0)

def swap_menu():
    print("")
    print("===== Internal 2 External ======")
    print("Make sure an external micro sd card is plugged in.")

    if not windows:
        subprocess.call("sudo chmod +x " + bin_folder + "adb", stdout=dev_null, shell=True)

    check_adb()

    # Check which configuration is present
    print("")
    print("Checking current partition settings...")
    subprocess.call(adb + "pull /etc/vold.fstab", stdout=dev_null, shell=True)

    vold_fstab_str = "vold.fstab"
    try:
        with open(vold_fstab_str):
            print_debug("Successfully pulled vold.fstab.")
    except IOError:
        print("E: Failed to check partition settings. Couldn't pull /etc/vold.fstab.")
        wait_for_enter_exit_error()

    config_internal = ""
    config_external = ""
    vold_fstab = open(vold_fstab_str, "r")
    lines = vold_fstab.readlines()
    print("")
    print("Current SD partition configuration: ")
    
    sd_name = "mtk-sd"
    if a1:
        sd_name = "mtk-msdc"
    
    for l in lines:
        if l.startswith("#"):
            continue
        if "dev_mount sdcard /storage/sdcard0 emmc@fat /devices/platform/goldfish_mmc.0 /devices/platform/" + sd_name + ".0/mmc_host" in l:
            print("Internal SD -> Internal (Default).")
            config_internal = "default"
        elif "dev_mount sdcard2 /storage/sdcard1 auto /devices/platform/goldfish_mmc.1 /devices/platform/" + sd_name + ".1/mmc_host" in l:
            print("External SD -> External (Default).")
            config_external = "default"
        elif "dev_mount sdcard /storage/sdcard1 emmc@fat /devices/platform/goldfish_mmc.1 /devices/platform/" + sd_name + ".0/mmc_host" in l:
            print("Internal SD -> External (Swapped).")
            config_internal = "swapped"
        elif "dev_mount sdcard2 /storage/sdcard0 auto /devices/platform/goldfish_mmc.0 /devices/platform/" + sd_name + ".1/mmc_host" in l:
            print("External SD -> External (Swapped).")
            config_external = "swapped"
    vold_fstab.close()
    os.remove(vold_fstab_str)

    if config_internal == "" or \
       config_external == "":
        print("E: Failed to determine sd partition configuration.")
        wait_for_enter_exit_error()

    if config_internal != config_external:
        print("E: Mixed up SD partition configuration.")
        wait_for_enter_exit_error()

    print("")
    print("Would you like to backup data from your partition, mapped as External SD, before swapping partitions?")
    print("[1] Yes")
    print("[2] I need more Internal space! Now!")
    print("[Q] Quit")
    print("")

    selection = ""
    if python3:
        selection = input("Enter a selection: ")
    else:
        selection = raw_input("Enter a selection: ")

    if selection == "q" or selection == "Q":
        sys.exit(0)

    # swap partitions with or w/o backup
    backup = True
    if selection == "2" or \
       selection.lower() == "no":
        backup = False
    else:
        backup_ext_sd(config_internal)

    swap_ext_to_int_sd(config_internal)
    if backup:
        restore_ext_sd(config_internal)

    print("")
    print("SUCCESS!")
    print("The SD partitions of your " + device + " are now successfully swapped.")
    print("Do a reboot and enjoy.")
    print_thanks()
    wait_for_enter_exit_success()


def odex():
    print("")
    print("========== Odexing " + device + " ==========")

    if not windows:
        subprocess.call("sudo chmod +x " + bin_folder + "adb", stdout=dev_null, shell=True)

    check_adb()

    print("")
    print( "Hit Enter to start Odexing. This can take a while. If your " + device + " does a reboot, you succeeded." )
    wait_for_enter_start()

    # remount /system with RW permissions
    if debug:
        p = subprocess.Popen(adb + "shell", stdin=subprocess.PIPE, shell=True)
    else:
        p = subprocess.Popen(adb + "shell", stdin=subprocess.PIPE, stderr=dev_null, stdout=dev_null, shell=True)
    if python3:
        p.stdin.write(bytes("su\n", "utf-8"))
        p.stdin.write(bytes("mount -o rw,remount /system\n", "utf-8"))
        p.stdin.write(bytes("chmod 777 /system/bin/\n", "utf-8"))
        p.stdin.write(bytes("chmod 777 /system/xbin/\n", "utf-8"))
        p.stdin.write(bytes("exit\n", "utf-8"))
        p.stdin.write(bytes("exit\n", "utf-8"))
    else:
        p.stdin.write("su\n")
        p.stdin.write("mount -o rw,remount /system\n")
        p.stdin.write("chmod 777 /system/bin/\n")
        p.stdin.write("chmod 777 /system/xbin/\n")
        p.stdin.write("exit\n")
        p.stdin.write("exit\n")
    p.stdin.flush()

    # copy dexo tool and its files
    if debug:
        subprocess.call(adb + "push bin/odex/dexo /system/bin/",                    shell=True)
        subprocess.call(adb + "shell su -c 'chmod 777 /system/bin/dexo'",           shell=True)
        subprocess.call(adb + "push bin/odex/dexopt-wrapper /system/bin/",          shell=True)
        subprocess.call(adb + "shell su -c 'chmod 777 /system/bin/dexopt-wrapper'", shell=True)
        subprocess.call(adb + "push bin/odex/busyodex /system/xbin/",               shell=True)
        subprocess.call(adb + "shell su -c 'chmod 777 /system/xbin/busyodex'",      shell=True)
        subprocess.call(adb + "push bin/odex/zip /system/xbin/",                    shell=True)
        subprocess.call(adb + "shell su -c 'chmod 777 /system/xbin/zip'",           shell=True)
        subprocess.call(adb + "push bin/odex/zipalign /system/xbin/",               shell=True)
        subprocess.call(adb + "shell su -c 'chmod 777 /system/xbin/zipalign'",      shell=True)
    else:
        subprocess.call(adb + "push bin/odex/dexo /system/bin/",                    stderr=dev_null, stdout=dev_null, shell=True)
        subprocess.call(adb + "shell su -c 'chmod 777 /system/bin/dexo'",           stderr=dev_null, stdout=dev_null, shell=True)
        subprocess.call(adb + "push bin/odex/dexopt-wrapper /system/bin/",          stderr=dev_null, stdout=dev_null, shell=True)
        subprocess.call(adb + "shell su -c 'chmod 777 /system/bin/dexopt-wrapper'", stderr=dev_null, stdout=dev_null, shell=True)
        subprocess.call(adb + "push bin/odex/busyodex /system/xbin/",               stderr=dev_null, stdout=dev_null, shell=True)
        subprocess.call(adb + "shell su -c 'chmod 777 /system/xbin/busyodex'",      stderr=dev_null, stdout=dev_null, shell=True)
        subprocess.call(adb + "push bin/odex/zip /system/xbin/",                    stderr=dev_null, stdout=dev_null, shell=True)
        subprocess.call(adb + "shell su -c 'chmod 777 /system/xbin/zip'",           stderr=dev_null, stdout=dev_null, shell=True)
        subprocess.call(adb + "push bin/odex/zipalign /system/xbin/",               stderr=dev_null, stdout=dev_null, shell=True)
        subprocess.call(adb + "shell su -c 'chmod 777 /system/xbin/zipalign'",      stderr=dev_null, stdout=dev_null, shell=True)

    # odex and remount /system as RO
    if debug:
        p = subprocess.Popen(adb + "shell", stdin=subprocess.PIPE, shell=True)
    else:
        p = subprocess.Popen(adb + "shell", stdin=subprocess.PIPE, stderr=dev_null, stdout=dev_null, shell=True)
    if python3:
        p.stdin.write(bytes("su\n", "utf-8"))
        p.stdin.write(bytes("chmod 755 /system/bin/\n", "utf-8"))
        p.stdin.write(bytes("chmod 755 /system/xbin/\n", "utf-8"))
        p.stdin.write(bytes("cd /system/xbin\n", "utf-8"))
        p.stdin.write(bytes("/data/local/tmp/busybox cp -r busybox bb1\n", "utf-8"))
        p.stdin.write(bytes("/data/local/tmp/busybox cp -r busyodex busybox\n", "utf-8"))
        p.stdin.write(bytes("/data/local/tmp/busybox --help | /data/local/tmp/busybox grep 'Currently defined functions:' -A300 | /data/local/tmp/busybox grep -v 'Currently defined functions:' | /data/local/tmp/busybox tr , '\n' | /data/local/tmp/busybox xargs -n1 /data/local/tmp/busybox ln -s busybox\n", "utf-8"))
        p.stdin.write(bytes("cp -r bb1 busybox\n", "utf-8"))
        p.stdin.write(bytes("rm bb1\n", "utf-8"))
        p.stdin.write(bytes("dexo -all\n", "utf-8"))
        p.stdin.write(bytes("mount -o ro,remount /system\n", "utf-8"))
        p.stdin.write(bytes("exit\n", "utf-8"))
        p.stdin.write(bytes("exit\n", "utf-8"))
    else:
        p.stdin.write("su\n")
        p.stdin.write("chmod 755 /system/bin/\n")
        p.stdin.write("chmod 755 /system/xbin/\n")
        p.stdin.write("cd /system/xbin\n")
        p.stdin.write("/data/local/tmp/busybox cp -r busybox bb1\n")
        p.stdin.write("/data/local/tmp/busybox cp -r busyodex busybox\n")
        p.stdin.write("/data/local/tmp/busybox --help | /data/local/tmp/busybox grep 'Currently defined functions:' -A300 | /data/local/tmp/busybox grep -v 'Currently defined functions:' | /data/local/tmp/busybox tr , '\n' | /data/local/tmp/busybox xargs -n1 /data/local/tmp/busybox ln -s busybox\n")
        p.stdin.write("cp -r bb1 busybox\n")
        p.stdin.write("rm bb1\n")
    p.stdin.flush()

    if debug:
        subprocess.call(adb + "shell su -c 'dexo -all'", shell=True)
    else:
        subprocess.call(adb + "shell su -c 'dexo -all'", stdout=dev_null, shell=True)

    # no remount /system RO because dexo -all does a reboot anyway

    print("")
    print("If your " + device + " is now rebooting, you're successfully odexed!")
    print_thanks()
    wait_for_enter_exit_success()

def unix_root_menu():
    print("")
    print("What do you want to do?")
    print("[1] Root from scratch (without prerooted system.img.gz).")
    print("[2] Root with prerooted system.img.gz (must be placed in folder 'system_image')")
    print("[Q] Quit")

    selection = ""
    if python3:
        selection = input("Enter a selection: ")
    else:
        selection = raw_input("Enter a selection: ")

    if selection == "q" or selection == "Q":
        sys.exit(0)

    if selection == "1":
        unix_root_from_scratch()
    elif selection == "2":
        root()
    else:
        print("E: Only '1' or '2' is allowed!")
        unix_root_menu()


def unix_root_from_scratch():
    print("")
    print("================== Root =================")
    start_info()
    print("The following procedures will take about 10 minutes. To finally play back the rooted system.img.gz a confirmation will be needed then.")
    wait_for_enter_start()

    subprocess.call("sudo chmod +x " + bin_folder + "adb", shell=True)

    check_adb()
    push_busybox()
    start_telnet_server()
    check_dumchar_info()

    # pull system.img.gz
    print("Creating system.img.gz (this will take about 7 minutes) ...")

    p = subprocess.Popen(adb + "shell", stdin=subprocess.PIPE, stdout=dev_null, shell=True)
    if python3:
        p.stdin.write(bytes("/data/local/tmp/busybox telnet 127.0.0.1 1234\n", "utf-8"))
        p.stdin.write(bytes("dd if=/dev/block/mmcblk0 bs=4096 skip=" + dd_seek + " count=" + dd_count + " | gzip > /cache/system.img.gz\n", "utf-8"))
        p.stdin.flush()
        sleep(300)
        p.stdin.write(bytes("exit\n", "utf-8"))
        p.stdin.write(bytes("exit\n", "utf-8"))
    else:
        p.stdin.write("/data/local/tmp/busybox telnet 127.0.0.1 1234\n")
        p.stdin.write("dd if=/dev/block/mmcblk0 bs=4096 skip=" + dd_seek + " count=" + dd_count + " | gzip > /cache/system.img.gz\n")
        p.stdin.flush()
        sleep(300)
        p.stdin.write("exit\n")
        p.stdin.write("exit\n")
    p.stdin.flush()

    # chmod /cache
    if debug:
        p = subprocess.Popen(adb + "shell", stdin=subprocess.PIPE, shell=True)
    else:
        p = subprocess.Popen(adb + "shell", stdin=subprocess.PIPE, stdout=dev_null, shell=True)
    if python3:
        p.stdin.write(bytes("/data/local/tmp/busybox telnet 127.0.0.1 1234\n", "utf-8"))
        p.stdin.write(bytes("chmod 777 /cache\n", "utf-8"))
        p.stdin.write(bytes("chmod 777 /cache/system.img.gz\n", "utf-8"))
        p.stdin.flush()
        sleep(2)
        p.stdin.write(bytes("exit\n", "utf-8"))
        p.stdin.write(bytes("exit\n", "utf-8"))
    else:
        p.stdin.write("/data/local/tmp/busybox telnet 127.0.0.1 1234\n")
        p.stdin.write("chmod 777 /cache\n")
        p.stdin.write("chmod 777 /cache/system.img.gz\n")
        p.stdin.flush()
        sleep(2)
        p.stdin.write("exit\n")
        p.stdin.write("exit\n")
    p.stdin.flush()
    sleep(0.5)

    out = subprocess.check_output(adb + "shell ls /cache", shell=True)
    if python3:
        out = out.decode("utf-8")
    print_debug(out)

    if "opendir failed, Permission denied" in out:
        print("fail")
        wait_for_enter_exit_error()
    if "system.img.gz" not in out:
        print("Failed to create a system.img.gz. Missing telnet connection could be the problem. Try again.")
        wait_for_enter_exit_error()

    print("Successfully created a system.img.gz under /cache.")

    print("")
    print("Pulling system.img.gz from phone...")
    if debug:
        subprocess.call(adb + "pull /cache/system.img.gz", shell=True)
    else:
        subprocess.call(adb + "pull /cache/system.img.gz",stdout=dev_null, shell=True)
    try:
        with open("system.img.gz"):
            print("system.img.gz successfully pulled from tablet.")
    except IOError:
        print("E: system.img.gz couldn't be pulled from tablet.")
        wait_for_enter_exit_error()

    print("")
    print("Adding su binary to system.img ...")

    if debug:
        subprocess.call("sudo chmod 777 system.img.gz", shell=True)
        subprocess.call("gunzip system.img.gz", shell=True)
    else:
        subprocess.call("sudo chmod 777 system.img.gz", stdout=dev_null, shell=True)
        subprocess.call("gunzip system.img.gz", stdout=dev_null, shell=True)
    try:
        with open("system.img"):
            print_debug("Successfully gunzipped pulled system.img.gz")
    except IOError:
        print("E: Couldn't unzip system.img.")
        wait_for_enter_exit_error()

    # mount system.img.gz
    if debug:
        subprocess.call("sudo mkdir /media/iconia", shell=True)
    else:
        subprocess.call("sudo mkdir /media/iconia", stdout=dev_null, shell=True)
    if not os.path.exists("/media/iconia"):
        print("E: Couldn't create Directory '/media/iconia'")
        print("Cleaning up...")
        if debug:
            subprocess.call("rm system.img*", shell=True)
        else:
            subprocess.call("rm system.img*", stdout=dev_null, shell=True)
        wait_for_enter_exit_error()

    if debug:
        subprocess.call("sudo mount -o loop system.img /media/iconia", shell=True)
    else:
        subprocess.call("sudo mount -o loop system.img /media/iconia", stdout=dev_null, shell=True)
    if not os.path.exists("/media/iconia/bin"):
        print("E: Failed to mount system.img.")
        print("Cleaning up...")
        subprocess.call("sudo rm -rf /media/iconia", stdout=dev_null, shell=True)
        subprocess.call("rm system.img*", stdout=dev_null, shell=True)
        wait_for_enter_exit_error()

    # add su binary
    if debug:
        subprocess.call("sudo cp " + su + " /media/iconia/bin", shell=True)
    else:
        subprocess.call("sudo cp " + su + " /media/iconia/bin", stdout=dev_null, shell=True)
    try:
        with open("/media/iconia/bin/su"):
            print("Successfully mounted pulled system image.")
    except IOError:
        print("E: Couldn't unzip system.img.")
        print("Cleaning up...")
        subprocess.call("sudo umount /media/iconia", stdout=dev_null, shell=True)
        subprocess.call("sudo rm -rf /media/iconia", stdout=dev_null, shell=True)
        subprocess.call("rm system.img*", stdout=dev_null, shell=True)
        wait_for_enter_exit_error()

    # unmount system.img.gz
    if debug:
        subprocess.call("sudo chmod 06755 /media/iconia/bin/su", shell=True)
        subprocess.call("sudo umount /media/iconia", shell=True)
        subprocess.call("sudo rm -rf /media/iconia", shell=True)
        subprocess.call("gzip system.img", shell=True)
    else:
        subprocess.call("sudo chmod 06755 /media/iconia/bin/su", stdout=dev_null, shell=True)
        subprocess.call("sudo umount /media/iconia", stdout=dev_null, shell=True)
        subprocess.call("sudo rm -rf /media/iconia", stdout=dev_null, shell=True)
        subprocess.call("gzip system.img", stdout=dev_null, shell=True)
    try:
        with open("system.img.gz"):
            print("Successfully added su binary to system.img.")
    except IOError:
        print("E: Couldn't gzip system.img containing the su binary.")
        subprocess.call("rm system.img*", stdout=dev_null, shell=True)
        wait_for_enter_exit_error()

    # remove old system.img.gz
    if debug:
        p = subprocess.Popen(adb + "shell", stdin=subprocess.PIPE, shell=True)
    else:
        p = subprocess.Popen(adb + "shell", stdin=subprocess.PIPE, stdout=dev_null, shell=True)
    if python3:
        p.stdin.write(bytes("rm /cache/system.img.gz'\n", "utf-8"))
        p.stdin.write(bytes("exit\n", "utf-8"))
        p.stdin.write(bytes("exit\n", "utf-8"))
    else:
        p.stdin.write("rm /cache/system.img.gz'\n")
        p.stdin.write("exit\n")
        p.stdin.write("exit\n")
    p.stdin.flush()

    # push rooted system.img.gz
    print("")
    print("Copying rooted system.img.gz to your " + device + " (This will take 1-2 minutes)...")
    if debug:
        subprocess.call(adb + "push system.img.gz /cache", shell=True)
    else:
        subprocess.call(adb + "push system.img.gz /cache", stdout=dev_null, shell=True)
    p = subprocess.Popen(adb + "shell ls /cache", stdout=subprocess.PIPE, shell=True)
    p.wait()

    found = False
    out = p.stdout.readlines()
    for o in out:
        if python3:
            o = o.decode("utf-8")
        print_debug(o)
        if "system.img.gz" in o:
            found = True
            break
    if found:
        print("Successfully copied system.img.gz to /cache")
    else:
        print("Failed to copy system.img.gz. Make sure the folder 'system_image' contains a system.img.gz suiting to your installed firmware.")
        subprocess.call("rm system.img*", stdout=dev_null, shell=True)
        wait_for_enter_exit_error()

    write_system_image()


def root():
    print("")
    print("================== Root =================")
    start_info()
    wait_for_enter_start()

    if not windows:
        subprocess.call("sudo chmod +x " + bin_folder + "adb", shell=True)

    check_adb()
    push_busybox()
    start_telnet_server()
    check_dumchar_info()
    check_firmware_version()
    push_system_image()
    write_system_image()


def unroot():
    print("")
    print("================= Unroot ================")
    start_info()
    wait_for_enter_start()

    if not windows:
        subprocess.call("sudo chmod +x " + bin_folder + "adb", shell=True)

    check_adb()
    remove_su_binary()


def write_system_image():
    print("Wrting rooted system.img.gz. This is going to take 2 minutes.")
    print("IN -ANY- CASE, DON'T INTERRUPT THIS PROCESS, OR YOUR DEVICE COULD BE -BRICKED-")
    wait_for_enter_start()

    if debug:
        p = subprocess.Popen(adb + "shell", stdin=subprocess.PIPE, stdout=subprocess.PIPE, shell=True)
    else:
        p = subprocess.Popen(adb + "shell", stdin=subprocess.PIPE, stdout=dev_null, shell=True)
    if python3:
        p.stdin.write(bytes("/data/local/tmp/busybox telnet 127.0.0.1 1234\n", "utf-8"))
        p.stdin.write(bytes("/data/local/tmp/busybox zcat /cache/system.img.gz | dd of=/dev/block/mmcblk0 bs=4096 seek=" + dd_seek + " count=" + dd_count + "\n", "utf-8"))
        p.stdin.flush()
        progress_root()
        p.stdin.write(bytes("exit\n", "utf-8"))
        p.stdin.write(bytes("exit\n", "utf-8"))
    else:
        p.stdin.write("/data/local/tmp/busybox telnet 127.0.0.1 1234\n")
        p.stdin.write("/data/local/tmp/busybox zcat /cache/system.img.gz | dd of=/dev/block/mmcblk0 bs=4096 seek=" + dd_seek + " count=" + dd_count + "\n")
        p.stdin.flush()
        progress_root()
        p.stdin.write("exit\n")
        p.stdin.write("exit\n")
    p.stdin.flush()
    if debug:
        p.stdout.flush()

    print("")
    print("SUCCESS!")
    print("Your " + device + " is now rooted. Unplug your tablet and reboot. Install Superuser from the Google Play Store and have fun ;-)")
    print("If your tablet is turned off and doesn't turn on anymore, take a pin and press the reset button on the right side of the Iconia B1, above the power button.")
    print_thanks()
    wait_for_enter_exit_success()


def remove_su_binary():
    wait_for_enter_start()

    p = subprocess.Popen(adb + "shell", stdin=subprocess.PIPE, stdout=subprocess.PIPE, shell=True)
    if python3:
        p.stdin.write(bytes("su\n", "utf-8"))
        p.stdin.write(bytes("mount -o rw,remount /system/\n", "utf-8"))
        p.stdin.write(bytes("rm /system/bin/su\n", "utf-8"))
        p.stdin.write(bytes("rm /system/xbin/su\n", "utf-8"))
        p.stdin.write(bytes("rm /system.bin/.ext/.su\n", "utf-8"))
        p.stdin.write(bytes("mount -o ro,remount /system/\n", "utf-8"))
        p.stdin.write(bytes("exit\n", "utf-8"))
        p.stdin.write(bytes("exit\n", "utf-8"))

    else:
        p.stdin.write("su\n")
        p.stdin.write("mount -o rw,remount /system/\n")
        p.stdin.write("rm /system/bin/su\n")
        p.stdin.write("rm /system/xbin/su\n")
        p.stdin.write("rm /system.bin/.ext/.su\n")
        p.stdin.write("mount -o ro,remount /system/\n")
        p.stdin.write("exit\n")
        p.stdin.write("exit\n")
    p.stdin.flush()
    p.stdout.flush()

    for _ in range(7):
        p.stdout.readline()

    out = p.stdout.readline()
    if python3:
        out = out.decode("utf-8")

    print(out)
    if "not found" in out:
        print("")
        print("FAILED!")
        print("Your " + device + " already has no root.")
        wait_for_enter_exit_error()
    else:
        print("")
        print("SUCCESS!")
        print("Your " + device + " is now unrooted.")
        print("Unplug your tablet, do a reboot, install Root Checker on Google Play Store to verify.")
        print_thanks()
        wait_for_enter_exit_success()


def backup_ext_sd(config):
    print("")
    print("Backing up External SD...")
    print("Dependent of how much data you have stored, this can take pretty a while...")

    # remove old files in backup folder if existing
    backup_folder = os.path.join("external2internal", "external_backup")
    if windows:
        subprocess.call("del /Q " + backup_folder + "\\*", stdout=dev_null, shell=True)
    else:
        subprocess.call("sudo rm -rf " + backup_folder + "/*", stdout=dev_null, shell=True)

    # pull all files from external partition
    if config == "default":
        subprocess.call(adb + "pull /mnt/sdcard/ " + backup_folder, stdout=dev_null, shell=True)
    else:
        subprocess.call(adb + "pull /mnt/sdcard2/ " + backup_folder, stdout=dev_null, shell=True)


def swap_ext_to_int_sd(config):
    print("")
    if config == "default":
        print("Swap Internal SD -> External SD and External SD -> Internal SD...  ")
    else:
        print("Swap External SD -> Internal SD and Internal SD -> External SD...  ")
    print("")

    internal = ""
    external = ""
    if config == "default":
        internal = " /mnt/sdcard2/"
        external = " /mnt/sdcard/"
    else:
        internal = " /mnt/sdcard/"
        external = " /mnt/sdcard2/"

    # backing up data from internal partition
    print("Backing up Internal SD data...")
    print("Dependent of how much data you have stored, this can take pretty a while...")
    wait_for_enter_start()
    backup_folder = os.path.join("external2internal", "internal_backup")

    # remove old files in backup folder if existing
    if windows:
        if debug:
            subprocess.call("del /Q " + backup_folder + "\\*", shell=True)
        else:
            subprocess.call("del /Q " + backup_folder + "\\*", stdout=dev_null, shell=True)
    else:
        if debug:
            subprocess.call("sudo rm -rf " + backup_folder + "/*", shell=True)
        else:
            subprocess.call("sudo rm -rf " + backup_folder + "/*", stdout=dev_null, shell=True)

    # pulling data from internal partition
    if debug:
        subprocess.call(adb + "pull" + internal + " " + os.path.join("external2internal", "internal_backup"), shell=True)
    else:
        subprocess.call(adb + "pull" + internal + " " + os.path.join("external2internal", "internal_backup"), stdout=dev_null, shell=True)
    print("Successfully backed up Internal SD data.")
    print("")

    # delete old files from external partition first
    if debug:
        subprocess.call(adb + "shell rm -r" + external + "*", shell=True)
    else:
        subprocess.call(adb + "shell rm -r" + external + "*", stdout=dev_null, shell=True)

    if config == "default":
        print("Copying backed up Internal data from Internal SD onto External SD...")
    else:
        print("Copying backed up Internal data from External SD back onto Internal SD...")
    wait_for_enter_start()

    # pushing internal data on external partition
    if debug:
        subprocess.call(adb + "push " + os.path.join("external2internal", "internal_backup") + external, shell=True)
    else:
        subprocess.call(adb + "push " + os.path.join("external2internal", "internal_backup") + external, stdout=dev_null, shell=True)
    if config == "default":
        print("Successfully copied Internal data onto External SD.")
    else:
        print("Successfully copied Internal data back onto Internal SD.")

    # swapping partitions
    print("")
    print("Swapping Partitions...")
    wait_for_enter_start()
    
    subfolder = "b1"
    if a1:
        subfolder = "a1"
    
    if config == "default":
        subprocess.call(adb + "push " + os.path.join("external2internal", subfolder, "vold.fstab.swapped") + " /data/local/tmp/vold.fstab", shell=True)
    else:
        subprocess.call(adb + "push " + os.path.join("external2internal", subfolder, "vold.fstab.default") + " /data/local/tmp/vold.fstab", shell=True)

    p = subprocess.Popen(adb + "shell", stdin=subprocess.PIPE, stdout=subprocess.PIPE, shell=True)
    if python3:
        p.stdin.write(bytes("su\n", "utf-8"))
        p.stdin.write(bytes("mount -o rw,remount /system/\n", "utf-8"))
        p.stdin.write(bytes("cat /data/local/tmp/vold.fstab > /etc/vold.fstab\n", "utf-8"))
        p.stdin.write(bytes("mount -o ro,remount /system/\n", "utf-8"))
        p.stdin.write(bytes("exit\n", "utf-8"))
        p.stdin.write(bytes("exit\n", "utf-8"))
        p.stdin.flush()
    else:
        p.stdin.write("su\n")
        p.stdin.write("mount -o rw,remount /system/\n")
        p.stdin.write("cat /data/local/tmp/vold.fstab > /etc/vold.fstab\n")
        p.stdin.write("mount -o ro,remount /system/\n")
        p.stdin.write("exit\n")
        p.stdin.write("exit\n")
    p.stdin.flush()
    p.stdout.flush()

    for _ in range(7):
        if debug:
            out = p.stdout.readline()
            if python3:
                out = out.decode("utf-8")
            print(out)

    out = p.stdout.readline()
    if python3:
        out = out.decode("utf-8")
    print_debug(out)

    if "not found" in out:
        print("E: Failed to mount /system. Device not rooted!")
        print("SD Partitions couldn't be swapped.")
        wait_for_enter_exit_success()

    print("Successfully swapped SD Partitions.")


def restore_ext_sd(config):
    print("")
    print("Restoring External SD Data...")
    print("Dependent of how much data you have stored, this can take pretty a while...")
    wait_for_enter_start()

    dest = ""
    if config == "default":
        dest = " /mnt/sdcard/"
    else:
        dest = " /mnt/sdcard2/"

    # delete old files from destination first
    if debug:
        subprocess.call(adb + "shell rm -r" + dest + "*", shell=True)
        subprocess.call(adb + "push " + os.path.join("external2internal", "external_backup") + dest, shell=True)
    else:
        subprocess.call(adb + "shell rm -r" + dest + "*", stdout=dev_null, shell=True)
        subprocess.call(adb + "push " + os.path.join("external2internal", "external_backup") + dest , stdout=dev_null, shell=True)
    print("Successfully restored External data.")


def progress_root():
    for i in range(60):
        sleep(2)
        if i == 0:
            sys.stdout.write("R")
        elif i == 20:
            sys.stdout.write("O")
        elif i == 40:
            sys.stdout.write("O")
        elif i == 59:
            sys.stdout.write("T")
        else:
            sys.stdout.write(".")
        sys.stdout.flush()
    print("")


def push_busybox():
    print("")
    print("Copying Busybox to your " + device + ".")
    subprocess.call(adb + "push " + busybox + " /data/local/tmp", stdout=dev_null, shell=True)
    subprocess.call(adb + "shell chmod 755 /data/local/tmp/busybox", stdout=dev_null, shell=True)
    print("Successfully copied Busybox to your " + device + ".")


def start_telnet_server():
    print("")
    print("Starting Telnet server on your " + device + ".")

    out = subprocess.check_output(adb + "shell dumpsys power", shell=True)
    if python3:
        out = out.decode("utf-8")
    print_debug(out)

    check_device_powered(out)
    print("")
    print("Please turn on your " + device + " now and unlock the screen. Only hit ENTER when the screen of your " + device + " is unlocked!")
    wait_for_enter_start()
    print("")
    print("Don't touch the screen! I'm taking it over now ;-)")

    if debug:
        subprocess.call(adb +       'shell input keyevent KEYCODE_HOME',          shell=True)
        sleep(1.5)
        subprocess.call(adb +       'shell am start -n com.mediatek.engineermode/.EngineerMode com.mediatek.connectivity/.CdsInfoActivity\n', shell=True)
        sleep(0.5)
        for _ in range(4):
            subprocess.call(adb +   'shell input keyevent KEYCODE_DPAD_DOWN',     shell=True)
            sleep(0.1)
        subprocess.call(adb +       'shell input keyevent KEYCODE_ENTER',         shell=True)
        sleep(0.1)
        subprocess.call(adb +       'shell input text "/data/local/tmp/busybox"', shell=True)
        sleep(0.1)
        subprocess.call(adb +       'shell input keyevent KEYCODE_SPACE',         shell=True)
        sleep(0.1)
        subprocess.call(adb +       'shell input text "telnetd"',                 shell=True)
        sleep(0.1)
        subprocess.call(adb +       'shell input keyevent KEYCODE_SPACE',         shell=True)
        sleep(0.1)
        subprocess.call(adb +       'shell input text "-l"',                      shell=True)
        sleep(0.1)
        subprocess.call(adb +       'shell input keyevent KEYCODE_SPACE',         shell=True)
        sleep(0.1)
        subprocess.call(adb +       'shell input text "/system/bin/sh"',          shell=True)
        sleep(0.1)
        subprocess.call(adb +       'shell input keyevent KEYCODE_SPACE',         shell=True)
        sleep(0.1)
        subprocess.call(adb +       'shell input text "-p"',                      shell=True)
        sleep(0.1)
        subprocess.call(adb +       'shell input keyevent KEYCODE_SPACE',         shell=True)
        sleep(0.1)
        subprocess.call(adb +       'shell input text "1234"',                    shell=True)
        sleep(0.1)
        subprocess.call(adb +       'shell input tap 50 200',                     shell=True)
        sleep(0.1)
    else:
        subprocess.call(adb +       'shell input keyevent KEYCODE_HOME',          shell=True)
        sleep(1.5)
        subprocess.call(adb +       'shell am start -n com.mediatek.engineermode/.EngineerMode com.mediatek.connectivity/.CdsInfoActivity\n', stdout=dev_null, shell=True)
        sleep(0.5)
        for _ in range(4):
            subprocess.call(adb +   'shell input keyevent KEYCODE_DPAD_DOWN',     stdout=dev_null, shell=True)
            sleep(0.1)
        subprocess.call(adb +       'shell input keyevent KEYCODE_ENTER',         stdout=dev_null, shell=True)
        sleep(0.1)
        subprocess.call(adb +       'shell input text "/data/local/tmp/busybox"', stdout=dev_null, shell=True)
        sleep(0.1)
        subprocess.call(adb +       'shell input keyevent KEYCODE_SPACE',         stdout=dev_null, shell=True)
        sleep(0.1)
        subprocess.call(adb +       'shell input text "telnetd"',                 stdout=dev_null, shell=True)
        sleep(0.1)
        subprocess.call(adb +       'shell input keyevent KEYCODE_SPACE',         stdout=dev_null, shell=True)
        sleep(0.1)
        subprocess.call(adb +       'shell input text "-l"',                      stdout=dev_null, shell=True)
        sleep(0.1)
        subprocess.call(adb +       'shell input keyevent KEYCODE_SPACE',         stdout=dev_null, shell=True)
        sleep(0.1)
        subprocess.call(adb +       'shell input text "/system/bin/sh"',          stdout=dev_null, shell=True)
        sleep(0.1)
        subprocess.call(adb +       'shell input keyevent KEYCODE_SPACE',         stdout=dev_null, shell=True)
        sleep(0.1)
        subprocess.call(adb +       'shell input text "-p"',                      stdout=dev_null, shell=True)
        sleep(0.1)
        subprocess.call(adb +       'shell input keyevent KEYCODE_SPACE',         stdout=dev_null, shell=True)
        sleep(0.1)
        subprocess.call(adb +       'shell input text "1234"',                    stdout=dev_null, shell=True)
        sleep(0.1)
        subprocess.call(adb +       'shell input tap 50 200',                     stdout=dev_null, shell=True)
        sleep(0.1)

    print("Checking, if telnet server is started. If the tool crashes now, try to start telnet server manually by clicking on 'Run'.")
    if windows:
        out = subprocess.check_output(adb + 'shell ps | findstr "\/data/local/tmp/busybox"', shell=True)
    else:
        out = subprocess.check_output(adb + 'shell ps | grep "/data/local/tmp/busybox"', shell=True)
    if python3:
        out = out.decode("utf-8")
    print_debug(out)
    if "/data/local/tmp/busybox" not in out:
        print("E: Telnet server was NOT started on the tablet. If you keep on getting this error, busybox was not pushed onto tablet.")
        print("Retrying now.")
        start_telnet_server()

    print("Successfully started Telnet server on your " + device + ".")
    print("")


def check_dumchar_info():
    p = subprocess.Popen(adb + "shell", stdin=subprocess.PIPE, stdout=subprocess.PIPE, shell=True)
    if python3:
        p.stdin.write(bytes("/data/local/tmp/busybox telnet 127.0.0.1 1234 | cat /proc/dumchar_info\n", "utf-8"))
        p.stdin.write(bytes("exit\n", "utf-8"))
        p.stdin.write(bytes("exit\n", "utf-8"))
    else:
        p.stdin.write("/data/local/tmp/busybox telnet 127.0.0.1 1234 | cat /proc/dumchar_info\n")
        p.stdin.write("exit\n")
        p.stdin.write("exit\n")
    p.stdin.flush()

    string_found = False
    for _ in range(25):
        out = p.stdout.readline()
        if python3:
            out = out.decode("utf-8")
        print_debug(out)
        if a1:
            if "android" in out and \
               "0x0000000004500000" in out and \
               "0x0000000040000000" in out and \
               " 2 " in out and \
               "/dev/block/mmcblk0p5" in out:
                string_found = True
                break
        elif b1_710:
            if "android" in out and \
               "0x0000000040000000" in out and \
               "0x00000000024e8000" in out and \
               " 2 " in out and \
               "/dev/block/mmcblk0p3" in out:
                string_found = True
                break
        else:
            if "android" in out and \
               "0x00000000020e8000" in out and \
               " 2 " in out and \
               "/dev/block/mmcblk0p3" in out:
                if "0x0000000015e00000" in out:
                    print("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!")
                    print("Your device has 'android 0x0000000015e00000 0x00000000020e8000 2 /dev/block/mmcblk0p3' in dumchar_info. Continuing could brick your device!")
                    print("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!")
                    wait_for_enter_start()
                elif not "0x0000000026500000" in out:
                   continue
                string_found = True
                break

    if not string_found:
        if a1:
            print("E: The line 'android 0x0000000004500000 0x0000000040000000 2 /dev/block/mmcblk0p5' wasn't found in /proc/dumchar_info.")
        if b1_710:
            print("E: The line 'android 0x0000000040000000 0x00000000024e8000 2 /dev/block/mmcblk0p3' wasn't found in /proc/dumchar_info.")
        else:
            print("E: The line 'android 0x0000000026500000 0x00000000020e8000 2 /dev/block/mmcblk0p3' wasn't found in /proc/dumchar_info.")
            print("E: The line 'android 0x0000000015e00000 0x00000000020e8000 2 /dev/block/mmcblk0p3' wasn't found in /proc/dumchar_info.")
        print("YOUR PARTITION SETTING IS NOT SUPPORTED, YET!")
        wait_for_enter_exit_error()


def check_firmware_version():
    print("")
    print("Checking firmware version.")
    build_prop = "build.prop"

    if  debug:
        subprocess.call(adb + "pull /system/build.prop", shell=True)
    else:
        subprocess.call(adb + "pull /system/build.prop", stdout=dev_null, shell=True)

    try:
        with open("build.prop"):
            print_debug("Successfully pulled build.prop.")
    except IOError:
        print("E: Failed to check firmware version: 'adb pull /system/build.prop' failed.")
        wait_for_enter_exit_error()

    f = open(build_prop, "r")
    lines = f.readlines()
    for l in lines:
        if l.startswith("ro.build.pandora.id="):
            if a1:
                fw_version = l.split("Acer_AV052_A1-810_")[1].split("_WW_GEN1")[0]
            elif b1_710:
                if "Acer_AV051_B1-710_" in l:
                    fw_version = l.split("Acer_AV051_B1-710_")[1].split("_WW_GEN1")[0]
                else:
                    fw_version = l.split("Acer_AV051_B1-A710_")[1].split("_WW_GEN1")[0]
            else:
                fw_version = l.split("Acer_AV051_B1-A71_")[1].split("_WW_GEN1")[0]
            print("Firmware version '" + fw_version + "' installed. MAKE SURE YOUR system.img.gz IN system_image FOLDER IS OF THE SAME VERSION, OTHERWISE YOU GET A BOOTLOOP!")
            break
    f.close()
    os.remove(build_prop)

def check_adb():
    global a1

    p = subprocess.Popen(adb + "devices", stdin=subprocess.PIPE, stdout=subprocess.PIPE, shell=True)
    print("")
    print("Trying to establish ADB Connection...")
    p.wait()

    found = False
    for _ in range(4):
        out = p.stdout.readline()
        if python3:
            out = out.decode("utf-8")
        print_debug(out)
        if "0123456789ABCDEF" in out:
            found = True
            break
        elif a1:
            regexp = re.compile(r'[a-zA-Z0-9]{16}\s+device')
            if regexp.search(out) is not None:
                found = True
                print_debug("Device ID is: " + out[:16])
                break

    if found:
        print("ADB Connection to your " + device + " successful.")
    else:
        print("E: Couldn't connect to your " + device + " over adb. Plug-In the device with USB-Debugging Mode turned on.")
        if windows:
            print("Check if drivers are properly installed.")
        wait_for_enter_exit_error()

def push_system_image():
    print("Copying rooted system.img.gz to your " + device + " (This will take 1-2 minutes)...")
    wait_for_enter_start()

    try:
        with open(os.path.join("system_image", "system.img.gz")):
            print_debug("system.img.gz found in folder 'system_image'.")
    except IOError:
        print("E: No system.img.gz found in folder 'system_image' in toolkit directory.")
        wait_for_enter_exit_error()

    if debug:
        p = subprocess.Popen(adb + "shell", stdin=subprocess.PIPE, shell=True)
    else:
        p = subprocess.Popen(adb + "shell", stdin=subprocess.PIPE, stdout=dev_null, shell=True)
    if python3:
        p.stdin.write(bytes("/data/local/tmp/busybox telnet 127.0.0.1 1234\n", "utf-8"))
        p.stdin.write(bytes("chmod 777 /cache\n", "utf-8"))
        p.stdin.write(bytes("chmod 777 /cache/system.img.gz\n", "utf-8")) # in case system.img.gz already exists
        p.stdin.flush()
        sleep(3)
        p.stdin.write(bytes("exit\n", "utf-8"))
        p.stdin.write(bytes("exit\n", "utf-8"))
    else:
        p.stdin.write("/data/local/tmp/busybox telnet 127.0.0.1 1234\n")
        p.stdin.write("chmod 777 /cache\n")
        p.stdin.write("chmod 777 /cache/system.img.gz\n") # in case system.img.gz already exists
        p.stdin.flush()
        sleep(3)
        p.stdin.write("exit\n")
        p.stdin.write("exit\n")
    p.stdin.flush()

    if debug:
        subprocess.call(adb + "push " + system_image + " /cache", shell=True)
    else:
        subprocess.call(adb + "push " + system_image + " /cache", stdout=dev_null, shell=True)
    p = subprocess.Popen(adb + "shell ls /cache", stdout=subprocess.PIPE, shell=True)
    p.wait()
    found = False
    out = p.stdout.readlines()
    for o in out:
        if python3:
            o = o.decode("utf-8")
        print_debug(o)
        if "system.img.gz" in o:
            found = True
            if not debug:
                break

    if found:
        print("Successfully copied system.img.gz to /cache")
    else:
        print("Failed to copy system.img.gz. Make sure the folder 'system_image' of this toolkit contains a system.img.gz suiting to your installed firmware.")
        wait_for_enter_exit_error()

def start_info():
    if windows:
        print("Before we can start, please do following:")
        print("1. Make sure drivers for your " + device + " are installed, you can find them here: " + driver_url)
        print("2. Plug-In your " + device + " into this PC.")
        print("3. Enable USB Debugging Mode by going into Settings -> Developer Tools.")
        print("4. Put prerooted system.img.gz into folder: system_image of this toolkit.")
        print("5. Keep your device plugged in until it's finally rooted, or this procedure is aborted!")
        if a1:
            print("6. !!! UNPLUG ALL OTHER DEVICES!!!")
        print("")
        print("If you sucessfully applied the steps above, we can now start.")
        print("You can always abort by pressing Ctrl+C")
        print("")
    else:
        print("Before we can start, please do following:")
        print("1. Plug-In your " + device + " into this PC.")
        print("2. Enable USB Debugging Mode by going into Settings -> Developer Tools.")
        print("3. Keep your device plugged in until it's finally unrooted, or this procedure is aborted!")
        if a1:
            print("4. !!! UNPLUG ALL OTHER DEVICES!!!")
        print("")
        print("If you sucessfully applied the steps above, we can now start.")
        print("You can always abort by pressing Ctrl+C")
        print("")

def wait_for_enter_start():
    print("")
    print("[ENTER] Continue")
    print("[Q]     Quit")
    print("")

    if python3:
        selection = input("Enter a selection: ")
    else:
        selection = raw_input("Enter a selection: ")

    if selection.lower() == "q":
        sys.exit(0)

def wait_for_enter_exit_success():
    print("")
    if python3:
        input("Press Enter to leave Application...")
    else:
        raw_input("Press Enter to leave Application...")
    sys.exit(0)

def wait_for_enter_exit_error():
    if not debug:
        print("")
        print("If you keep getting this error, try to run toolkit with -d or --debug parameter")
    if python3:
        input("Press Enter to leave Application...")
    else:
        raw_input("Press Enter to leave Application...")
    sys.exit(1)

def print_thanks():
    print("Thanks to XDA: pawitp, alba81, bullbrand, sodaFR, MatrixDJ96, ak6, min-dfreak, agentdeep, nick_1964, sampod and you ;-)")

def print_debug(string):
    if debug:
        print(string)

def check_device_powered(out):
    if a1:
        return

    # device in standby? -> Wake up
    sleeping = True
    while sleeping:
        # device turned off
        if "mPowerState=0" in out:
            subprocess.call(adb + "shell input keyevent KEYCODE_POWER", stderr=dev_null, stdout=dev_null, shell=True)
        sleep(1)
        # device in lockscreen? -> Request Unlock
        if "mPowerState=3" not in out:
            print("PLEASE UNLOCK THE SCREEN OF YOUR TABLET!")
            wait_for_enter_start()
            sleep(0.5)

            out = subprocess.check_output(adb + "shell dumpsys power", shell=True)
            if python3:
                out = out.decode("utf-8")
            print_debug(out)
        else:
            sleeping = False
    # TODO: test this


if __name__ == "__main__":
    main()
