/*
 *  BGCore
 *  
 *  Sources may not be modified, distributed, copied, or compiled
 *  in partial or in full, without explicit written approval from
 *  Bight Interactive Inc.
 *
 *  Copyright 2006-2011 Bight Interactive Inc. All rights reserved.
 *
 */


precision mediump float;
precision mediump int;

// Attributes
attribute highp vec4 position;
attribute lowp vec3 normals;
attribute vec2 uvs;
attribute vec2 uvs2;

#ifdef DIFFUSEVERTEX
attribute lowp vec4 colourRGBA;
#endif

#ifdef SKINNING
#define NUM_JOINTS_PER_VERTEX 4

attribute vec4 skinIndicies;
attribute vec4 skinWeights;

uniform mat4 joints[30];
#endif

#ifdef NORMALTEXTURE
attribute vec3 tangents;
attribute vec3 binormals;
#endif

// Uniforms
uniform mat4 matWorldViewProj;
uniform mat4 matView;
uniform mat4 matWorld;
uniform mat4 matWorldView;
uniform mat4 matWorldViewInv;

#if defined(NORMALTEXTURE) || defined(NORMALVERTEX)
uniform vec3 lightPos;
uniform vec3 viewPos;
uniform vec3 lightDir;
#endif

// Varying
#ifdef DIFFUSETEXTURE
varying vec2 v_texCoord;
#elif defined(BLENDTEXTURE)
varying vec2 v_texCoord;
#endif

#ifdef UVS2VERTEX
varying vec2 v_texCoord2;
#endif

#if (defined(NORMALTEXTURE) || defined(NORMALVERTEX)) && !defined(CONSTANT)
varying lowp vec3 v_normals;
#endif

#if defined(MAX_POINT_LIGHTS)
uniform vec3 pointLightPos[MAX_POINT_LIGHTS]; 
varying vec3 v_PointLightDiff[MAX_POINT_LIGHTS];
uniform int lnNumPointLights;
#endif

#if defined(MAX_SPOT_LIGHTS)
uniform vec3 spotLightPos[MAX_SPOT_LIGHTS]; 
varying vec3 v_SpotLightDiff[MAX_SPOT_LIGHTS];
uniform int lnNumSpotLights;
#endif

#if defined(NORMALTEXTURE) || defined(NORMALVERTEX) && !defined(CONSTANT)
	varying vec3 v_lightvec;
#endif

#if defined(SPECULAR) || defined(BLINN)
	varying vec3 v_viewDiff;
#endif

#ifdef DIFFUSEVERTEX
varying lowp vec4 v_vertexColour;
#endif

#if defined(NORMALTEXTURE)
void CalculateTangentSpaceLightView(vec4 lWorldViewPos, vec3 lNormal)
{
	mat3 lTangentMatrix = mat3(tangents, binormals, lNormal);
	v_lightvec = normalize(lTangentMatrix * lightDir);
	v_viewDiff = viewPos - lWorldViewPos.xyz;
	v_viewDiff = normalize(lTangentMatrix * v_viewDiff);
}
#endif

void main()
{ 
	#if defined(SKINNING)
		gl_Position = (position * joints[int(skinIndicies.x)])  * skinWeights.x;
		gl_Position += (position * joints[int(skinIndicies.y)]) * skinWeights.y;
		gl_Position  = gl_Position * matWorldViewProj;
		
		#if defined(NORMALTEXTURE) || defined(NORMALVERTEX) && !defined(CONSTANT)
		v_normals	= normalize(normals * mat3(matWorld));
		#endif
		// Only use this if we want skinned normals
		//v_normals = (normals * mat3(joints[int(skinIndicies.x)]))  * skinWeights.x;
		//v_normals += (normals * mat3(joints[int(skinIndicies.y)])) * skinWeights.y;
		//v_normals = normalize(v_normals * mat3(matWorldView));
	
	#endif
	#ifndef SKINNING
		gl_Position		= vec4(position.xyz, 1) * matWorldViewProj;

		#if (defined(NORMALTEXTURE) || defined(NORMALVERTEX)) && !defined(CONSTANT)
		v_normals		= normalize(normals * mat3(matWorld));
		#endif
	#endif
		
	// Calculate the normals
	#if defined(NORMALTEXTURE)
		vec4 worldViewPos;
		worldViewPos	= gl_Position * matWorldView;
		CalculateTangentSpaceLightView(worldViewPos, v_normals);
	#elif defined(NORMALVERTEX) && !defined(CONSTANT)
		v_lightvec = lightDir;
		normalize(v_lightvec);
		#if defined(SPECULAR) || defined(BLINN)
		vec4 worldPos;
		worldPos   = position * matWorld;
		v_viewDiff = normalize(viewPos.xyz - worldPos.xyz);
		#endif
	#endif
		
	// if we have point lights then process them
	#if defined(MAX_POINT_LIGHTS)
	for(int i = 0; i < lnNumPointLights; i++)
	{
		v_PointLightDiff[i] = pointLightPos[i] - worldPos.xyz;
	}
	#endif
	
	// if we have spot lights then process them
	#if defined(MAX_SPOT_LIGHTS)
	for(int i = 0; i < lnNumSpotLights; i++)
	{
		v_SpotLightDiff[i] = spotLightPos[i] - worldPos.xyz;
	}
	#endif
	
	#ifdef DIFFUSETEXTURE
		v_texCoord = uvs;
	#elif defined BLENDTEXTURE
		v_texCoord = uvs;
	#endif
	
	#ifdef UVS2VERTEX
		v_texCoord2 = uvs2;
	#endif
	
	#ifdef DIFFUSEVERTEX
		v_vertexColour = colourRGBA;
	#endif
}
