@echo off
COLOR 81
:MENU
cls
@echo *****************************************
@echo *            TAR.MD5 PACKAGER           *
@echo *****************************************
@echo * By A.S._id                            *
@echo *                                       *
@echo * To Use put ROM.tar.md5 in \in folder. *
@echo * Place Partitions  files in \parts.    *
@echo *                                       *
@echo * This Script will package a ROM        *
@echo * for flashing via Oidin.               *
@echo *                                       *
@echo * Options:                              *
@echo *                                       *
@echo * 1. Make TAR                           *
@echo * 2. Add MD5 to TAR                     *
@echo * 3. Extract ROM                        *
@echo * 4. Exit                               *
@echo *****************************************
CHOICE /C:1234 /N /M "Please Select Option:"
IF ERRORLEVEL 4 GOTO EXIT
IF ERRORLEVEL 3 GOTO EXTRACT
IF ERRORLEVEL 2 GOTO MD5
IF ERRORLEVEL 1 GOTO MTAR

:MTAR
CLS
@echo *****************************************
@echo *               MAKE TAR                *
@echo *****************************************
@echo * Partitions File needs to be in \parts *
@echo * Continuing will make TAR archive      *
@echo *****************************************
SET INPUT=
SET /P INPUT=Enter Name Of Your TAR package (ex MY_REPACK_ROM) : %=%
CHOICE /C YN /M "WARNING: Do you wish to Continue? (This will Delete any TAR files in \packaged)"
IF ERRORLEVEL 2 GOTO MENU
IF EXIST parts\.* (
 IF EXIST packaged\*.tar ( del packaged\*.tar /q )
 @echo PACKAGING %INPUT%.tar...
cd %~dp0parts
  ..\bin\tar.exe -c * >> ..\packaged\%INPUT%.tar )
@echo %INPUT% has been packaged.
cd %~dp0packaged  
   ..\bin\ls.exe -l
cd %~dp0 
) ELSE ( @echo "ERROR: PACKAGING does not exist" )
pause
goto MENU

:MD5
cls
@echo *****************************************
@echo *         ADD MD5 to TAR                *
@echo *****************************************
@echo * Tar File needs to be in \packaged     *
@echo * Continuing will add md5sum in tar     *
@echo * an Oidin compatible MD5.              *
@echo *****************************************
IF NOT EXIST packaged\*.tar (
 @echo ERROR: No Files Found to add!
 pause
 goto MENU
)
@echo off > 1.tmp
setLocal EnableDelayedExpansion
SET #=0
FOR /f "tokens=*" %%D in ('dir /b/a packaged\*.tar') DO (
 SET /a #+=1
 echo [!#!] %%D >> 1.tmp )
TYPE 1.tmp
SET /p dirFILE=Choose a TAR for add MD5: 
FIND "[!dirFILE!]" < 1.tmp > 2.tmp
FOR /f "tokens=2*" %%T in (2.tmp) do ( set file=%%~nxT)
DEL *.tmp /q
CHOICE /C YN /M "WARNING: Do you wish to Continue? (This will add %file% deleting %file%.md5 if it exists)"
IF ERRORLEVEL 2 GOTO MENU
CD packaged
IF EXIST %file%.md5 ( del %file%.md5 /q /f )
@echo ADD MD5 to TAR
..\bin\md5sum.exe -t %file% >> %file% 2>nul
REN %file% %file%.md5
@echo Finished. Output file is %file%.md5
cd %~dp0packaged  
   ..\bin\ls.exe -l
cd %~dp0 
pause
goto MENU

:EXTRACT
cls
@echo *****************************************
@echo *           Extract TAR.MD5             *
@echo *****************************************
@echo * TAR.MD5 needs to be in \in folder.    *
@echo * Continuing will uncompress the file   *
@echo * into the \in folder.                  *
@echo *****************************************
IF NOT EXIST *.tar (
 IF NOT EXIST *.md5 (
  @echo ERROR: No Files Found to Extract!
  pause
  goto MENU
 )
)
@echo off > 1.tmp
setLocal EnableDelayedExpansion
SET #=0
IF EXIST *.tar (
 FOR /f "tokens=*" %%D in ('dir /b/a *.tar') DO (
  SET /a #+=1
  echo [!#!] %%D >> 1.tmp )
)
IF EXIST *.md5 (
 FOR /f "tokens=*" %%D in ('dir /b/a *.md5') DO (
  SET /a #+=1
  echo [!#!] %%D >> 1.tmp )
)
TYPE 1.tmp
SET /p dirFILE=Choose a TAR.MD5 to Extract: 
FIND "[!dirFILE!]" < 1.tmp > 2.tmp
FOR /f "tokens=2*" %%T in (2.tmp) do ( set file=%%~nxT)
DEL *.tmp /q
CHOICE /C YN /M "WARNING: Do you wish to Continue? (This will extract %file% and overwrite any files in \parts)"
IF ERRORLEVEL 2 GOTO MENU
@echo Extracting....
cd parts
del *.* /f /q
..\bin\tar.exe -xf ../%file%
@echo %file% has been extracted.
cd %~dp0parts
  ..\bin\ls -l
cd %~dp0
pause
goto MENU

:EXIT
@echo Good-Bye
pause
exit